<?php
 // ====================
 // === Classe LPers ===
 // ====================
 class LPers {
  const NON_TROUVE = '-1' ;
  const REP_SAUVE  = "../../Sauvegardes/" ;
  // Propriété
  private $_LP = array();// Liste des personnes
  // ------------------------------  
  // Méthode de saisie de la liste des personnes
  public function SaisieLPers() {
   $nom="";
   while(!(is_null($nom))) {
     $Pers = new Personne();
     $Pers->Saisie()       ; 
     $nom = $Pers->_nom    ; 
     if(!(is_null($nom))) $this->_LP[]=$Pers;
   }
  } // Fin de SaisieLPers
  // ------------------------------  
  // Méthode d'affichage de la liste des personnes
  public function AfficheLPers() {
   if (count($this->_LP) == 0) {
    echo "Aucune personne à afficher !".PHP_EOL;
   }
   else {
    $this->AfficheTabPersonnes($this->_LP);
   }
  } // Fin de AfficheLPers
  // ------------------------------  
  // Méthode outils d'affichage d'une liste de personnes
  private function AfficheTabPersonnes($ListeP) {
    // entête de l'affichage
    echo "----------------------------\n";
    echo "ID :\tNom\tPrénom\tAge\n";
    echo "----------------------------\n";
    foreach($ListeP as $indice => $Pers) {
     echo "$indice :\t";
     $Pers->Affiche();
    }
    echo "----------------------------\n";
  } // Fin de AfficheTabPersonnes
  // ------------------------------  
  // Méthode de sauvegarde de la liste des personnes
  public function SauveLPers() {
   try {
    $nbpers=count($this->_LP);
    if ($nbpers == 0)
       throw new Exception("Aucune personne à sauvegarder !");
    echo "Nom du fichier de sauvegarde : ";
    $NomF = fgets(STDIN);
    $NomF = trim($NomF) ;
    if (empty($NomF))
       throw new Exception("Erreur : Fichier inaccessible !");
    // Construction du nom du fichier
    $NomF = self::REP_SAUVE.$NomF;
    // Sérialisation et sauvegarde
    $ChaineLPers1 = serialize($this->_LP) ;
    file_put_contents($NomF,$ChaineLPers1);
    echo $nbpers." personne(s) sauvegardée(s) dans le fichier ".$NomF.PHP_EOL;
   }
   catch(Exception $e){
    echo $e->getMessage().PHP_EOL;
   }
  } // Fin de SauveLPers
  // ------------------------------  
  // Méthode de chargement de la liste des personnes
  public function ChargeLPers() {
   try {
    echo "Nom du fichier à charger : ";
    $NomF = fgets(STDIN);
    $NomF = trim($NomF) ;
    if (empty($NomF))
       throw new Exception("Erreur : Fichier non trouvé !");
    // Construction du nom du fichier
    $NomF = self::REP_SAUVE.$NomF;
    // Sérialisation et sauvegarde
    if (file_exists($NomF)) {
     $ChaineLPers = file_get_contents($NomF) ;
     $this->_LP   = unserialize($ChaineLPers);
     $nbpers=count($this->_LP);
     echo $nbpers." personne(s) lue(s) à partir du fichier ".$NomF.PHP_EOL;
    }
    else
     echo "Fichier $NomF non trouvé !".PHP_EOL;
   }
   catch(Exception $e){
    echo $e->getMessage().PHP_EOL;
   }
  } // Fin de ChargeLPers
 } // Fin de la classe LPers
?>
