<?php
 interface EntrepriseI { }
 class Entreprise implements EntrepriseI {}
 trait EntrepriseT {}


 // === Classe Personnel ===
 class Personnel
 { // -- Les propriétés --
   protected $nom    ;
   protected $prenom ;
   // -- constructeur --
   function __construct($n,$p)
   { $this->nom    = strtoupper(trim($n)) ;
     $this->prenom = strtoupper(trim($p)) ;
   }
   public function Affiche() {
     echo "Nom:".$this->nom;
     echo "  -  Prenom: ".$this->prenom.PHP_EOL;
   }   
 }
 // === Classe Cadre ===
 class Cadre extends Personnel
 { // -- Les propriétés --
   private $_tel="0122334455"   ;
   public $fonction="Responsable commercial"   ;
   // -- constructeur --
   function __construct($n,$p,$t)
   { parent::__construct($n,$p); //constructeur parent
     $this->_tel   = trim($t) ;
   }
   public function Affiche() {  // surcharge
     parent::Affiche();
     echo "  -  Tel: ".$this->_tel.PHP_EOL;
   }
   static public function NEntrp() {
     echo "JML".PHP_EOL;
     $c=get_called_class();
     return $c;
   }
 }
  // === Classe Directeur ===
 class Directeur extends Cadre
 { // -- Les propriétés --
   private $_assistant   ;
   // -- constructeur --
   function __construct($n,$p,$t,$a)
   { parent::__construct($n,$p,$t); //constructeur parent
     $this->_assistant   = trim($a) ;
   }
   public function Affiche() {  // surcharge
     parent::Affiche();
     echo "  -  Assistant: ".$this->_assistant.PHP_EOL;
   }   
 }
 // === Programme ===
 $UnSalarie = new Personnel("martin","pierre") ;
 echo "--- Salarie ---".PHP_EOL;
 $UnSalarie->Affiche() ;//Méthode de la Classe Personnel
 $UnCadre = new Cadre("dupont","jean","0143451122")   ;
 echo "--- Cadre ---".PHP_EOL;
 $UnCadre->Affiche() ;// Méthode de la Classe Cadre
 $UnDirecteur = new Directeur("lefevre","paul","0600112233","pignon")   ;
 echo "--- Directeur ---".PHP_EOL;
 $UnDirecteur->Affiche() ;// Méthode de la Classe Directeur
 
 echo "=== fonctions ===".PHP_EOL;
 $CadE=class_exists(Cadre);
 echo "class_exists : Cadre : ";
 var_dump($CadE);
 $CadE=class_exists('Cadre');

 echo "get_class_methods : Cadre : ".PHP_EOL;
 $tabM=get_class_methods('Cadre');
 foreach ($tabM as $etiquette=>$NomMethod)
    echo "   $etiquette : $NomMethod".PHP_EOL;

 echo "get_class_vars : Cadre : ".PHP_EOL;
 $tabV=get_class_vars('Cadre');
 foreach ($tabV as $etiquette=>$NomVar)
    echo "   $etiquette : $NomVar".PHP_EOL;

 echo "get_class_vars : Cadre : ".PHP_EOL;
 $tabV=get_class_vars('Cadre');
 foreach ($tabV as $etiquette=>$NomVar)
    echo "   $etiquette : $NomVar".PHP_EOL;

 echo 'get_class : $UnCadre : '.PHP_EOL;
 $NomC=get_class($UnCadre);
 var_dump($NomC);

 echo 'get_object_vars : $UnCadre : '.PHP_EOL;
 $TabV=get_object_vars($UnCadre);
 var_dump($TabV);

 echo 'get_declared_classes : '.PHP_EOL;
 $TDC=get_declared_classes();
 var_dump($TDC);

 echo 'get_declared_interfaces : '.PHP_EOL;
 $TDI=get_declared_interfaces();
 var_dump($TDI);

 echo 'get_declared_traits : '.PHP_EOL;
 $TDT=get_declared_traits();
 var_dump($TDT);
 
 echo 'get_parent_class : '.PHP_EOL;
 $PClasse=get_parent_class($UnCadre);
 var_dump($PClasse);
  
 echo 'is_subclass_of : Cadre - Personnel '.PHP_EOL;
 //$EstSC=is_subclass_of('Cadre','Personnel');
 $EstSC=is_subclass_of($UnCadre,'Personnel');
 var_dump($EstSC);

 echo 'interface_exists : Iterator '.PHP_EOL;
 $ExistI=interface_exists('Iterator');
 var_dump($ExistI);

 echo 'trait_exists : EntrepriseT '.PHP_EOL;
 $ExistT=trait_exists('EntrepriseT');
 var_dump($ExistT);
 
 echo 'classe_implements : Entreprise '.PHP_EOL;
 $TabI=class_implements('Entreprise');
 print_r($TabI);

 echo 'is_a : $UnCadre - Personnel '.PHP_EOL;
 $EstP=is_a($UnCadre,'Personnel');
 var_dump($EstP);

 echo 'method_exists : $UnCadre - Affiche '.PHP_EOL;
 $ME=method_exists($UnCadre,'Affiche');
 var_dump($ME);

 echo 'property_exists : Cadre - _tel '.PHP_EOL;
 $PE=property_exists('Cadre','_tel');
 var_dump($PE);

 $Classe=Cadre::NEntrp();
 echo "Classe=".$Classe.PHP_EOL;
 
 class_alias('Cadre', 'CD');
 $UnCad = new CD("kaczma","sylvie","0699113322")   ;
 $UnCad->Affiche() ;// Méthode de la Classe Cadre

 echo 'is_object : $UnCadre '.PHP_EOL;
 $EstO=is_object($UnCadre);
 var_dump($EstO);
?>