<?php
// On démarre la session AVANT d'écrire du code HTML
// afin de conserver l'information indiquant si c'est le premier accès
// et afin de transmettre le tableau des personnes
session_start();
include 'INCLUDE/fonction_include_sprog_commun_web.php';
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Suppression d'une personne</title>
	<link href="CSS/traitement_liste_personnes_1page.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   $tab_personnes = $_SESSION['tab_personnes'];
   $nbpersonnes   = count($tab_personnes)     ;
   $_SESSION['nbpersonnes']=$nbpersonnes      ;
   // --------------------------------------------------------------
   // Cette page peut être appelée de plusieurs manières différentes
   // --------------------------------------------------------------
   if (!empty($_POST['confirmer_suppression']))
   {
    // --------------------------------------------------------------
    // Traitement de la réponse à la confirmation de suppression
    // --------------------------------------------------------------
    $Reponse_Suppression=$_POST['RepSuppr'];
    // --- Protection de l'injection HTML ---
    $Reponse_Suppression = strip_tags($Reponse_Suppression);
    if ($Reponse_Suppression == "oui")
    {
     // --------------------------------
     // La réponse est oui : on supprime
     // --------------------------------
     $numero_suppression=$_SESSION['numero_suppression'];
     $tab_a_Supprimer[$numero_suppression]=$tab_personnes[$numero_suppression];
     affichage_tab_personnes("Cette personne a &eacute;t&eacute; supprim&eacute;e",$tab_a_Supprimer);
     unset($tab_personnes[$numero_suppression]);
     $_SESSION['tab_personnes']=$tab_personnes ;
     $_SESSION['sauvegarde_a_faire']=true      ;
    }
    else
    {
     // ------------------------------------
     // La réponse est non : on ne fait rien
     // ------------------------------------
     ?>
     <fieldset>
     <legend>Aucune personne supprim&eacute;e :</legend><br/>
     <b>Aucune personne n'a &eacute;t&eacute; supprim&eacute;e ! </b><br />
     </fieldset>
     <?php
    }
   }
   elseif (!empty($_POST['choix_suppression_personne']))
   {
    // --------------------------------------------------------------
    // cas où la personne à supprimer a été sélectionnée
    // on demande la confirmation de la suppression
    // --------------------------------------------------------------
    $numero_suppression=$_POST['NumSuppr']             ;
    // --- Protection de l'injection HTML ---
    $numero_suppression = strip_tags($numero_suppression);
    $_SESSION['numero_suppression']=$numero_suppression;

    $tab_a_Supprimer[$numero_suppression]=$tab_personnes[$numero_suppression];
    affichage_tab_personnes("Personne à supprimer",$tab_a_Supprimer)         ;
    ?>
    <br/>
    <!-- <form action="fonction_suppression_web.php" method="post"> -->
    <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
    <fieldset>
     <legend>Confirmation de la suppression</legend><br/>
     Merci de confirmer la suppression de cette personne :<br/>
     Oui <input type="radio" name="RepSuppr" value="oui"> 
     Non <input type="radio" name="RepSuppr" value="non" checked="checked"> <br/><br/>
     <input type="submit" name="confirmer_suppression" value="Confirmer" />
     </fieldset>
    </form>
    <?php
   }
   elseif (!empty($_POST['rechercher_critere']))
   {
    // --------------------------------------------------------------
    // cas où le formulaire de saisie a été validé et on appelle
    // une nouvelle fois ce programme avec les données du formulaire
    // on affiche un formulaire pour sélectionner la personne à supprimer
    // parmi la liste des personnes affichées
    // --------------------------------------------------------------
    $crit_recherche = $_POST['CritRech'];
    $val_recherche  = $_POST['ValRech'] ;
    // --- Protection de l'injection HTML ---
    $crit_recherche = strip_tags($crit_recherche);
    $val_recherche  = strip_tags($val_recherche) ;
    // --- Recherche ---
    $tab_numero=Recherche_sur_critere($crit_recherche,$val_recherche,$tab_personnes);
    if (count($tab_numero) == 0)
    {
       ?>
       <fieldset>
       <legend>Aucune personne trouv&eacute;e :</legend><br/>
       <b>La recherche pour <?php echo "$crit_recherche=$val_recherche";?> n'a trouv&eacute; aucune personne ! </b><br />
       </fieldset>
       <?php
    }
    else
    {
       // extraction dans un tableau tab_num_personnes des personnes trouvées
       foreach($tab_numero as $numero)
       {
         $tab_num_personnes[$numero]=$tab_personnes[$numero];
       }
       // --- Affichage du tableau ---
       affichage_tab_personnes("Liste des personnes trouv&eacute;es",$tab_num_personnes);
       // affichage du formaulier de saisie de la personne à supprimer
       ?>
       <br/>
       <!-- <form action="fonction_suppression_web.php" method="post"> -->
       <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
        <fieldset>
        <legend>Saisissez le Num&eacute;ro de la personne &agrave; supprimer :</legend><br/>
        Entrez le <b>Num&eacute;ro</b> de la personne &agrave; supprimer : <input type="text" name="NumSuppr" size="20" maxlength="20" autofocus/><br/><br/>
        <input type="submit" name="choix_suppression_personne" value="Supprimer" />
        <!-- on ajoute le bouton terminer pour terminer la siaisie  -->
        <input type="reset" value="Effacer le formulaire" />
        </fieldset>
       </form>
       <?php
    }
   }
   else
   {
    // -----------------------------------------------
    // cas où on doit afficher le formulaire de saisie
    // pour rechercher la personne à supprimer
    // -----------------------------------------------
    if ($nbpersonnes == 0)
    {
       ?>
       <fieldset>
       <legend>Message :</legend><br/>
       <b>Actuellement il n'y a aucune personne en mémoire ! </b><br />
       </fieldset>
       <?php
    }
    else
    {  // --- formulaire de saisie des informations pour la recherche
       ?>
       <br/>
       <!-- <form action="fonction_suppression_web.php" method="post"> -->
       <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
       <fieldset>
        <legend>Saisissez les crit&egrave;res de recherche :</legend><br/>
        S&eacute;lectionnez le crit&egrave;re de recherche : <br/><br/>
        Identifiant <input type="radio" name="CritRech" value="ID"> 
        Nom <input type="radio" name="CritRech" value="Nom" checked="checked"> 
        Pr&eacute;nom <input type="radio" name="CritRech" value="Prenom"> 
        Age <input type="radio" name="CritRech" value="Age"> <br/><br/>
        Entrez la valeur selon le crit&egrave;re : <input type="text" name="ValRech" size="20" maxlength="20" autofocus/><br/><br/>
        <input type="submit" name="rechercher_critere" value="Rechercher" />
        <!-- on ajoute le bouton terminer pour terminer la siaisie  -->
        <input type="reset" value="Effacer le formulaire" />
        </fieldset>
       </form>
       <?php
    }
   }
   // ----------------------------------
   // -- lien pour retourner au menu ---
   // ----------------------------------
   include 'INCLUDE/fonction_include_retour_menu_web.php';
   ?>
 </body>
</html>
