<?php
// On démarre la session AVANT d'écrire du code HTML
// afin de conserver l'information indiquant si c'est le premier accès
// et afin de transmettre le tableau des personnes
session_start();
include 'INCLUDE/fonction_include_sprog_commun_web.php';
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Sauvegarde de la liste des personnes</title>
	<link href="CSS/traitement_liste_personnes_1page.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   // ------------------------------------------------------------------------------
   // si l'affichage de la page provient d'un sauvegarder, on effectue la sauvegarde
   // ------------------------------------------------------------------------------
   if (!empty($_POST['sauvegarder']))
   {
     // --- on récupère le nom du fichier ---
     if (isset($_POST['NomFichier'])) $NomFichier = $_POST['NomFichier'] ;
     else $NomFichier     = ''     ;
     // --- Protection de l'injection HTML ---
     $NomFichier    = strip_tags($NomFichier)    ;
     if (empty($NomFichier))
     {
      ?>
      <fieldset>
      <legend>Message :</legend><br/>
      <b>Sauvegarde impossible, le nom du fichier n'est pas indiqu&eacute; ! </b><br />
      </fieldset>
      <?php
     }
     else
     {
      // --- Tri du tableau ---
      $_SESSION['tab_personnes']=tri_tab_personnes($_SESSION['tab_personnes']);
      $tab_personnes=$_SESSION['tab_personnes'];
      // --- appel de la procédure de sauvegarde ---
      $nb_sauvegardes=Sauvegarde_tableau_fichier($tab_personnes,$NomFichier,true,"fonction_sauvegarde_web.php"); 
     }
   }
   // ---------------------------------------------------
   // Affichage du formulaire de saisie du nom du tableau
   // ---------------------------------------------------
   else
   {
    if (isset($_SESSION['tab_personnes'])) // on vérifie que le tableau existe = au moins une saisie
    {
      $tab_personnes=$_SESSION['tab_personnes'];
      $nb_sauvegardes=count($tab_personnes);
      if ($nb_sauvegardes != 0)
      {
       // -- on affiche le formulaire de saisie du nom du fichier de sauvegarde    
       ?>
       <br/>
       <!-- <form action="fonction_sauvegarde_web.php" method="post"> -->
       <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
        <fieldset>
        <legend>Saisissez le nom du fichier de sauvegarde :</legend><br/>
        Entrez le nom du fichier (ex : liste_personnes) : <input type="text" name="NomFichier" size="20" maxlength="20" autofocus/><br/><br/>
        <input type="submit" name="sauvegarder" value="Sauvegarder cette liste" />
        <!-- on ajoute le bouton terminer pour terminer la siaisie  -->
        <input type="reset" value="Effacer le nom du fichier" />
        </fieldset>
       </form>
       <?php
      }
      else
      {
       ?>
       <fieldset>
       <legend>Aucune donn&eacute;e</legend><br/>
       Aucune donn&eacute;e &agrave; sauvegarder <br/>
       </fieldset>
       <?php
      }
    }
    else
    {
      ?>
      <fieldset>
      <legend>Aucune donn&eacute;e</legend><br/>
      Aucune donn&eacute;e &agrave; sauvegarder <br/>
      </fieldset>
      <?php
    }
   }
   // ----------------------------------
   // -- lien pour retourner au menu ---
   // ----------------------------------
   include 'INCLUDE/fonction_include_retour_menu_web.php';
   ?>
 </body>
</html>