<?php
// On démarre la session AVANT d'écrire du code HTML
// afin de conserver l'information indiquant si c'est le premier accès
// et afin de transmettre le tableau des personnes
session_start();
include 'INCLUDE/fonction_include_sprog_commun_web.php';
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Saisie de plusieurs personnes</title>
	<link href="CSS/traitement_liste_personnes_1page.css" rel="stylesheet" type="text/css" /> 
	<link href="CSS/presentation_liste_personnes.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   if (!empty($_POST['terminer']))
   {
    // ----------------------------------
    // --- cas de la fin de la saisie ---
    // ----------------------------------
    // --- Tri du tableau ---
    $_SESSION['tab_personnes']=tri_tab_personnes($_SESSION['tab_personnes']);
    // --- affichage du résumé de la saisie ---
    $tab_personnes=$_SESSION['tab_personnes'];
    affichage_tab_personnes("Liste des personnes",$tab_personnes);
    // --- Lien pour le retour au menu principal ---
    include 'INCLUDE/fonction_include_retour_menu_web.php';
   }
   // -----------------------------------------------------------------------
   // sinon on affiche le formulaire et les informations complémentaires 
   // -----------------------------------------------------------------------
   else   
   {
     ?>
     <!--
     --------------------------------
     --- on affiche le formulaire ---
     --------------------------------
     -->
     <!-- <form action="fonction_saisie_web.php" method="post"> -->
     <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
      <fieldset>
      <legend>Saisissez les donn&eacute;es d'une nouvelle personne :</legend><br/>
      Entrez un identifiant : <input type="text" name="ID" size="10" maxlength="10" placeholder="123" autofocus pattern="[0-9]{1,10}" /><br/><br/>
      Entrez un nom : <input type="text" name="Nom" size="20" maxlength="20" placeholder="Dupont de Nemours"/><br/><br/>
      Entrez un pr&eacute;nom : <input type="text" name="Prenom" size="40" maxlength="40" placeholder="Jean Charles"/><br/><br/>
      Entrez un &acirc;ge : <input type="text" name="Age" size="3" maxlength="3" pattern="[1-9][0-9]{1,3}" placeholder="28"/><br/><br/>
      <input type="submit" name="valider" value="Valider cette personne" />
      <!-- on ajoute le bouton terminer pour terminer la saisie  -->
      <input type="reset" value="Effacer le formulaire" />
      <input type="submit" name="terminer" value="Terminer la Saisie" />
      </fieldset>
     </form>

     <?php
      include 'INCLUDE/fonction_include_retour_menu_web.php';
     // -----------------------------------------------------------------
     // on affiche sous le formulaire le résultat du traitement précédent
     // - soit le rangement dans le tableau tab_personnes
     // - soit un message d'erreur (sauf pour le premier affichage) 
     // -----------------------------------------------------------------
     // --- on récupère les valeurs saisies ---
     if (isset($_POST['ID'])) $ID = $_POST['ID'] ;
     else $ID     = ''      ;
     if (isset($_POST['Nom'])) $Nom = $_POST['Nom'] ;
     else $Nom     = ''     ;
     if (isset($_POST['Prenom'])) $Prenom = $_POST['Prenom'] ;
     else $Prenom     = ''  ;
     if (isset($_POST['Age'])) $Age = $_POST['Age'] ;
     else $Age     = ''     ;
     // --- Protection de l'injection HTML ---
     $Nom    = strip_tags($Nom)    ;
     $Prenom = strip_tags($Prenom) ;
     $ID     = strip_tags($ID)     ;
     $Age    = strip_tags($Age)    ;    
     // --- On conserve les valeurs initiales ---
     $InitNom    = $Nom    ;
     $InitPrenom = $Prenom ;
     $InitID     = $ID     ;
     $InitAge    = $Age    ;
     // si ce n'est pas la première saisie
     if ($_SESSION['Afficher_Messages_Champs'])
     {
      // ---------------------------------------
      // on vérifie qu'il n'y a aucun champ vide
      // ---------------------------------------
      if (!empty($InitNom) && !empty($InitPrenom) && !empty($InitAge) && !empty($InitID))
      {
       // ---------------------------------------
       // on vérifie la validité des chaque champ
       // ---------------------------------------
       $retourValidationID     = true ;
       $retourValidationAge    = true ;
       $retourValidationNom    = true ;
       $retourValidationPrenom = true ;
       if (!empty($InitID))
       {
        $InitID=normalisation_numerique($InitID)  ;
        $retourValidationID=validation_ID($InitID);
        if ($retourValidationID)
        {
         $ID  = intval($InitID) ;
        }
       }
       if (!empty($InitAge))
       {
        $InitAge=normalisation_numerique($InitAge)   ;
        $retourValidationAge=validation_Age($InitAge);
        if ($retourValidationAge)
        {
         $Age  = intval($InitAge) ;
        }
       }
       if (!empty($InitNom))
       {
        $InitNom=normalisation_nom($InitNom) ;
        $retourValidationNom=!empty($InitNom);
        if ($retourValidationNom)
        {
         $Nom  = $InitNom ;
        }
       }
       if (!empty($InitPrenom))
       {
        $InitPrenom=normalisation_nom($InitPrenom) ;
        $retourValidationPrenom=!empty($InitPrenom);
        if ($retourValidationPrenom)
        {
         $Prenom  = $InitPrenom ;
        }
       }
       // -------------------------------
       // si tous les champs sont valides
       // -------------------------------
       if (($retourValidationID) && ($retourValidationAge) && ($retourValidationNom) && ($retourValidationPrenom) )
       {
         unset($tab_personne_saisie);
         $tab_personne_saisie=array('ID'=>$ID,'Nom'=>$Nom,'Prenom'=>$Prenom,'Age'=>$Age) ;
         affichage_une_personne("Derni&egrave;re personne saisie",$tab_personne_saisie)  ;
         // -------------------------------------------------------------
         // --- rangement dans le tableau tab_personnes de la session ---
         // -------------------------------------------------------------
         $_SESSION['tab_personnes'][]=array('ID'=>$ID,'Nom'=>$Nom,'Prenom'=>$Prenom,'Age'=>$Age) ;
         // --- on indique que les données on été modifiées et qu'il faudra faire une sauvegarde ---
         $_SESSION['sauvegarde_a_faire']=true;
       }
      }
      // -----------------------------------------------------------------
      // on affiche les éventuels messages d'erreur en cas de champs vides
      // -----------------------------------------------------------------
      else
      {
       echo "<fieldset>";
       echo "<legend>Valeurs &agrave; renseigner :</legend><br/>";
       if (empty($InitID))     echo "Le champ Identifiant est vide".WEB_EOL;
       if (empty($InitNom))    echo "Le champ Nom est vide".WEB_EOL;
       if (empty($InitPrenom)) echo "Le champ Pr&eacute;nom est vide".WEB_EOL;
       if (empty($InitAge))    echo "Le champ Age est vide".WEB_EOL;
       if ($InitAge == 0)      echo "Le champ Age est invalide".WEB_EOL;
       echo "</fieldset>";
      }
     }
     // ------------------------------------------------------------------
     // ce n'est pas la première saisie : la variable indiquant d'afficher
     // les éventuels messages d'erreur est positionnée
     // ------------------------------------------------------------------
     else
     {
      $_SESSION['Afficher_Messages_Champs']=true;
     }
   }
   ?>
 </body>
</html>
