<?php
// On démarre la session AVANT d'écrire du code HTML
// afin de conserver l'information indiquant si c'est le premier accès
// et afin de transmettre le tableau des personnes
session_start();
include 'INCLUDE/fonction_include_sprog_commun_web.php';
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Recherche par nom</title>
	<link href="CSS/traitement_liste_personnes_1page.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   $tab_personnes = $_SESSION['tab_personnes'];
   $nbpersonnes = count($tab_personnes);
   $_SESSION['nbpersonnes']=$nbpersonnes;
   // --------------------------------------------------------------
   // Cette page peut être appelée de deux manières différentes :
   // - une première fois : le formulaire doit être renseigné
   // - une deuxième fois : le formulaire a été renseigné et les valeurs sont transmises
   // --------------------------------------------------------------
   if (!empty($_POST['rechercher_nom']))
   {
    // --------------------------------------------------------------
    // cas ou le formulaire a été validé et on appelle
    // une nouvelle fois ce programme avec les données du formulaire
    // --------------------------------------------------------------
     $nom_recherche=$_POST['NomRech'];
     // --- Protection de l'injection HTML ---
     $nom_recherche = strip_tags($nom_recherche);
     // --- recherche ---
     $tab_numero=Recherche_sur_critere('Nom',$nom_recherche,$tab_personnes);
     if (count($tab_numero) == 0)
     {
       ?>
       <fieldset>
       <legend>Aucune personne trouv&eacute;e :</legend><br/>
       <b>La personne ayant le nom <?php echo $nom_recherche;?> n'a pas &eacute;t&eacute; trouv&eacute;e ! </b><br />
       </fieldset>
       <?php
     }
     else
     {
       // extraction dans un tableau tab_num_personnes des personnes trouvées
       foreach($tab_numero as $numero)
       {
         $tab_num_personnes[$numero]=$tab_personnes[$numero];
       }
       // --- Affichage du tableau ---
       affichage_tab_personnes("Liste des personnes trouv&eacute;es",$tab_num_personnes);
     }
   }
   else
   {
    // -----------------------------------------------
    // cas ou on doit afficher le formulaire de saisie
    // -----------------------------------------------
    if ($nbpersonnes == 0)
    {
       ?>
       <fieldset>
       <legend>Message :</legend><br/>
       <b>Actuellement il n'y a aucune personne en mémoire ! </b><br />
       </fieldset>
       <?php
    }
    else
    {  // --- formulaire de saisie des informations pour la recherche
       ?>
       <br/>
       <!-- <form action="fonction_recherche_nom_web.php" method="post"> -->
       <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
        <fieldset>
        <legend>Saisissez le nom de la personne &agrave; rechercher :</legend><br/>
        Entrez un nom (ex : Dupont) : <input type="text" name="NomRech" size="20" maxlength="20" autofocus/><br/><br/>
        <input type="submit" name="rechercher_nom" value="Rechercher" />
        <!-- on ajoute le bouton terminer pour terminer la siaisie  -->
        <input type="reset" value="Effacer le formulaire" />
        </fieldset>
       </form>
       <?php
    }
   }
   // ----------------------------------
   // -- lien pour retourner au menu ---
   // ----------------------------------
   include 'INCLUDE/fonction_include_retour_menu_web.php';
   ?>
 </body>
</html>
