<?php
// On démarre la session AVANT d'écrire du code HTML
// afin de conserver l'information indiquant si c'est le premier accès
// et afin de transmettre le tableau des personnes
session_start();
include 'INCLUDE/fonction_include_sprog_commun_web.php';
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Recherche selon crit&egrave;res</title>
	<link href="CSS/traitement_liste_personnes_1page.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   $tab_personnes = $_SESSION['tab_personnes'];
   $nbpersonnes = count($tab_personnes);
   $_SESSION['nbpersonnes']=$nbpersonnes;
   // --------------------------------------------------------------
   // Cette page peut être appelée de deux manières différentes :
   // - une première fois : le formulaire doit être renseigné
   // - une deuxième fois : le formulaire a été renseigné et les valeurs sont transmises
   // --------------------------------------------------------------
   if (!empty($_POST['rechercher_critere']))
   {
    // --------------------------------------------------------------
    // cas ou le formulaire a été validé et on appelle
    // une nouvelle fois ce programme avec les données du formulaire
    // --------------------------------------------------------------
    $crit_recherche = $_POST['CritRech'];
    $val_recherche  = $_POST['ValRech'] ;
    // --- Protection de l'injection HTML ---
    $crit_recherche = strip_tags($crit_recherche);
    $val_recherche  = strip_tags($val_recherche) ;
    // --- Recherche ---
    $tab_numero=Recherche_sur_critere($crit_recherche,$val_recherche,$tab_personnes);
    if (count($tab_numero) == 0)
    {
       ?>
       <fieldset>
       <legend>Aucune personne trouv&eacute;e :</legend><br/>
       <b>La recherche pour <?php echo "$crit_recherche=$val_recherche";?> n'a trouv&eacute; aucune personne ! </b><br />
       </fieldset>
       <?php
    }
    else
    {
       // extraction dans un tableau tab_num_personnes des personnes trouvées
       foreach($tab_numero as $numero)
       {
         $tab_num_personnes[$numero]=$tab_personnes[$numero];
       }
       // --- Affichage du tableau ---
       affichage_tab_personnes("Liste des personnes trouv&eacute;es",$tab_num_personnes);
    }
   }
   else
   {
    // -----------------------------------------------
    // cas ou on doit afficher le formulaire de saisie
    // -----------------------------------------------
    if ($nbpersonnes == 0)
    {
       ?>
       <fieldset>
       <legend>Message :</legend><br/>
       <b>Actuellement il n'y a aucune personne en mémoire ! </b><br />
       </fieldset>
       <?php
    }
    else
    {  // --- formulaire de saisie des informations pour la recherche
       ?>
       <br/>
       <!-- <form action="fonction_recherche_champ_web.php" method="post"> -->
       <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
        <fieldset>
        <legend>Saisissez les crit&egrave;res de recherche :</legend><br/>
        S&eacute;lectionnez le crit&egrave;re de recherche : <br/><br/>
        Identifiant <input type="radio" name="CritRech" value="ID" checked="checked"> 
        Nom <input type="radio" name="CritRech" value="Nom"> 
        Pr&eacute;nom <input type="radio" name="CritRech" value="Prenom"> 
        Age <input type="radio" name="CritRech" value="Age"> <br/><br/>
        Entrez la valeur selon le crit&egrave;re : <input type="text" name="ValRech" size="20" maxlength="20" autofocus/><br/><br/>
        <input type="submit" name="rechercher_critere" value="Rechercher" />
        <!-- on ajoute le bouton terminer pour terminer la siaisie  -->
        <input type="reset" value="Effacer le formulaire" />
        </fieldset>
       </form>
       <?php
    }
   }
   // ----------------------------------
   // -- lien pour retourner au menu ---
   // ----------------------------------
   include 'INCLUDE/fonction_include_retour_menu_web.php';
   ?>
 </body>
</html>
