<?php
// On démarre la session AVANT d'écrire du code HTML
// afin de conserver l'information indiquant si c'est le premier accès
// et afin de transmettre le tableau des personnes
session_start();
include 'INCLUDE/fonction_include_sprog_commun_web.php';
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Modification d'un personne</title>
	<link href="CSS/traitement_liste_personnes_1page.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   $tab_personnes = $_SESSION['tab_personnes'];
   $nbpersonnes = count($tab_personnes);
   $_SESSION['nbpersonnes']=$nbpersonnes;
   if (!empty($_POST['valeur_modification_personne']))
   {
    // --------------------------------------------------------------
    // cas où les données des champs ont été saisies
    // on traite ces données et on modifie la personne
    // --------------------------------------------------------------
    $numero_modification=$_SESSION['numero_modification'];
    $une_personne=$tab_personnes[$numero_modification];
    $ID=$une_personne['ID'];
    $Nom=$une_personne['Nom'];
    $Prenom=$une_personne['Prenom'];
    $Age=$une_personne['Age'];    
    // --- on récupère les valeurs saisies ---
    if (isset($_POST['NouvID'])) $NouvID = $_POST['NouvID'] ;
    else $NouvID     = ''     ;
    if (isset($_POST['NouvNom'])) $NouvNom = $_POST['NouvNom'] ;
    else $NouvNom     = ''     ;
    if (isset($_POST['NouvPrenom'])) $NouvPrenom = $_POST['NouvPrenom'] ;
    else $NouvPrenom     = ''  ;
    if (isset($_POST['NouvAge'])) $NouvAge = $_POST['NouvAge'] ;
    else $NouvAge     = ''     ;
    // --- Protection de l'injection HTML ---
    $NouvID     = strip_tags($NouvID)    ;
    $NouvNom    = strip_tags($NouvNom)   ;
    $NouvPrenom = strip_tags($NouvPrenom);
    $NouvAge    = strip_tags($NouvAge)   ;    
    // -----------------------------------------------
    // on vérifie qu'il y a au moins un champ non vide
    // -----------------------------------------------
    if (!empty($NouvNom) || !empty($NouvPrenom) || !empty($NouvAge) || !empty($NouvID))
    {
      // ---------------------------------------
      // on vérifie la validité des chaque champ
      // ---------------------------------------
      $retourValidationID=true;
      $retourValidationAge=true;
      $retourValidationNom=true;
      $retourValidationPrenom=true;
      if ( (!empty($NouvID)) && ($ID!=normalisation_numerique($NouvID)))
      {
       $NouvID=normalisation_numerique($NouvID);
       $retourValidationID=validation_ID($NouvID);
       if ($retourValidationID)
       {
        $ID  = intval($NouvID)   ;
       }
      }
      if ( (!empty($NouvAge)) && ($Age!=normalisation_numerique($NouvAge)))
      {
       $NouvAge=normalisation_numerique($NouvAge);
       $retourValidationAge=validation_Age($NouvAge);
       if ($retourValidationAge)
       {
        $Age  = intval($NouvAge)   ;
       }
      }
      if ( (!empty($NouvNom)) && ($Nom!=normalisation_nom($NouvNom)))
      {
       $NouvNom=normalisation_nom($NouvNom);
       $retourValidationNom=!empty($NouvNom);
       if ($retourValidationNom)
       {
        $Nom  = $NouvNom   ;
       }
      }
      if ( (!empty($NouvPrenom)) && ($Prenom!=normalisation_nom($NouvPrenom)))
      {
       $NouvPrenom=normalisation_nom($NouvPrenom);
       $retourValidationPrenom=!empty($NouvPrenom);
       if ($retourValidationPrenom)
       {
        $Prenom  = $NouvPrenom   ;
       }
      }
      // ----------------------------------------------------
      // vérification du résultat de la validation des champs
      // ----------------------------------------------------
      if ((!$retourValidationID) || (!$retourValidationAge) || (!$retourValidationNom) || (!$retourValidationPrenom) )
      {
        // -------------------------------
        // si un des champs est invalide
        // -------------------------------
        redirection_delai("modification","fonction_modification_web.php",15);
      }
      else
      {
        // -------------------------------
        // si tous les champs sont valides
        // on met a jour le tableau des personnes
        // -------------------------------
        // on crée un tableau à partir des variables
        $une_personne=compact('ID','Nom','Prenom','Age');
        // est équivalent à
        /*
        $une_personne['ID']    = $ID          ;
        $une_personne['Nom']   = $Nom         ;
        $une_personne['Prenom']= $Prenom      ;
        $une_personne['Age']   = $Age         ;
        */
        // on met a jour le tableau des personnes
        // ATTENTION : si c'est l'identifiant qui a été modifié
        // il faut d'abord trié le tableau puis récupérer le nouveau
        // numero_modification car l'ordre dans la liste change
        $tab_personnes[$numero_modification]=$une_personne;
        // --- Tri du tableau ---
        $tab_personnes=tri_tab_personnes($tab_personnes);
        $_SESSION['tab_personnes']=$tab_personnes;
        $_SESSION['sauvegarde_a_faire']=true;
        $tab_numero=Recherche_sur_critere('ID',$ID,$tab_personnes);
        foreach($tab_numero as $numero)
        {
          $tab_Modifier[$numero]=$tab_personnes[$numero];
        }
        // --- Affichage du tableau ---
        affichage_tab_personnes("Personne modifi&eacute;e",$tab_Modifier);
      }
    }
    else
    {
     ?>
     <fieldset>
     <legend>Aucune modification :</legend><br/>
     <b>Pas de modification : tous les champs sont vides ! </b><br />
     </fieldset>
     <?php
    }
   }
   elseif (!empty($_POST['choix_modification_personne']))
   {
    // --------------------------------------------------------------
    // cas où la personne à modifier a été sélectionnée
    // on doit saisir les valeurs des champs
    // --------------------------------------------------------------
    $numero_modification=$_POST['NumModif'];
    // --- Protection de l'injection HTML ---
    $numero_modification     = strip_tags($numero_modification) ;
    $_SESSION['numero_modification']=$numero_modification;
    $tab_a_Modifier[$numero_modification]=$tab_personnes[$numero_modification];
    affichage_tab_personnes("Personne à modifier",$tab_a_Modifier);
    // --- on affiche le formulaire pour saisir les valeurs de remplacement ---
    ?>
    <br/>
     <!-- <form action="fonction_modification_web.php" method="post"> -->
     <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
      <fieldset>
      <legend>Saisissez les nouvelles valeurs :</legend><br/>
      <b>ATTENTION</b> : un champ non renseign&eacute; (vide) laisse la valeur inchang&eacute;e !
      <table summary="Tableau de modification">
       <caption>&nbsp;</caption>
       <thead>
        <tr>
         <!-- entête du tableau -->
         <th>Nouvel Identifiant</th>
         <th>Nouveau Nom</th>
         <th>Nouveau Pr&eacute;nom</th>
         <th>Nouvel Age</th>
        </tr>
       </thead>
       <tr>
         <td><input type="text" name="NouvID" size="10" maxlength="10" placeholder="123" autofocus pattern="[0-9]{1,10}"/></td>
         <td><input type="text" name="NouvNom" size="20" maxlength="20" placeholder="Dupont de Nemours"/></td>
         <td><input type="text" name="NouvPrenom" size="40" maxlength="40" placeholder="Jean Charles"/></td>
         <td><input type="text" name="NouvAge" size="3" maxlength="3" pattern="[1-9][0-9]{1,3}" placeholder="28" /></td>
       </tr>
      </table>
      <br/><br/>
      <input type="submit" name="valeur_modification_personne" value="Modifier cette personne" />
      <!-- on ajoute le bouton terminer pour terminer la siaisie  -->
      <input type="reset" value="Effacer le formulaire" />
      </fieldset>
     </form>
     <?php
   }
   elseif (!empty($_POST['rechercher_critere']))
   {
    // --------------------------------------------------------------
    // cas où les critères de recherhe on été saisis
    // on affiche un formulaire pour sélectionner la personne à modifier
    // parmi la liste des personnes affichées
    // --------------------------------------------------------------
    $crit_recherche=$_POST['CritRech'];
    $val_recherche=$_POST['ValRech']  ;
    // --- Protection de l'injection HTML ---
    $crit_recherche = strip_tags($crit_recherche);
    $val_recherche  = strip_tags($val_recherche) ;
    // --- recherche ---
    $tab_numero=Recherche_sur_critere($crit_recherche,$val_recherche,$tab_personnes);
    if (count($tab_numero) == 0)
    {
       ?>
       <fieldset>
       <legend>Aucune personne trouv&eacute;e :</legend><br/>
       <b>La recherche pour <?php echo "$crit_recherche=$val_recherche";?> n'a trouv&eacute; aucune personne ! </b><br />
       </fieldset>
       <?php
    }
    else
    {
       // extraction dans un tableau tab_num_personnes des personnes trouvées
       foreach($tab_numero as $numero)
       {
         $tab_num_personnes[$numero]=$tab_personnes[$numero];
       }
       // --- Affichage du tableau ---
       affichage_tab_personnes("Liste des personnes trouv&eacute;es",$tab_num_personnes);
       // affichage du formaulier de saisie de la personne à modifier
       ?>
       <br/>
       <!-- <form action="fonction_modification_web.php" method="post"> -->
       <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
       <fieldset>
        <legend>Saisissez le Num&eacute;ro de la personne &agrave; modifier :</legend><br/>
        Entrez le <b>Num&eacute;ro</b> de la personne &agrave; modifier : <input type="text" name="NumModif" size="20" maxlength="20" autofocus/><br/><br/>
        <input type="submit" name="choix_modification_personne" value="Modifier" />
        <!-- on ajoute le bouton terminer pour terminer la siaisie  -->
        <input type="reset" value="Effacer le formulaire" />
        </fieldset>
       </form>
       <?php
    }
   }
   else
   {
    // -----------------------------------------------
    // cas ou on doit afficher le formulaire de saisie
    // des critères de recherche pour la personne à modifier
    // -----------------------------------------------
    if ($nbpersonnes == 0)
    {
       ?>
       <fieldset>
       <legend>Message :</legend><br/>
       <b>Actuellement il n'y a aucune personne en mémoire ! </b><br />
       </fieldset>
       <?php
    }
    else
    {  // --- formulaire de saisie des informations pour la recherche
       ?>
       <br/>
       <!-- <form action="fonction_modification_web.php" method="post"> -->
       <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
        <fieldset>
        <legend>Saisissez les crit&egrave;res de recherche :</legend><br/>
        S&eacute;lectionnez le crit&egrave;re de recherche : <br/><br/>
        Identifiant <input type="radio" name="CritRech" value="ID"> 
        Nom <input type="radio" name="CritRech" value="Nom" checked="checked"> 
        Pr&eacute;nom <input type="radio" name="CritRech" value="Prenom"> 
        Age <input type="radio" name="CritRech" value="Age"> <br/><br/>
        Entrez la valeur selon le crit&egrave;re : <input type="text" name="ValRech" size="20" maxlength="20" autofocus/><br/><br/>
        <input type="submit" name="rechercher_critere" value="Rechercher" />
        <!-- on ajoute le bouton terminer pour terminer la siaisie  -->
        <input type="reset" value="Effacer le formulaire" />
        </fieldset>
       </form>
       <?php
    }
   }
   // ----------------------------------
   // -- lien pour retourner au menu ---
   // ----------------------------------
   include 'INCLUDE/fonction_include_retour_menu_web.php';
   ?>
 </body>
</html>
