<?php
// On démarre la session AVANT d'écrire du code HTML
// afin de conserver l'information indiquant si c'est le premier accès
// et afin de transmettre le tableau des personnes
session_start();
include 'INCLUDE/fonction_include_sprog_commun_web.php';
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Chargement fichier de personnes</title>
	<link href="CSS/traitement_liste_personnes_1page.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   if (!isset($_SESSION['sauvegarde_a_faire'])) $sauvegarde_a_faire=false;
   else $sauvegarde_a_faire=$_SESSION['sauvegarde_a_faire'];
   if ($sauvegarde_a_faire)
   {
    // -------------------------------------------------------
    // traitement du cas ou les données ont été modifiées
    // il faut vérifier si une sauvergarde doit être faite avant le chargement
    // -------------------------------------------------------
    if (!empty($_POST['verif_sauvegarde']))
    {
     // -------------------------------------------------------
     // cas où la sauvegarde a peut être été demandée et le nom du fichier indiqué
     // -------------------------------------------------------
     // --- on récupère la réponse ---
     $Reponse_Sauvegarde    = $_POST['Reponse_Sauvegarde']    ;
     // --- Protection de l'injection HTML ---
     $Reponse_Sauvegarde    = strip_tags($Reponse_Sauvegarde)    ;
     if ($Reponse_Sauvegarde == "oui")
     {
       // ----------------------------
       // La sauvegarde a été demandée 
       // ----------------------------
       // --- on récupère le nom du fichier ---
       if (isset($_POST['NomFichier'])) $NomFichier = $_POST['NomFichier'] ;
       else $NomFichier     = ''     ;
       // --- Protection de l'injection HTML ---
       $NomFichier    = strip_tags($NomFichier)    ;
       if (empty($NomFichier))
       {
        ?>
        <fieldset>
        <legend>Message :</legend><br/>
        <b>Sauvegarde impossible, le nom du fichier n'est pas indiqu&eacute; ! </b><br />
        </fieldset>
        <?php
        redirection_delai("chargement","fonction_chargement_web.php",5);
       }
       else
       {
        // --- Tri du tableau ---
        $_SESSION['tab_personnes']=tri_tab_personnes($_SESSION['tab_personnes']);
        $tab_personnes=$_SESSION['tab_personnes'];
        // --- appel de la procédure de sauvegarde ---
        $nb_sauvegardes=Sauvegarde_tableau_fichier($tab_personnes,$NomFichier,true,"fonction_chargement_web.php"); 
        redirection_delai("chargement","fonction_chargement_web.php",5);
       }
     }
     else
     {
        // ----------------------------------
        // La sauvegarde n'a pas été demandée 
        // ----------------------------------
        ?>
        <fieldset>
        <legend>Message :</legend><br/>
        <b>Aucune sauvegarde des donn&eacute;es actuelles avant le chargement du fichier ! </b><br />
        </fieldset>
        <?php
        $_SESSION['sauvegarde_a_faire']=false;
        redirection_delai("chargement","fonction_chargement_web.php",5);
     }
    }
    else
    {
     // --------------------------------------------------------------------------
     // formulaire pour la confirmation de la sauvegarde avant chargement
     // --------------------------------------------------------------------------
     ?>
     <!-- <form action="fonction_chargement_web.php" method="post"> -->
     <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
     <fieldset>
     <legend>Attention les données ont été modifiées. !</legend><br/>
     Voulez-vous sauvegarder les données actuelles avant de charger le fichier ?<br/>
     Oui <input type="radio" name="Reponse_Sauvegarde" value="oui" checked="checked"> 
     Non <input type="radio" name="Reponse_Sauvegarde" value="non"> <br/><br/>
     Si oui, entrez le nom du fichier (ex : liste_personnes) : <input type="text" name="NomFichier" size="20" maxlength="20" autofocus/><br/><br/>
     <input type="submit" name="verif_sauvegarde" value="Valider" />
     <!-- on ajoute le bouton terminer pour terminer la siaisie  -->
     <input type="reset" value="Effacer la sélection" />
     </fieldset>
     </form>
     <?php
    }
   }
   // --------------------------------------------------------------------------
   // si l'affichage de la page provient d'un charger, on effectue le chargement
   // --------------------------------------------------------------------------
   elseif (!empty($_POST['charger']))
   {
     // --- on récupère le nom du fichier ---
     if (isset($_POST['NomFichier'])) $NomFichier = $_POST['NomFichier'] ;
     else $NomFichier     = ''     ;
     // --- Protection de l'injection HTML ---
     $NomFichier    = strip_tags($NomFichier)    ;
     if (empty($NomFichier))
     {
      ?>
      <fieldset>
      <legend>Message :</legend><br/>
      <b>Chargement impossible, le nom du fichier n'est pas indiqu&eacute; ! </b><br />
      </fieldset>
      <?php
     }
     else
     {
      $tab_chargement=Chargement_tableau_fichier($NomFichier);
      if (count($tab_chargement) != 0)
      {
       $_SESSION['tab_personnes']=$tab_chargement;
       $tab_personnes=$_SESSION['tab_personnes'] ;
       unset($tab_chargement);
      }
     }
   }
   // ------------------------------------------------------------------------
   // sinon on affiche le formulaire de saisie du nom du fichier de chargement
   // ------------------------------------------------------------------------
   else   
   {
     $Repertoire_recherche="../Sauvegardes";
     $tab_liste_fichiers=Liste_fichiers($Repertoire_recherche);
     if (count($tab_liste_fichiers)==0)
     {
      ?>
      <fieldset>
      <legend>Erreur de chargement :</legend><br/>
      <?php
      echo "<h1>Aucun fichier trouvé dans le répertoire $Repertoire_recherche</h1><br/>";
      ?>
      </fieldset>
      <?php
     }
     else
     {
     ?>
     <br/>
     <!-- <form action="fonction_chargement_web.php" method="post"> -->
     <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
      <fieldset>
      <legend>Saisissez le nom du fichier &agrave; charger :</legend><br/>
      Liste des fichiers trouv&eacute;s : 
      <select name="NomFichier" size="1">
      <?php
      foreach($tab_liste_fichiers as $valNomFichier)
      {
       echo "<option>";
       echo $valNomFichier;
       echo "</option>";
      }
      ?>
      </select><br/><br/>
      <input type="submit" name="charger" value="Charger le fichier" />
      <!-- on ajoute le bouton terminer pour terminer la siaisie  -->
      <!--
      <input type="reset" value="Effacer le nom du fichier" />
      -->
      </fieldset>
     </form>
     <?php
     }
   }
   // ----------------------------------
   // -- lien pour retourner au menu ---
   // ----------------------------------
   include 'INCLUDE/fonction_include_retour_menu_web.php';
   ?>
 </body>
</html>
