<?php
define("MAXID","1000000");
define("MAXAGE","120");
define("WEB_EOL","<br/>");

// =================================================
// --- fonction outil de suppression des accents ---
// =================================================
function supprime_accent($chaine)
{
  // tableau des caractères accentués à remplacer
  $caracteres_a_remplacer     = array('À', 'Á', 'Â', 'Ã', 'Ä', 'Å', 'Æ', 'Ç', 'È', 'É', 'Ê', 'Ë', 'Ì', 'Í', 'Î', 'Ï', 'Ð', 'Ñ', 'Ò', 'Ó', 'Ô', 'Õ', 'Ö', 'Ø', 'Ù', 'Ú', 'Û', 'Ü', 'Ý', 'ß', 'à', 'á', 'â', 'ã', 'ä', 'å', 'æ', 'ç', 'è', 'é', 'ê', 'ë', 'ì', 'í', 'î', 'ï', 'ñ', 'ò', 'ó', 'ô', 'õ', 'ö', 'ø', 'ù', 'ú', 'û', 'ü', 'ý', 'ÿ', 'Ā', 'ā', 'Ă', 'ă', 'Ą', 'ą', 'Ć', 'ć', 'Ĉ', 'ĉ', 'Ċ', 'ċ', 'Č', 'č', 'Ď', 'ď', 'Đ', 'đ', 'Ē', 'ē', 'Ĕ', 'ĕ', 'Ė', 'ė', 'Ę', 'ę', 'Ě', 'ě', 'Ĝ', 'ĝ', 'Ğ', 'ğ', 'Ġ', 'ġ', 'Ģ', 'ģ', 'Ĥ', 'ĥ', 'Ħ', 'ħ', 'Ĩ', 'ĩ', 'Ī', 'ī', 'Ĭ', 'ĭ', 'Į', 'į', 'İ', 'ı', 'Ĳ', 'ĳ', 'Ĵ', 'ĵ', 'Ķ', 'ķ', 'Ĺ', 'ĺ', 'Ļ', 'ļ', 'Ľ', 'ľ', 'Ŀ', 'ŀ', 'Ł', 'ł', 'Ń', 'ń', 'Ņ', 'ņ', 'Ň', 'ň', 'ŉ', 'Ō', 'ō', 'Ŏ', 'ŏ', 'Ő', 'ő', 'Œ', 'œ', 'Ŕ', 'ŕ', 'Ŗ', 'ŗ', 'Ř', 'ř', 'Ś', 'ś', 'Ŝ', 'ŝ', 'Ş', 'ş', 'Š', 'š', 'Ţ', 'ţ', 'Ť', 'ť', 'Ŧ', 'ŧ', 'Ũ', 'ũ', 'Ū', 'ū', 'Ŭ', 'ŭ', 'Ů', 'ů', 'Ű', 'ű', 'Ų', 'ų', 'Ŵ', 'ŵ', 'Ŷ', 'ŷ', 'Ÿ', 'Ź', 'ź', 'Ż', 'ż', 'Ž', 'ž', 'ſ', 'ƒ', 'Ơ', 'ơ', 'Ư', 'ư', 'Ǎ', 'ǎ', 'Ǐ', 'ǐ', 'Ǒ', 'ǒ', 'Ǔ', 'ǔ', 'Ǖ', 'ǖ', 'Ǘ', 'ǘ', 'Ǚ', 'ǚ', 'Ǜ', 'ǜ', 'Ǻ', 'ǻ', 'Ǽ', 'ǽ', 'Ǿ', 'ǿ');
  // tableau des caractères sans accent de remplacement
  $caracteres_de_remplacement = array('A', 'A', 'A', 'A', 'A', 'A', 'AE', 'C', 'E', 'E', 'E', 'E', 'I', 'I', 'I', 'I', 'D', 'N', 'O', 'O', 'O', 'O', 'O', 'O', 'U', 'U', 'U', 'U', 'Y', 's', 'a', 'a', 'a', 'a', 'a', 'a', 'ae', 'c', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'n', 'o', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'y', 'y', 'A', 'a', 'A', 'a', 'A', 'a', 'C', 'c', 'C', 'c', 'C', 'c', 'C', 'c', 'D', 'd', 'D', 'd', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'G', 'g', 'G', 'g', 'G', 'g', 'G', 'g', 'H', 'h', 'H', 'h', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'IJ', 'ij', 'J', 'j', 'K', 'k', 'L', 'l', 'L', 'l', 'L', 'l', 'L', 'l', 'l', 'l', 'N', 'n', 'N', 'n', 'N', 'n', 'n', 'O', 'o', 'O', 'o', 'O', 'o', 'OE', 'oe', 'R', 'r', 'R', 'r', 'R', 'r', 'S', 's', 'S', 's', 'S', 's', 'S', 's', 'T', 't', 'T', 't', 'T', 't', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'W', 'w', 'Y', 'y', 'Y', 'Z', 'z', 'Z', 'z', 'Z', 'z', 's', 'f', 'O', 'o', 'U', 'u', 'A', 'a', 'I', 'i', 'O', 'o', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'A', 'a', 'AE', 'ae', 'O', 'o');
  // retour de la fonction
  return str_replace($caracteres_a_remplacer, $caracteres_de_remplacement, $chaine);
}
// =================================================
// --- fonction outil de normalisation des noms  ---
// =================================================
function normalisation_nom($chaine)
{
 // tableau des motifs de recherche
 $tab_motif=array('/[^a-zA-Z -]/', '/[ -]+/', '/^-|-$/');
 // tableau des caract&egrave;res de remplacement
 $tab_remplacement=array('', '-', '')     ;
 // chaine de caract&egrave;res sur laquelle s'effectue le remplacement
 $chaine_contexte=supprime_accent($chaine);
 // retour de la fonction
 return strtoupper(preg_replace($tab_motif,$tab_remplacement, $chaine_contexte));
}
// =================================================
// --- fonction outil de normalisation des numériques  ---
// =================================================
function normalisation_numerique($numero)
{
 // tableau des motifs de recherche
 $tab_motif=array('/[^0-9,.]/');
 // tableau des caract&egrave;res de remplacement
 $tab_remplacement=array('')     ;
 // retour de la fonction
 $numero_retour=intval(preg_replace($tab_motif,$tab_remplacement, $numero));
 return $numero_retour;
}
// =============================================================
// --- fonction outil de normalisation des noms de fichiers  ---
// =============================================================
function normalisation_fichier($nomf)
{
  // tableau des motifs de recherche
  $tab_motif=array('/[^a-zA-Z0-9 ._-]/','/[ -]+/','/^-|-$/');
  // tableau des caract&egrave;res de remplacement
  $tab_remplacement=array('', '-', '')   ;
  // remplacement des caracteres non autoris&eacute;s  et suppression des accents
  $nomf_retour=strtolower(preg_replace($tab_motif,$tab_remplacement,supprime_accent($nomf)));
  $nomf_retour=str_replace('-','_',$nomf_retour);
  // suppression de l'&eacute;ventuelle extension
  $elements_chemin=pathinfo($nomf_retour);
  $nomf_retour=$elements_chemin['filename'];
  // -- on pr&eacute;pare le nom du r&eacute;pertoire de sauvegarde ---
  $repertoire_courant=realpath(".")      ;
  $repertoire_sauvegarde="../Sauvegardes/"  ;
  // -- on traite le nom du fichier ---
  $nomf_retour=$repertoire_sauvegarde.$nomf_retour.".txt";
  return $nomf_retour;
}
// ==================================================
// --- fonction outil d'affichage d'une personne  ---
// ==================================================
function affichage_une_personne($titre,$tunepersonne)
{
 // entête de l'affichage
  ?>
  <table summary="Tableau de r&eacute;sultat">
   <caption><?php echo $titre;?></caption>
   <thead>
    <tr>
    <!-- entête du tableau -->
     <th>Identifiant</th>
     <th>Nom</th>
     <th>Pr&eacute;nom</th>
     <th>Age</th>
    </tr>
   </thead>
 <?php
 if (count($tunepersonne) ==0)
 {
   echo "<td colspan=\"4\"><b>Aucune donn&eacute;e &agrave; afficher</b></td>";
 }
 else
 {
   // importation des variables à partir de l'étiquette des champs
   extract($tunepersonne,EXTR_OVERWRITE);
   echo "<tr>";
   echo "<td>$ID</td><td>$Nom</td><td>$Prenom</td><td>$Age</td>";
   echo "</tr>";
 }
 ?></table><?php
}
// ============================================================
// --- fonction outil d'affichage d'un tableau de personnes  ---
// ============================================================
function affichage_tab_personnes($titre,$tpersonnes)
{
 // entête de l'affichage
  ?>
  <table summary="Tableau de r&eacute;sultat">
   <caption><?php echo $titre;?></caption>
   <thead>
    <tr>
    <!-- entête du tableau -->
     <th>Num&eacute;ro</th>
     <th>Identifiant</th>
     <th>Nom</th>
     <th>Pr&eacute;nom</th>
     <th>Age</th>
    </tr>
   </thead>
 <?php
 if (count($tpersonnes) ==0)
 {
   echo "<td colspan=\"5\"><b>Aucune donn&eacute;e &agrave; afficher</b></td>";
 }
 else
 {
  foreach ($tpersonnes as $indice => $une_personne)
  {
   echo "<tr>";
   // importation des variables à partir de l'étiquette des champs
   extract($une_personne,EXTR_OVERWRITE);
   // la fonction extract est équivante à 
   /*
   $ID     = $une_personne['ID']    ;
   $nom    = $une_personne['nom']   ;
   $prenom = $une_personne['prenom'];
   $age    = $une_personne['age']   ;
   */
   echo "<td>$indice</td><td>$ID</td><td>$Nom</td><td>$Prenom</td><td>$Age</td>";
   echo "</tr>";
  }
 }
 ?></table><?php
}
// ========================================================
// --- fonction outil de tri d'un tableau de personnes  ---
// ========================================================
function tri_tab_personnes($tpersonnes)
{
  if (count($tpersonnes) !=0)
  {
   // tri du tableau en retirant les doublons
   $tpersonnes=array_unique($tpersonnes,SORT_REGULAR );
   sort($tpersonnes);
  }
   return $tpersonnes;
}
// ===========================================================================
// --- fonction outil de sélection du choix pour la recherche par critère  ---
// ===========================================================================
function choix_critere()
{
  $tab_critere_retour=array();
  echo "Crit&egrave;re de recherche : ".PHP_EOL;;
  echo "    -a- Indentifiant (ID)".PHP_EOL;
  echo "    -b- Nom".PHP_EOL;
  echo "    -c- Pr&eacute;nom".PHP_EOL;
  echo "    -d- Age".PHP_EOL;
  echo "Entrez le crit&egrave;re (a,b,c ou d) : ";
  fscanf(STDIN,"%s",$critere);
  $critere=$critere[0];
  switch ($critere)
  {
    case 'a' : echo "Identifiant : "; break;
    case 'b' : echo "Nom         : "; break;
    case 'c' : echo "Pr&eacute;nom      : "; break;
    case 'd' : echo "Age         : "; break;
    default  : echo "Choix erron&eacute; !".PHP_EOL; break;
  }
if (($critere >='a') && ($critere <='d'))
{
  $valeur_recherche=fgets(STDIN);
  trim($valeur_recherche);
  $tab_critere_retour[0]=$critere;
  $tab_critere_retour[1]=$valeur_recherche;
 }
 return $tab_critere_retour;
}
// ========================================================================================
// --- fonction outil de vérification de sauvegarde en cas de modification des données  ---
// ========================================================================================
function verif_sauvegarde()
{
 $sauvegarde_a_faire = $_SESSION['sauvegarde_a_faire'];

 // on v&eacute;rifie d'abord s'il y a une sauvegarde a faire
 if ($sauvegarde_a_faire)
 {
  echo "Attention les donn&eacute;es ont &eacute;t&eacute; modifi&eacute;es. !".PHP_EOL;
  echo "Voulez-vous sauvegarder les donn&eacute;es actuelles avant de charger le fichier (o/n) : ";
  fscanf(STDIN,"%s",$reponse);
  if ($reponse == "o")
  {
    Sauvegarde();
  }
 }
}
// =====================================================================
// --- fonction outil de vérification de l'unicité de l'identifiant  ---
// =====================================================================
function verif_unicite_ID($identifiant,$tab_verif)
{
 $identifiant_valide=true;
 //$tab_personnes = $_SESSION['tab_personnes'];
 if (count($tab_verif) != 0)
 {
  $colonne_ID = array_column($tab_verif,'ID');
  $identifiant_existe=in_array($identifiant,$colonne_ID);
  $identifiant_valide = ! $identifiant_existe;
 }
 return $identifiant_valide ;
}
// ================================
// --- Recherche sur critere ---
// ================================
function Recherche_sur_critere($crit_recherche,$val_recherche,$tab_recherche)
{
 //$tab_personnes = $_SESSION['tab_personnes'];
 //$nbpersonnes = $_SESSION['nbpersonnes'];

 $tab_num_personnes_resultats=array();
 foreach ($tab_recherche as $indice => $une_personne)
 {
  // importation des variables à partir de l'étiquette des champs
  extract($une_personne,EXTR_OVERWRITE);
  // la fonction extract est équivante à
  /*
  $ID     = $une_personne['ID']    ;
  $nom    = $une_personne['nom']   ;
  $prenom = $une_personne['prenom'];
  $age    = $une_personne['age']   ;
  */
  switch($crit_recherche)
  {
    case 'ID'    :$nom_var='ID'    ;$val_recherche=intval($val_recherche);break;
    case 'Nom'   :$nom_var='Nom'   ;$val_recherche=normalisation_nom($val_recherche);break;
    case 'Prenom':$nom_var='Prenom';$val_recherche=normalisation_nom($val_recherche);break;
    case 'Age'   :$nom_var='Age'   ;$val_recherche=intval($val_recherche);break;
  }
  // utilisation d'une variable dynamique
  if ($$nom_var == $val_recherche)
  {
    $tab_num_personnes_resultats[]=$indice;
  }
 }
 return $tab_num_personnes_resultats;
}
// ==================================
// --- Sauvegarde dans un fichier ---
// ==================================
function Sauvegarde_tableau_fichier($tab_a_Sauvegarder,$NomFichier,$verif_fichier_existe,$contexte_appelant)
{
   $NomFichier=normalisation_fichier($NomFichier) ;
   $elements_chemin=pathinfo($NomFichier);
   $nomf=$elements_chemin['filename'].".".$elements_chemin['extension'];
   $Repertoire_recherche="../Sauvegardes";
   // -- ouverture du fichier en mode écriture ---
   // -- on empêche l'affichage des messages d'erreurs du fopen avec @ ---
   $f1 = @fopen($NomFichier, "wt");
   if (! $f1) // --- erreur d'ouverture ---
   { // -- on affiche les messages d'erreur ---
     $tab_erreurs      = error_get_last()       ;
     $erreur_type      = $tab_erreurs['type']   ;
     $erreur_message   = $tab_erreurs['message'];
     $erreur_programme = $tab_erreurs['file']   ;
     $erreur_ligne     = $tab_erreurs['line']   ;
     ?>
     <fieldset>
     <legend>Erreur :</legend><br/>
     <b>Sauvegarde impossible :</b> erreur d'ouverture du fichier <b><?php echo $NomFichier; ?></b> en écriture  ! <br /><br/>
     <b>Type de l'erreur :</b> <?php echo $erreur_type ; ?><br />
     <b>Message :</b> <?php echo $erreur_message; ?><br />
     <b>Répertoire de sauvegarde :</b> <?php echo $repertoire_courant."/".$repertoire_sauvegarde; ?><br /><br />
     <b>Programme PHP :</b> <?php echo $erreur_programme; ?><br />
     <b>A la ligne :</b> <?php echo $erreur_ligne; ?><br />
     </fieldset>
     <?php
   } 
   else 
   {
     $nb_sauvegardes=count($tab_a_Sauvegarder);
     // ----------------------------
     // --- boucle de sauvegarde ---
     // ----------------------------
     foreach ($tab_a_Sauvegarder as $etiquette => $une_personne)
     {
       $ID     = $une_personne['ID'];
       $Nom    = $une_personne['Nom'];
       $Prenom = $une_personne['Prenom'];
       $Age    = $une_personne['Age'];
       // importation des variables à partir de l'étiquette des champs
       extract($une_personne,EXTR_OVERWRITE);
       /* identique à 
       $ID     = $une_personne['ID'];
       $Nom    = $une_personne['Nom'];
       $Prenom = $une_personne['Prenom'];
       $Age    = $une_personne['Age'];
       */
       fprintf($f1,"%d\t%s\t%s\t%d%s",$ID,$Nom,$Prenom,$Age,PHP_EOL);
     }
     // -- on affiche le résultat de la sauvegarde ---
     ?>
     <fieldset>
     <legend>Message :</legend><br/>
     <?php echo "Sauvegarde dans le fichier <b>$NomFichier</b> : "."<br />";?>
     </fieldset>
     <?php
     // --- Affichage du tableau ---
     affichage_tab_personnes("Liste des personnes",$tab_a_Sauvegarder);
     echo "<br />Nombre de personnes sauvegard&eacute;es : $nb_sauvegardes<br />";
     // -- fermeture du fichier de sauvegarde ---
     fclose($f1);
     // --- on indique qu'il n'y a plus de sauvegarde en attente ---
     $_SESSION['sauvegarde_a_faire']=false;
   }
  return $nb_sauvegardes;
}
// ========================================
// --- Chargement à partir d'un fichier ---
// ========================================
function Chargement_tableau_fichier($NomFichier)
{
  $nb_Chargements=0;
  $tab_personnes_lues=array();
  $NomFichier = normalisation_fichier($NomFichier) ;
  // -- ouverture du fichier en mode écriture ---
  // -- on empêche l'affichage des messages d'erreurs du fopen avec @ ---
  $f1 = @fopen($NomFichier, "rt");
  if (! $f1) // --- erreur d'ouverture ---
  { // -- on affiche les messages d'erreur ---
    $tab_erreurs      = error_get_last()       ;
    $erreur_type      = $tab_erreurs['type']   ;
    $erreur_message   = $tab_erreurs['message'];
    $erreur_programme = $tab_erreurs['file']   ;
    $erreur_ligne     = $tab_erreurs['line']   ;
    ?>
    <fieldset>
    <legend>Erreur :</legend><br/>
    <b>Chargement impossible :</b> erreur d'ouverture du fichier <b><?php echo $NomFichier; ?></b> en lecture  ! <br /><br/>
    <b>Type de l'erreur :</b> <?php echo $erreur_type ; ?><br />
    <b>Message :</b> <?php echo $erreur_message; ?><br />
    <b>Répertoire de sauvegarde :</b> <?php echo $repertoire_courant."/".$repertoire_sauvegarde; ?><br /><br />
    <b>Programme PHP :</b> <?php echo $erreur_programme; ?><br />
    <b>A la ligne :</b> <?php echo $erreur_ligne; ?><br />
    </fieldset>
    <?php
  }
  else 
  {
    // ----------------------------
    // --- boucle de chargement ---
    // ----------------------------
    while ($Tab_Info=fscanf($f1,"%d\t%s\t%s\t%d"))
    {
      $erreur=false;
      list ($ID,$Nom,$Prenom,$Age) = $Tab_Info;
      // on vérifie que cet ID n'est pas déjà attribué
      // ce qui correspond à une erreur dans le fichier
      $ID_unique=verif_unicite_ID($ID,$tab_personnes_lues);
      if ($ID_unique == false)
      {
       $erreur=true;
       
       
       unset($tab_personne_doublon);
       $tab_personne_doublon=array('ID'=>$ID,'Nom'=>$Nom,'Prenom'=>$Prenom,'Age'=>$Age) ;
       affichage_une_personne("Lecture non effectu&eacute;e pour :",$tab_personne_doublon)  ;
       
       $erreurEntete="Doublon : L'identifiant $ID est d&eacute;j&agrave; utilis&eacute; par :";
       $tab_numero=Recherche_sur_critere('ID',$ID,$tab_personnes_lues);
       
echo WEB_EOL;
       //$tab_personnes=$_SESSION['tab_personnes'];
       // on supprime le tableau $tab_num_personnes
       unset($tab_num_personnes)  ;
       foreach($tab_numero as $numero)
       {
         $tab_num_personnes[$numero]=$tab_personnes_lues[$numero];
       }
      }
      if ($erreur)
      {
      ?>
      <fieldset>
      <legend><?php echo $erreurEntete ?></legend><br/>
      <?php
      if (!empty($erreurMessage)) echo $erreurMessage;
      if (count($tab_num_personnes)!=0)
      {
       affichage_tab_personnes("Personne utilisant cet Identifiant",$tab_num_personnes);
      }
      ?>
      <br/>
      </fieldset>
      <?php
      }
      else
      {
       $tab_personnes_lues[]=array('ID'=>$ID,'Nom'=>$Nom,'Prenom'=>$Prenom,'Age'=>$Age) ;
       $nb_Chargements++;
      }
    }
    // --- Tri du tableau ---
    $tab_personnes_lues=tri_tab_personnes($tab_personnes_lues);
    // --- Affichage du tableau ---
    affichage_tab_personnes("Liste des personnes lues à partir du fichier",$tab_personnes_lues);
    // -- fermeture du fichier de Chargement ---
    echo "<br />Nombre de personnes lues : $nb_Chargements<br />";
    fclose($f1);
    $_SESSION['sauvegarde_a_faire']=false;
  }
  return $tab_personnes_lues;
}
// ==========================================
// --- Liste des fichiers d'un répertoire ---
// ===========================================
function Liste_fichiers($Repertoire_recherche)
{
  $tab_liste_fichiers=array();
  if($Repertoire = opendir($Repertoire_recherche))
  {
    while(false !== ($FicRep = readdir($Repertoire)))
    {
      if (!is_dir($FicRep))
      {
       $tab_liste_fichiers[]=$FicRep;
      }
    }
  }
  return $tab_liste_fichiers;
}
// ==========================================
// --- Redirection vers URL avec un délai --- 
// ==========================================
function redirection_delai($texte_page,$page_web, $delai_secondes)
{
 $delai_microsecondes=$delai_secondes*1000;

 echo "<h2>".$texte_page."  dans ".$delai_secondes." secondes ...</h3><br/>";
 // --- javascript d'attente de 5 secondes avant de rediriger vers la page de chargement --- 
 echo "<script type=\"text/javascript\">
          setInterval(function () {
            window.location = '".$page_web."';
          }, ".$delai_microsecondes.");
        </script>";
}
// ========================================
// --- Redirection vers URL immédiate   --- 
// ========================================
function redirection_immediate($page_web)
{
 // --- rediriger vers la page de chargement --- 
 //echo'<script>window.location="'.$page_web.'";</script>';
 print('<meta http-equiv="refresh" content="0;URL='.$page_web.'">');
}
// ==============================
// --- Validation du champ ID ---
// ==============================
function validation_ID($ID)
{
 $erreur=false;
 $erreurEntete="Erreur : champ identification ($ID) <?php echo $ID; ?>";
 if (($ID == 0) || (!(($ID >0)&&($ID <MAXID))))
 {
  $erreur=true;
  $val=MAXID;
  $erreurMessage="Le champ identification ($ID) est invalide. Il doit être compris entre 1 et $val";
 }
 else
 {
  $tab_personnes=$_SESSION['tab_personnes'];
  $ID_unique=true;
  $ID_unique=verif_unicite_ID($ID,$tab_personnes);
  if ($ID_unique == false)
  {
   $erreur=true;
   $erreurEntete="Erreur : L'identifiant $ID est d&eacute;j&agrave; utilis&eacute; par :";
   $tab_numero=Recherche_sur_critere('ID',$ID,$tab_personnes);
   // on supprime le tableau $tab_num_personnes
   unset($tab_num_personnes)  ;
   foreach($tab_numero as $numero)
   {
     $tab_num_personnes[$numero]=$tab_personnes[$numero];
   }
  }
 }
 if ($erreur)
 {
  ?>
  <fieldset>
  <legend><?php echo $erreurEntete ?></legend><br/>
  <?php
  if (!empty($erreurMessage)) echo $erreurMessage;
  if (count($tab_num_personnes)!=0)
  {
    affichage_tab_personnes("Personne utilisant cet Identifiant",$tab_num_personnes);
  }
  ?>
  <br/>
  </fieldset>
  <?php
 }
 return !$erreur;
}
// ===============================
// --- Validation du champ Age ---
// ===============================
function validation_Age($Age)
{
 $erreur=false;
 $erreurEntete="Erreur : champ Age <?php echo $Age; ?>";
 if (($Age == 0) || (!(($Age >0)&&($Age <MAXAGE))))
 {
  $erreur=true;
  $val=MAXAGE;
  $erreurMessage="Le champ Age est invalide ($Age). Il doit être compris entre 1 et $val ans";
 }
 if ($erreur)
 {
  ?>
  <fieldset>
  <legend><?php echo $erreurEntete ?></legend><br/>
  <?php
  if (!empty($erreurMessage)) echo $erreurMessage;
  ?>
  <br/>
  </fieldset>
  <?php
 }
 return !$erreur;
}
?>

