<?php
define("NON_TROUVE",-1)  ;
$choix=-1                ;
$tab_personnes=array()   ;
$nbpersonnes=0           ;
$sauvegarde_a_faire=false;
// ==============================
// ---      boucle de menu    ---
// ==============================
while ($choix !=0)
{ $choix=-1;
  echo "-1- Saisie d'une liste de personnes".PHP_EOL;
  echo "-2- Affichage de toutes les personnes".PHP_EOL;
  echo "-3- Sauvegarde dans un fichier".PHP_EOL;
  echo "-4- Chargement d'un fichier".PHP_EOL;
  echo "-0- Quitter".PHP_EOL;
  echo "Choix (1,2,3,...) : ";
  fscanf(STDIN,"%d",$choix);
  switch($choix)
  { case 1 : Saisie()    ;
             break;
    case 2 : Affichage() ;
             break;
    case 3 : Sauvegarde();
             break;
    case 4 : Chargement();
             break;
    case 0 : quitter();
             break;
    default : echo "Choix impossible !".PHP_EOL;
             break;        
  }
}
// =======================================
// --- saisie d'une liste de personnes ---
// =======================================
function Saisie()
{global $nbpersonnes       ;
 global $tab_personnes     ;
 global $sauvegarde_a_faire;
 $entree="saisie non vide";
 while (!empty($entree))
 {echo "Entrez un ID, un nom, un prénom et un âge (ex : 1;Dupont;Jean;28) : ";
  $entree=fgets(STDIN) ;
  // on supprime les espaces au début et à la fin et le saut de ligne
  $entree=trim($entree);
  // on vérifie que la saisie n'est pas vide
  if (!empty($entree))
  {$erreur_saisie=false;
   // rangement dans le tableau associatif
   list($une_personne['ID'],$une_personne['nom'],$une_personne['prenom'],$une_personne['age'])=explode(';',$entree);
   
   $indice=count($une_personne);
   $nb_champs=$indice+1;
   if ($indice <3)
   { echo "  Erreur : La saisie ne contient que $nb_champs champs ! ".PHP_EOL;
     $erreur_saisie=true;
   }
   else
   { // normalisation_nom et vérification de chaque champ
     foreach($une_personne as $etiquette => $val_champ)
     { if (($etiquette == 'nom') || ($etiquette == 'prenom') )
       { $une_personne[$etiquette]=normalisation_nom($val_champ);
       }
       if (($etiquette == 'ID') || ($etiquette == 'age'))
       { $val_champ=intval($val_champ)       ;
         $une_personne[$etiquette]=$val_champ;       
         if ($etiquette == 'ID')
         {$ID_unique=true;
          $ID_unique=verif_unicite_ID($val_champ);
          if ($ID_unique == false)
          { echo "  Erreur : Valeur du champ $etiquette est déjà utilisé ! ".PHP_EOL;
            $erreur_saisie=true;
          }
         }
         if ($val_champ <= 0)
         { echo "  Erreur : Valeur du champ $etiquette doit être un entier positif ! ".PHP_EOL;
           $erreur_saisie=true;
         }
       }
       if (empty($val_champ))
       { echo "  Erreur : Valeur du champ $etiquette  est non valide ! ".PHP_EOL;
         $erreur_saisie=true;
       }
     }
   }
   if (!$erreur_saisie)
   { // on renverse le tableau $une_personne à cause de l'ordre inverse de list
     $tab_personnes[]=array_reverse($une_personne);
     $nbpersonnes++;
     $sauvegarde_a_faire=true;
   }
   else
   {echo "  Erreur : Merci de saisir à nouveau les informations !".PHP_EOL;
   }
  }
 }
}
// ===========================================
// --- Affichage de la liste des personnes ---
// ===========================================
function Affichage()
{global $nbpersonnes   ;
 global $tab_personnes ;
 // tri du tableau en retirant les doublons
 sort($tab_personnes);
 $tab_personnes=array_unique($tab_personnes,SORT_REGULAR );
 if (count($tab_personnes) == 0)
 {echo "Aucune personne à afficher !".PHP_EOL;
 }
 else
 {affichage_tab_personnes($tab_personnes);
 }
}
// ==================================
// --- Sauvegarde dans un fichier ---
// ==================================
function Sauvegarde()
{global $nbpersonnes       ;
 global $tab_personnes     ;
 global $sauvegarde_a_faire;
 // tri du tableau en retirant les doublons
 sort($tab_personnes);
 $tab_personnes=array_unique($tab_personnes,SORT_REGULAR );
 $sauvegarde_confirmee=false;
 if ($nbpersonnes == 0)
 {echo "Aucun personne à sauvegarder !".PHP_EOL;
  echo "La sauvegarde videra le fichier !".PHP_EOL;
  echo "Confirmez la sauvegarde (o/n) :";
  fscanf(STDIN,"%s",$reponse);
  if ($reponse == "o")
  {$sauvegarde_confirmee=true;
  }
 }
 if (($nbpersonnes != 0) || $sauvegarde_confirmee)
 {echo "Nom du fichier de sauvegarde : ";
  $NomFichier=fgets(STDIN);
  // on normalise le nom du fichier
  $NomFichier=normalisation_fichier($NomFichier);
  // -- ouverture du fichier en mode écriture ---
  $f1 = @fopen($NomFichier, "wt");
  if (! $f1) // --- erreur d'ouverture ---
  { // -- on affiche les messages d'erreur ---
    echo "Erreur d'écriture du fichier $NomFichier".PHP_EOL;
  }
  else
  {// ----------------------------
   // --- boucle de sauvegarde ---
   // ----------------------------
   foreach ($tab_personnes as $etiquette => $une_personne)
   {// importation des variables à partir de l'étiquette des champs
    extract($une_personne,EXTR_OVERWRITE);
    fprintf($f1,"%d\t%s\t%s\t%d%s",$ID,$nom,$prenom,$age,PHP_EOL);
   }
   fclose($f1);
   if ($nbpersonnes == 0)
    echo "le fichier $NomFichier a été vidé".PHP_EOL;
   else
    echo "$nbpersonnes personne(s) sauvegardée(s) dans le fichier $NomFichier".PHP_EOL;
  }
  $sauvegarde_a_faire=false;
 }
}
// ===============================
// --- Chargement d'un fichier ---
// ===============================
function Chargement()
{global $nbpersonnes       ;
 global $tab_personnes     ;
 global $sauvegarde_a_faire;
 verif_sauvegarde()        ;
 // le chargement remplace les données actuelles du tableau => on vide le tableau
 $nbpersonnes=0;
 // on supprime les éléments actuels du tableau
 array_splice($tab_personnes,0,count($tab_personnes));
 // on met à jour le nombre de personnes
 $nbpersonnes=0;
 // on charge le fichier
 echo "Nom du fichier à charger : ";
 $NomFichier=fgets(STDIN);
 $NomFichier=normalisation_fichier($NomFichier);
 echo "Lecture de : $NomFichier".PHP_EOL;
 // -- ouverture du fichier en mode lecture ---
 $f1 = @fopen($NomFichier, "rt");
 if (! $f1) // --- erreur d'ouverture ---
 { // -- on affiche les messages d'erreur ---
   echo "Erreur de lecture du fichier $NomFichier".PHP_EOL;
 }
 else
 { // ----------------------------
   // --- boucle de chargement ---
   // ----------------------------
   while ($Tab_Info=fscanf($f1,"%d\t%s\t%s\t%d"))
   {list ($ID,$nom,$prenom,$age) = $Tab_Info;
    $nom   =normalisation_nom($nom)   ;
    $prenom=normalisation_nom($prenom);
    // vérification que cet ID n'est pas déjà utilisé
    $ID_unique=true;
    $ID_unique=verif_unicite_ID($ID);
    if ($ID_unique == false)
    { echo "Erreur : L'identifiant $ID est déjà utilisé par : ".PHP_EOL;
      $tab_numero=Recherche_sur_critere('a',$ID);
      foreach($tab_numero as $numero)
      {$tab_num_personnes[$numero]=$tab_personnes[$numero];
      }
      affichage_tab_personnes($tab_num_personnes);
      echo "==> Pas de chargement de : $ID\t$nom\t$prenom\t$age".PHP_EOL;
    }
    else
    { $tab_personnes[]=array('ID'=>$ID,'nom'=>$nom,'prenom'=>$prenom,'age'=>$age);
      $nbpersonnes++;
    }
   }
   echo "$nbpersonnes personne(s) lue(s)".PHP_EOL;
   fclose($f1);
 }
}
// ========================
// --- fonction quitter ---
// ========================
function Quitter()
{
 verif_sauvegarde();
 echo "Au revoir !".PHP_EOL;
}

// =================================================
// --- fonction outil de suppression des accents ---
// =================================================
function supprime_accent($chaine)
{// tableau des caractères accentués à remplacer
  $caracteres_a_remplacer     = array('À', 'Á', 'Â', 'Ã', 'Ä', 'Å', 'Æ', 'Ç', 'È', 'É', 'Ê', 'Ë', 'Ì', 'Í', 'Î', 'Ï', 'Ð', 'Ñ', 'Ò', 'Ó', 'Ô', 'Õ', 'Ö', 'Ø', 'Ù', 'Ú', 'Û', 'Ü', 'Ý', 'ß', 'à', 'á', 'â', 'ã', 'ä', 'å', 'æ', 'ç', 'è', 'é', 'ê', 'ë', 'ì', 'í', 'î', 'ï', 'ñ', 'ò', 'ó', 'ô', 'õ', 'ö', 'ø', 'ù', 'ú', 'û', 'ü', 'ý', 'ÿ', 'Ā', 'ā', 'Ă', 'ă', 'Ą', 'ą', 'Ć', 'ć', 'Ĉ', 'ĉ', 'Ċ', 'ċ', 'Č', 'č', 'Ď', 'ď', 'Đ', 'đ', 'Ē', 'ē', 'Ĕ', 'ĕ', 'Ė', 'ė', 'Ę', 'ę', 'Ě', 'ě', 'Ĝ', 'ĝ', 'Ğ', 'ğ', 'Ġ', 'ġ', 'Ģ', 'ģ', 'Ĥ', 'ĥ', 'Ħ', 'ħ', 'Ĩ', 'ĩ', 'Ī', 'ī', 'Ĭ', 'ĭ', 'Į', 'į', 'İ', 'ı', 'Ĳ', 'ĳ', 'Ĵ', 'ĵ', 'Ķ', 'ķ', 'Ĺ', 'ĺ', 'Ļ', 'ļ', 'Ľ', 'ľ', 'Ŀ', 'ŀ', 'Ł', 'ł', 'Ń', 'ń', 'Ņ', 'ņ', 'Ň', 'ň', 'ŉ', 'Ō', 'ō', 'Ŏ', 'ŏ', 'Ő', 'ő', 'Œ', 'œ', 'Ŕ', 'ŕ', 'Ŗ', 'ŗ', 'Ř', 'ř', 'Ś', 'ś', 'Ŝ', 'ŝ', 'Ş', 'ş', 'Š', 'š', 'Ţ', 'ţ', 'Ť', 'ť', 'Ŧ', 'ŧ', 'Ũ', 'ũ', 'Ū', 'ū', 'Ŭ', 'ŭ', 'Ů', 'ů', 'Ű', 'ű', 'Ų', 'ų', 'Ŵ', 'ŵ', 'Ŷ', 'ŷ', 'Ÿ', 'Ź', 'ź', 'Ż', 'ż', 'Ž', 'ž', 'ſ', 'ƒ', 'Ơ', 'ơ', 'Ư', 'ư', 'Ǎ', 'ǎ', 'Ǐ', 'ǐ', 'Ǒ', 'ǒ', 'Ǔ', 'ǔ', 'Ǖ', 'ǖ', 'Ǘ', 'ǘ', 'Ǚ', 'ǚ', 'Ǜ', 'ǜ', 'Ǻ', 'ǻ', 'Ǽ', 'ǽ', 'Ǿ', 'ǿ');
  // tableau des caractères sans accent de remplacement
  $caracteres_de_remplacement = array('A', 'A', 'A', 'A', 'A', 'A', 'AE', 'C', 'E', 'E', 'E', 'E', 'I', 'I', 'I', 'I', 'D', 'N', 'O', 'O', 'O', 'O', 'O', 'O', 'U', 'U', 'U', 'U', 'Y', 's', 'a', 'a', 'a', 'a', 'a', 'a', 'ae', 'c', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'n', 'o', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'y', 'y', 'A', 'a', 'A', 'a', 'A', 'a', 'C', 'c', 'C', 'c', 'C', 'c', 'C', 'c', 'D', 'd', 'D', 'd', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'G', 'g', 'G', 'g', 'G', 'g', 'G', 'g', 'H', 'h', 'H', 'h', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'IJ', 'ij', 'J', 'j', 'K', 'k', 'L', 'l', 'L', 'l', 'L', 'l', 'L', 'l', 'l', 'l', 'N', 'n', 'N', 'n', 'N', 'n', 'n', 'O', 'o', 'O', 'o', 'O', 'o', 'OE', 'oe', 'R', 'r', 'R', 'r', 'R', 'r', 'S', 's', 'S', 's', 'S', 's', 'S', 's', 'T', 't', 'T', 't', 'T', 't', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'W', 'w', 'Y', 'y', 'Y', 'Z', 'z', 'Z', 'z', 'Z', 'z', 's', 'f', 'O', 'o', 'U', 'u', 'A', 'a', 'I', 'i', 'O', 'o', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'A', 'a', 'AE', 'ae', 'O', 'o');
  // retour de la fonction
  return str_replace($caracteres_a_remplacer, $caracteres_de_remplacement, $chaine);
}
// =================================================
// --- fonction outil de normalisation des noms  ---
// =================================================
function normalisation_nom($chaine)
{// tableau des motifs de recherche
 $tab_motif=array('/[^a-zA-Z -]/', '/[ -]+/', '/^-|-$/');
 // tableau des caractères de remplacement
 $tab_remplacement=array('', '-', '')     ;
 // chaine de caractères sur laquelle s'effectue le remplacement
 $chaine_contexte=supprime_accent($chaine);
 // retour de la fonction
 return strtoupper(preg_replace($tab_motif,$tab_remplacement, $chaine_contexte));
}
// =============================================================
// --- fonction outil de normalisation des noms de fichiers  ---
// =============================================================
function normalisation_fichier($nomf)
{ // tableau des motifs de recherche
  $tab_motif=array('/[^a-zA-Z0-9 ._-]/','/[ -]+/','/^-|-$/');
  // tableau des caractères de remplacement
  $tab_remplacement=array('', '-', '')   ;
  // remplacement des caracteres non autorisés  et suppression des accents
  $nomf_retour=strtolower(preg_replace($tab_motif,$tab_remplacement,supprime_accent($nomf)));
  $nomf_retour=str_replace('-','_',$nomf_retour);
  // suppression de l'éventuelle extension
  $elements_chemin=pathinfo($nomf_retour);
  $nomf_retour=$elements_chemin['filename'];
  // -- on prépare le nom du répertoire de sauvegarde ---
  $repertoire_courant=realpath(".")      ;
  $repertoire_sauvegarde="../Sauvegardes/"  ;
  // -- on traite le nom du fichier ---
  $nomf_retour=$repertoire_sauvegarde.$nomf_retour.".txt";
  return $nomf_retour;
}
// ============================================================
// --- fonction outil d'affichage d'un tableau de personnes  ---
// ============================================================
function affichage_tab_personnes($tpersonnes)
{// entête de l'affichage
 echo "---------------------------------------------------------------".PHP_EOL;
 fprintf(STDOUT,"%6s : %6s %-20s %-20s %4s %s","Numéro","ID","Nom","Prénom"," Age",PHP_EOL);
 echo "---------------------------------------------------------------".PHP_EOL;
 foreach ($tpersonnes as $indice => $une_personne)
 {// importation des variables à partir de l'étiquette des champs
  extract($une_personne,EXTR_OVERWRITE);
  fprintf(STDOUT,"%6d : %6d %-20s %-20s %4d %s",$indice,$ID,$nom,$prenom,$age,PHP_EOL);
 }
 echo "---------------------------------------------------------------".PHP_EOL;
}
// ========================================================================================
// --- fonction outil de vérification de sauvegarde en cas de modification des données  ---
// ========================================================================================
function verif_sauvegarde()
{global $sauvegarde_a_faire;
 // on vérifie d'abord s'il y a une sauvegarde a faire
 if ($sauvegarde_a_faire)
 {echo "Attention les données ont été modifiées. !".PHP_EOL;
  echo "Voulez-vous sauvegarder les données actuelles avant de charger le fichier (o/n) : ";
  fscanf(STDIN,"%s",$reponse);
  if ($reponse == "o")
  {Sauvegarde();
  }
 }
}
// =====================================================================
// --- fonction outil de vérification de l'unicité de l'identifiant  ---
// =====================================================================
function verif_unicite_ID($identifiant)
{global $tab_personnes     ;
 $colonne_ID = array_column($tab_personnes, 'ID');
 $identifiant_existe=in_array($identifiant,$colonne_ID);
 $identifiant_valide = ! $identifiant_existe;
 return $identifiant_valide ;
}
?>

