<?php
// Démarrage de la session AVANT d'écrire du code HTML afin de
// conserver l'information indiquant si c'est le premier accès
// et pour transmettre le tableau des personnes
session_start();
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Saisie de plusieurs personnes</title>
    <link href="chargement_sauvegarde_liste_personnes_1page.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   define("WEB_EOL","<br/>");
   // L'appel provient d'un sauvegarder, on sauvegarde
   if (!empty($_POST['sauvegarder']))
   { // On récupère le nom du fichier
     if (isset($_POST['NomF'])) $NomF=$_POST['NomF'] ;
     else $NomF     = ''     ;
     if (empty($NomF))
     {?>
      <fieldset>
      <legend>Message :</legend><br/>
      <b>Sauvegarde impossible, le nom du fichier n'est pas indiqu&eacute; ! </b><br />
      </fieldset>
      <?php
     }
     else // On normalise le nom du fichier
     {$NomF    = trim($NomF)                          ;
      $NomF    = preg_replace('/\s{2,}/', ' ', $NomF) ;
      $NomF    = strtolower($NomF)                    ;
      $NomF    = str_replace(' ', '_', $NomF)         ;
      // On prépare le nom du répertoire de sauvegarde
      $RepCourant=realpath(".");
      $RepSauv="Sauvegardes/";
      // On traite le nom du fichier
      $ElementsChemin=pathinfo($NomF);
      $NomF=$RepSauv.$ElementsChemin['filename'].".txt";
      // Ouverture du fichier en mode écriture
      // On empêche les messages d'erreurs du fopen avec @
      $f1 = @fopen($NomF, "wt");
      if (! $f1) // Erreur d'ouverture
      { // On affiche les messages d'erreur
       $tab_erreurs      = error_get_last()       ;
       $erreur_type      = $tab_erreurs['type']   ;
       $erreur_message   = $tab_erreurs['message'];
       $erreur_programme = $tab_erreurs['file']   ;
       $erreur_ligne     = $tab_erreurs['line']   ;
       ?>
       <fieldset>
       <legend>Erreur :</legend><br/>
       <b>Sauvegarde impossible :</b> erreur d'ouverture du fichier <b><?php echo $NomF; ?></b> en écriture  ! <br /><br/>
       <b>Type de l'erreur :</b> <?php echo $erreur_type ; ?><br />
       <b>Message :</b> <?php echo $erreur_message; ?><br />
       <b>Répertoire de sauvegarde :</b> <?php echo $RepCourant."/".$RepSauv; ?><br /><br />
       <b>Programme PHP :</b> <?php echo $erreur_programme; ?><br />
       <b>A la ligne :</b> <?php echo $erreur_ligne; ?><br />
       </fieldset>
       <?php
      }
      else // On affiche le résultat de la sauvegarde
      {?>
       <fieldset>
       <legend>Message :</legend><br/>
       <?php echo "Sauvegarde dans le fichier <b>$NomF</b> : "."<br />";?>
       </fieldset>
       <table summary="Tableau des personnes">
       <caption>Tableau des personnes sauvegard&eacute;es</caption>
       <thead>
       <tr>
       <!-- entête du tableau -->
        <th>ID</th>
        <th>Nom</th>
        <th>Pr&eacute;nom</th>
        <th>Age</th>
        </tr>
       </thead>
       <?php
       $nb_sauvegardes=0;
       $tab_personnes=$_SESSION['tab_personnes'];
       foreach ($tab_personnes as $ID => $une_personne)
       {echo "<tr>";
        echo "<td>$ID</td>";
        // -- sauvegarde de l'ID ---
        fprintf($f1,"%d\t",$ID);
        foreach ($une_personne as $EtiqChamp => $ValChamp)
        {echo "<td>$ValChamp</td>";
         // -- sauvegarde de chaque élément ---
         fprintf($f1,"%s\t",$ValChamp);
        }
        echo "</tr>";
        // -- sauvegarde d'une fin de ligne ---
        fprintf($f1,"\n");
        $nb_sauvegardes++;
       }
       ?>
       </table>
       <?php
       // Fermeture du fichier de sauvegarde
       echo "<br />Nombre de personnes sauvegard&eacute;es : $nb_sauvegardes<br />";
       fclose($f1);
      }
     }
   }
   // L'appel provient d'un terminer, on affiche le tableau
   elseif (!empty($_POST['terminer']))
   {?>
    // Partie identique à tableau_saisie_affichage_web.php
    <table summary="Tableau des personnes">
     <caption>Tableau des personnes</caption>
     <thead>
     <tr>
     <!-- entête du tableau -->
        <th>ID</th>
        <th>Nom</th>
        <th>Pr&eacute;nom</th>
        <th>Age</th>
        </tr>
     </thead>
     <?php
     //Vérification que le tableau existe:au moins une saisie
     if (isset($_SESSION['tab_personnes']))
     {$tab_personnes=$_SESSION['tab_personnes'];
      foreach ($tab_personnes as $ID => $une_personne)
      {echo "<tr>";
       echo "<td>$ID</td>";
       foreach ($une_personne as $EtiqChamp => $ValChamp)
       {echo "<td>$ValChamp</td>";}
       echo "</tr>";
      }
     }
     else // Affichage d'un message dans le tableau 
     { echo "<td colspan=\"4\"><b>Aucune donn&eacute;e &agrave; afficher</b></td>";
       echo "</tr>";
     }?>
    </table>
    <?php
    //Vérification que le tableau existe:au moins une saisie
    if (isset($_SESSION['tab_personnes']))
    {// On affiche saisit le nom du fichier de sauvegarde 
     ?> <br/>
     <form action="fichier_saisie_sauvegarde_web.php" method="post">
     <fieldset>
     <legend>Saisissez le nom du fichier de sauvegarde :</legend><br/>
     Entrez le nom du fichier (ex : liste_personnes) : <input type="text" name="NomF" size="20" maxlength="20" autofocus/><br/><br/>
     <input type="submit" name="sauvegarder" value="Sauvegarder cette liste" />
     <input type="reset" value="Effacer le nom du fichier" />
     </fieldset>
     </form>
     <?php
    }
   }
   // Affichage du formulaire et des informations en dessous 
   else
   { ?> <!-- --- Affichage du formulaire --- -->
     <form action="fichier_saisie_sauvegarde_web.php" method="post">
     <!-- Idem à tableau_saisie_affichage_web.php -->
      <fieldset>
      <legend>Saisissez les donn&eacute;es d'une nouvelle personne :</legend><br/>
      Entrez un nom (ex : Dupont) : <input type="text" name="Nom" size="20" maxlength="20" autofocus/><br/><br/>
      Entrez un pr&eacute;nom (ex : Jean) : <input type="text" name="Prenom" size="40" maxlength="40" /><br/><br/>
      Entrez un &acirc;ge (ex : 28) : <input type="text" name="Age" size="3" maxlength="3" pattern="[1-9][0-9]{1,2}" /><br/><br/>
      <input type="submit" name="valider" value="Valider cette personne" />
      <!-- on ajoute le bouton terminer pour terminer la saisie  -->
      <input type="reset" value="Effacer le formulaire" />
      <input type="submit" name="terminer" value="Terminer la Saisie" />
      </fieldset>
     </form>
     <?php
     // Affichage du résultat du traitement précédent
     // - soit le rangement dans le tableau tab_personnes
     // - soit un message d'erreur (sauf premier affichage)
     // --- on récupère les valeurs saisies ---
     if (isset($_POST['Nom'])) $Nom = $_POST['Nom'] ;
     else $Nom     = ''     ;
     if (isset($_POST['Prenom'])) $Prenom = $_POST['Prenom'] ;
     else $Prenom     = ''  ;
     if (isset($_POST['Age'])) $Age = $_POST['Age'] ;
     else $Age     = ''     ;
     // --- traitement des données saisies ---
     // Suppression des espaces : début, fin et multiples
     // Remplace espace par un moins noms et prénoms composés
     // -- Nom --
     $Nom    = trim($Nom)                          ;
     $Nom    = preg_replace('/\s{2,}/', ' ', $Nom) ;
     $Nom    = strtolower($Nom)                    ;
     $Nom    = ucwords($Nom)                       ;
     $Nom    = str_replace(' ', '-', $Nom)         ;
     // -- Prenom --
     $Prenom = trim($Prenom)                         ;
     $Prenom = preg_replace('/\s{2,}/', ' ', $Prenom);
     $Prenom = strtolower($Prenom)                   ;
     $Prenom = ucwords($Prenom)                      ;
     $Prenom = str_replace(' ', '-', $Prenom)        ;
     // -- Age --
     $Age = trim($Age)                          ;
     $Age = preg_replace('/\s{2,}/', ' ', $Age) ;
     // Si ce n'est pas la première saisie
     if (isset($_SESSION['Afficher_Messages_Champs']))
     {// Vérification que la saisie n'est pas vide
      if (!empty($Nom) && !empty($Prenom) && !empty($Age) )
      {$Age = intval($Age)                        ;
       if (!(($Age>0)&&($Age<120)))
        echo "Le champ Age est invalide".WEB_EOL;
       else
       {?>
        <table summary="Rangement dans le tableau">
         <caption>Derni&eacute;re personne saisie</caption>
         <thead>
          <tr>
          <!-- entête du tableau -->
           <th>Nom</th>
           <th>Pr&eacute;nom</th>
           <th>Age</th>
          </tr>
         </thead>
         <tr>
          <td><?php echo $Nom    ; ?></td>
          <td><?php echo $Prenom ; ?></td>
          <td><?php echo $Age    ; ?></td>
         </tr>
        </table>
        <?php
        // rangement dans tab_personnes de la session
        $_SESSION['tab_personnes'][]=array($Nom,$Prenom,$Age);
        }
      }
      // Affichage des messages d'erreur si champs vides
      else
      {echo "<fieldset>";
       echo "<legend>Valeurs &agrave; renseigner :</legend><br/>";
       if (empty($Nom))    echo "Le champ Nom est vide".WEB_EOL;
       if (empty($Prenom)) echo "Le champ Pr&eacute;nom est vide".WEB_EOL;
       if (empty($Age))    echo "Le champ Age est vide".WEB_EOL;
       if ($Age == 0)      echo "Le champ Age est invalide".WEB_EOL;
       echo "</fieldset>";
      }
     }
     // Ce n'est pas la première saisie:la variable indiquant
     // d'afficher les messages d'erreurs est positionnée
     else
     {
      $_SESSION['Afficher_Messages_Champs']="oui";
     }
   }
   ?>
 </body>
</html>
