<?php
// Démarrage de la session AVANT d'écrire du code HTML afin de
// conserver l'information indiquant si c'est le premier accès
// et pour transmettre le tableau des personnes
session_start();
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Chargement fichier de personnes</title>
	<link href="chargement_sauvegarde_liste_personnes_1page.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   define("WEB_EOL","<br/>");
   // L'appel provient d'un charger, on charge le fichier
   if (!empty($_POST['charger']))
   { // On récupère le nom du fichier 
     if (isset($_POST['NomFichier'])) $NomF = $_POST['NomFichier'] ;
     else $NomF = '' ;
     if (empty($NomF))
     {?>
      <fieldset>
      <legend>Message :</legend><br/>
      <b>Chargement impossible, le nom du fichier n'est pas indiqu&eacute; ! </b><br />
      </fieldset>
      <?php
     }
     else
     {// On normalise le nom du fichier
      $NomF = trim($NomF)                      ;
      $NomF = preg_replace('/\s{2,}/', ' ', $NomF);
      $NomF = strtolower($NomF)                ;
      $NomF = str_replace(' ', '_', $NomF)     ;
      // On prépare le nom du répertoire de Chargement
      $RepCourant=realpath(".")     ;
      $RepCharge="Sauvegardes/" ;      
      // On traite le nom du fichier
      $ElemChemin=pathinfo($NomF);
      $NomF=$RepCharge.$ElemChemin['filename'].".txt";     
      // Ouverture du fichier en mode lecture
      // On empêche l'affichage des messages d'erreurs avec @
      $f1 = @fopen($NomF, "rt");
      if (! $f1) // Erreur d'ouverture
      { // On affiche les messages d'erreur
       $tab_erreurs      = error_get_last()       ;
       $erreur_type      = $tab_erreurs['type']   ;
       $erreur_message   = $tab_erreurs['message'];
       $erreur_programme = $tab_erreurs['file']   ;
       $erreur_ligne     = $tab_erreurs['line']   ;
       ?>
       <fieldset>
       <legend>Erreur :</legend><br/>
       <b>Chargement impossible :</b> erreur d'ouverture du fichier <b><?php echo $NomF; ?></b> en lecture  ! <br /><br/>
       <b>Type de l'erreur :</b> <?php echo $erreur_type ; ?><br />
       <b>Message :</b> <?php echo $erreur_message; ?><br />
       <b>Répertoire de Chargement :</b> <?php echo $RepCourant."/".$RepCharge; ?><br /><br />
       <b>Programme PHP :</b> <?php echo $erreur_programme; ?><br />
       <b>A la ligne :</b> <?php echo $erreur_ligne; ?><br />
       </fieldset>
       <?php
      }
      else // On charge le tableau, et on l’affiche
      { ?>
       <fieldset>
       <legend>Message :</legend><br/>
       <?php echo "Chargement du fichier <b>$NomF</b> : "."<br />";?>
       </fieldset>
       <table summary="Tableau des personnes">
       <caption>Tableau des personnes lues à partir du fichier</caption>
       <thead>
       <tr>
       <!-- entête du tableau -->
        <th>ID</th>
        <th>Nom</th>
        <th>Pr&eacute;nom</th>
        <th>Age</th>
        </tr>
       </thead>
       <?php
       // Rangement dans tab_personnes de la session
       $nb_Chargements=0;
       while ($Tab_Info=fscanf($f1,"%d\t%s\t%s\t%d"))
       { list($ID,$Nom,$Prenom,$Age) = $Tab_Info;
         $_SESSION['tab_personnes'][$ID]=array($Nom,$Prenom,$Age) ;
         $nb_Chargements++;
         echo "<tr>";
         echo "<td>$ID</td>";
         echo "<td>$Nom</td>";
         echo "<td>$Prenom</td>";
         echo "<td>$Age</td>";
         echo "</tr>";
       }
       ?></table><?php
       // Fermeture du fichier de Chargement
       echo "<br />Nombre de personnes lues : $nb_Chargements<br />";
       fclose($f1);
      }
     }
   }
   else // On affiche le formulaire de saisie
   { ?>
     <br/>
     <!-- <form action="fichier_affichage_chargement_web.php" method="post"> -->
     <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
      <fieldset>
      <legend>Saisissez le nom du fichier &agrave; charger :</legend><br/>
      Entrez le nom du fichier (ex : liste_personnes) : <input type="text" name="NomFichier" size="20" maxlength="20" autofocus/><br/><br/>
      <input type="submit" name="charger" value="Charger le fichier" />
      <input type="reset" value="Effacer le nom du fichier" />
      </fieldset>
     </form>
     <?php
   }?>
 </body>
</html>
