<?php
// On démarre la session AVANT d'écrire du code HTML
// afin de conserver l'information indiquant si c'est le premier accès
session_start();
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Simulation pr&ecirc;t</title>
	<link href="style_amortissement_1page.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   // ===============================
   // === on récupère les données ===
   // ===============================
   // L'affichage provient d'un reset, on vide les variables
   if (!empty($_POST['reset']))
   {
     $Capital          = '' ;
     $NbAn             = '' ;
     $EtNbMois         = '' ;
     $TauxAssurance    = '' ;
     $TauxAnnuelHA     = '' ;
     unset($_SESSION['Afficher_Messages_Champs']);
   }
   else   // sinon on récupère leur valeur pour initialiser le formulaire
   {
     if (isset($_POST['Capital'])) $Capital = $_POST['Capital'] ;
     else $Capital = '' ;
     if (isset($_POST['NbAn'])) $NbAn = $_POST['NbAn'] ;
     else $NbAn = '' ;
     if (isset($_POST['EtNbMois'])) $EtNbMois = $_POST['EtNbMois'] ;
     else $EtNbMois = '' ;
     if (isset($_POST['TauxAssurance'])) $TauxAssurance = $_POST['TauxAssurance'] ;
     else $TauxAssurance = '' ;
     if (isset($_POST['TauxAnnuelHA'])) $TauxAnnuelHA = $_POST['TauxAnnuelHA']    ;
     else $TauxAnnuelHA = '' ;
   }
   ?>
   <!--
   --------------------------------
   --- on affiche le formulaire ---
   --------------------------------
   -->
        <!-- <form action="credit_amortissement_tableau_web_1page.php" method="post"> -->
        <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
         <fieldset>
          <legend>Saisissez les informations du pr&ecirc;t :</legend><br />
            <label for="Capital">Capital emprunt&eacute; :&nbsp;
            <input type="text" maxlength="7" name="Capital" size="20" placeholder="350000" autofocus required pattern="[0-9]{3,7}" value=<?php echo "\"$Capital\"" ?>/> &euro;<br /><br />
            <label for="NbAn">Nombre d'ann&eacute;es :&nbsp;
            <input type="text" maxlength="2" name="NbAn" size="2" placeholder="15" required pattern="[0-9]{1,2}" value=<?php echo "\"$NbAn\"" ?>/> ans<br /><br />
            <label for="EtNbMois">Et Nombre de Mois :&nbsp;
            <input type="text" maxlength="2" name="EtNbMois" size="2" placeholder="0" pattern="[0-9]{1,2}" value=<?php echo "\"$EtNbMois\"" ?>/> mois<br /><br />
            <label for="TauxAnnuelHA">Taux Annuel Hors Assurance :&nbsp;
            <input type="text" maxlength="5" name="TauxAnnuelHA" size="5" placeholder="2,63" required pattern="[0-9]{1,2}[\.\,][0-9]{1,2}" value=<?php echo "\"$TauxAnnuelHA\"" ?>/> %<br /><br />
            <label for="TauxAssurance">Taux de l'Assurance :&nbsp;
            <input type="text" maxlength="5" name="TauxAssurance" size="5" placeholder="0,29" required pattern="0[\.\,][0-9]{1,3}" value=<?php echo "\"$TauxAssurance\"" ?>/> %<br /><br />
            <input type="submit" value="Valider" />
            <!-- on modifie le bouton de type reset pour le transformer en submit  -->
            <!-- afin que PHP puisse détecter cette action via $_POST[]            -->
            <!-- <input type="reset" value="Effacer le formulaire" />              -->
            <input type="submit" name="reset" value="Effacer le formulaire" />
          </fieldset>
        </form>
   <?php
   // -----------------------------------------------------
   // --- Après du formulaire, on affiche soit :        ---
   // ---   * la liste des champs qui manquent          ---
   // ---   * la synthèse et le tableau d'amortissement ---
   // -----------------------------------------------------
   // si le nombre de mois est vide on le met à 0 
   if(empty($EtNbMois)) { $EtNbMois=0;}
   // on teste les autres variables
   if(empty($Capital)||empty($NbAn)||empty($TauxAssurance)||empty($TauxAnnuelHA))
   {
     // --- Un des champs du formulaire est vide => on affiche la liste des champs vide à saisir
     // --- sauf si c'est le premier accès à la page  
     if (!isset($_SESSION['Afficher_Messages_Champs']))
     {
      $_SESSION['Afficher_Messages_Champs'] = "oui";
     }
     // avec le formulaire HTML5 le contrôle est fait en amont.
     // Cet affichage n'est plus utile car dans cet exemple
     // tous les champs sont obligatoires donc contrôlés au moment du formulaire.
     // Avec des champs non obligatoires dans le formulaire le cas du else sera utilisé
     else
     {
      ?>
      <fieldset>
      <legend>Valeurs &agrave; renseigner :</legend><br>
      <?php
      if(empty($Capital))      echo "Capital <br>";
      if(empty($NbAn))         echo "Nombre d'ann&eacute;es <br>";
      if(empty($TAssurance))   echo "Taux de l'Assurance <br>";
      if(empty($TauxAnnuelHA)) echo "Taux Annuel Hors Assurance <br>";
      ?>
      </fieldset>
      <?php
     }
   }
   else
   {
    // =============================
    // === on traite les données ===
    // =============================
    // --- remplacement de la virgule par un point décimal
    $Capital        = str_replace(",",".",$Capital)        ;
    $TauxAssurance  = str_replace(",",".",$TauxAssurance)  ;
    $TauxAnnuelHA   = str_replace(",",".",$TauxAnnuelHA)   ;
    // --- conversion dans le bon type de données
    $Capital        = floatval($Capital)      ;
    $NbAn           = intval($NbAn)           ;
    $TauxAssurance  = floatval($TauxAssurance);
    $TauxAnnuelHA   = floatval($TauxAnnuelHA) ;
    // ===============================
    // === on effectue les calculs ===
    // ===============================
    $NbMois         = ($NbAn*12)+$EtNbMois ;
    //    $NbAnEtMois     = round($NbMois/12,2)  ;
    $AssMensuelle   = round((($Capital*($TauxAssurance/100))/12),2);
    $TauxMensuel    = ($TauxAnnuelHA/100)/12                  ;
    // --- mensualité ---
    $calcul1        = $Capital*$TauxMensuel                   ;
    $calcul2        = pow((1+$TauxMensuel),$NbMois)           ;
    $calcul3        = $calcul2-1                              ;
    $MensualiteHA   = round(($calcul1*($calcul2/$calcul3)),2) ;
    $MensualiteAC   = $MensualiteHA+$AssMensuelle             ;
    $MensualiteInit = $MensualiteAC                           ;
    // ---------------------------------
    // Calcul du tableau d'amortissement
    // ---------------------------------
    $TotMensualiteAC  = 0       ;
    $TotInterets      = 0       ;
    $TotAmortissement = 0       ;
    $TotAssMens       = 0       ;
    $CapRestant       = $Capital;
    // --- déclaration d'un tableau ---
    $Tab_Amort=array();
    // --- boucle de mémorisation des informations dans le tableau ---  
    for ($NumEcheance=1 ; $NumEcheance<=$NbMois ; $NumEcheance++)
    {
      $Interets=round($CapRestant*$TauxMensuel,2)    ;
      $Amortissement=$MensualiteHA-$Interets         ;
      $CapRestant=round($CapRestant-$Amortissement,2);
      // correction de la dernière échéance
      if (($NumEcheance==$NbMois) &&($CapRestant != 0))
      {
         $MensualiteAC+=$CapRestant  ;
         $Amortissement+=$CapRestant ;
         $CapRestant=0               ;
      }
      $TotMensualiteAC+=$MensualiteAC  ;
      $TotAmortissement+=$Amortissement;
      $TotInterets+=$Interets          ;
      $TotAssMens+=$AssMensuelle       ;
      // -------------------------------------------------
      // On mémorise les informations de chaque mensualité
      // -------------------------------------------------
      // -- autre syntaxe pour un tableau associatif à deux dimensions --
      // $Tab_Amort[$NumEcheance] = array("MensualiteAC" => $MensualiteAC, "Amortissement" => $Amortissement, "Interets" => $Interets, "CapRestant" => $CapRestant);
      $Tab_Amort[$NumEcheance]["MensualiteAC"]  = $MensualiteAC ;
      $Tab_Amort[$NumEcheance]["Amortissement"] = $Amortissement;
      $Tab_Amort[$NumEcheance]["Interets"]      = $Interets     ;  
      // $Tab_Amort[$NumEcheance]["AssMens"]      = $AssMensuelle     ; // inutile car l'assurance mensuelle reste inchangée  
      $Tab_Amort[$NumEcheance]["CapRestant"]    = $CapRestant   ;
    }
    // --- calculs complémentaire du coût du crédit ---
    $PourcentCoutHA = round(($TotInterets/$Capital)*100,2)  ;
    $CoutCreditAC   = $TotInterets+$TotAssMens              ;
    $PourcentCoutAC = round(($CoutCreditAC/$Capital)*100,2) ;  
    // ===============================
    // === Affichage des résultats ===
    // ===============================
    // --- on prépare les résultat pour afficher au format français --- 
    $Cap_FR     = number_format($Capital,2,","," ")." &euro;"       ;
    $TauxAss_FR = number_format($TauxAssurance,3,","," ")." %"      ;
    $TauxAHA_FR = number_format($TauxAnnuelHA,2,","," ")." %"       ;
    $MensHA_FR  = number_format($MensualiteHA,2,","," ")." &euro;"  ;
    $MensAC_FR  = number_format($MensualiteAC,2,","," ")." &euro;"  ;
    $MensACI_FR = number_format($MensualiteInit,2,","," ")." &euro;";
    $AssMens_FR = number_format($AssMensuelle,2,","," ")." &euro;"     ;
    // --- on prépare les résultat pour afficher au format français --- 
    $CoutHA_FR      = number_format($TotInterets,2,","," ")." &euro;"  ;
    $PcentCoutHA_FR = number_format($PourcentCoutHA,2,","," ")." %"    ;
    $CoutAM_FR      = number_format($TotAssMens,2,","," ")." &euro;"   ;
    $CoutAC_FR      = number_format($CoutCreditAC,2,","," ")." &euro;" ;
    $PcentCoutAC_FR = number_format($PourcentCoutAC,2,","," ")." %"    ;
    ?>
    <!--
    // ----------------------
    // On affiche la synthèse
    // ----------------------
    // version avec la balise div
    -->
    <div class="Tableau">
      <div class="col01">
       <h4>Synth&egrave;se du cr&eacute;dit</h4>
       <p>Mensualité Assurance Comprise </p>
       <p>Assurance par mois </p>
       <p>Coût Total Assurance </p>
       <p>Coût Total du crédit Hors Ass </p>
       <p>Coût Total du crédit Ass Comp </p>
      </div>
      <div class="col02">
       <h4>Montant</h4>
       <p><b><?php echo $MensACI_FR ; ?></b></p>
       <p><?php echo $AssMens_FR    ; ?></p>
       <p><?php echo $CoutAM_FR     ; ?></p>
       <p><?php echo $CoutHA_FR     ; ?></p>
       <p><?php echo $CoutAC_FR     ; ?></p>
      </div>
      <div class="col02">
       <h4>% du Capital emprunt&eacute;</h4>
         <div class="col02n">
          <p>&nbsp;</p>
          <p>&nbsp;</p>
          <p>&nbsp;</p>
        </div>
        <div class="col02c">
          <p><?php echo $PcentCoutHA_FR ; ?></p>
          <p><?php echo $PcentCoutAC_FR ; ?></p>
        </div>
      </div>
    </div>
    <p>&nbsp;</p>
    <!--
    ---------------------------------------------------------
    On affiche l'entête et le pied du tableau d'amortissement
    ---------------------------------------------------------
    -->
    <table summary="Tableau d'amortissement">
      <caption>Tableau d'amortissement</caption>
      <thead>
        <tr>
         <th>N&deg; Ech&eacute;ance</th>
         <th>Mensualit&eacute; Assurance Comprise &euro;</th>
         <th>Amortissement en &euro;</th>
         <th>Int&eacute;r&ecirc;ts &euro;</th>
         <th>Assurance &euro;</th>
         <th>Capital Restant D&ucirc; &euro;</th>
        </tr>
      </thead>
      <tfoot>
        <tr>
         <th>N&deg; Ech&eacute;ance</th>
         <th>Mensualit&eacute; Assurance Comprise &euro;</th>
         <th>Amortissement &euro;</th>
         <th>Int&eacute;r&ecirc;ts &euro;</th>
         <th>Assurance &euro;</th>
         <th>Capital Restant D&ucirc; &euro;</th>
        </tr>
      </tfoot>
    <?php
    // ----------------------------
    // Affichage de chaque échéance
    // ----------------------------
    for ($NumEcheance=1 ; $NumEcheance<=$NbMois ; $NumEcheance++) 
    {
     $MensualiteAC  = $Tab_Amort[$NumEcheance]["MensualiteAC"]  ;
     $Amortissement = $Tab_Amort[$NumEcheance]["Amortissement"] ;
     $Interets      = $Tab_Amort[$NumEcheance]["Interets"]      ;
     $CapRestant    = $Tab_Amort[$NumEcheance]["CapRestant"]    ;
     // --- on prépare les résultat pour afficher au format français --- 
     $Mens_MensAC_FR   = number_format($MensualiteAC,2,","," ")." &euro;" ;
     $Mens_Amort_FR    = number_format($Amortissement,2,","," ")." &euro;";
     $Mens_Inter_FR    = number_format($Interets,2,","," ")." &euro;"     ;
     $Mens_CapRest_FR  = number_format($CapRestant,2,","," ")." &euro;"   ;
     ?>
     <tr>
       <td><?php echo $NumEcheance    ; ?></td>
       <td><?php echo $Mens_MensAC_FR ; ?></td>
       <td><?php echo $Mens_Amort_FR  ; ?></td>
       <td><?php echo $Mens_Inter_FR  ; ?></td>
       <td><?php echo $AssMens_FR     ; ?></td>
       <td><?php echo $Mens_CapRest_FR; ?></td>
     </tr>
     <?php
    }
    // ---------------------
    // On affiche les totaux
    // ---------------------
    // --- on prépare les résultat pour afficher au format français --- 
    $TotMensAC_FR  = number_format($TotMensualiteAC,2,","," ")." &euro;" ;
    $TotAmort_FR   = number_format($TotAmortissement,2,","," ")." &euro;";
    $TotInter_FR   = number_format($TotInterets,2,","," ")." &euro;"     ;
    $TotAssMens_FR = number_format($TotAssMens,2,","," ")." &euro;"      ;
    ?>
    <tr>
      <td><b>TOTAL</b></td>
      <td><b><?php echo $TotMensAC_FR ; ?></b></td>
      <td><b><?php echo $TotAmort_FR  ; ?></b></td>
      <td><b><?php echo $TotInter_FR  ; ?></b></td>
      <td><b><?php echo $TotAssMens_FR; ?></b></td>
      <td></td>
    </tr>
    </table>
    <?php
   }
   ?>
 </body>
</html>
