<?php
$NomFichier="donnees_utilisateurs.data";
$fichier_binaire = fopen($NomFichier, "wb");
// --------------------------------------------
// --- saisie d'une liste de personnes ---
// --------------------------------------------
$saisie="saisie non vide";
$nb_personnes=0;
$chaine_octets="";
while (!empty($saisie))
{
 echo "Entrez un nom, une profession, un pays et un âge (ex : Dupont Etudiant France 28) : ";
 $saisie=fgets(STDIN);
 // --- traitement de la chaîne lue, ---
 // suppression des espaces au début , à la fin et suppression du saut de ligne
 $saisie=trim($saisie);
 // remplace les espaces multiples par un seul espace
 $saisie= preg_replace('/\s{2,}/',' ',$saisie);
 // on vérifie que la saisie n'est pas vide
 if (!empty($saisie))
 {
  // rangement dans les variables
  list($nom,$profession,$pays,$age)=explode(' ',$saisie);
  // -------------------------
  // écriture dans le fichier
  // -------------------------
  // -- compactage des octets dans une chaîne d'octets --
  // -- nom --
  $taille=strlen($nom)+1;
  $chaine_octets .= pack("c",$taille);
  $chaine_octets .= pack("a{$taille}",$nom);
  // -- profession --
  $taille=strlen($profession)+1;
  $chaine_octets .= pack("c",$taille);
  $chaine_octets .= pack("a{$taille}",$profession);
  // -- pays --
  $taille=strlen($pays)+1;
  $chaine_octets .= pack("c",$taille);
  $chaine_octets .= pack("a{$taille}",$pays);
  // -- age --
  $chaine_octets .= pack("c",$age);

  $nb_personnes++;
 }
}
echo "--- Sauvegarde dans $NomFichier : $nb_personnes personnes---".PHP_EOL;
// -- écriture --
fwrite($fichier_binaire, $chaine_octets);
fclose($fichier_binaire);
?>
