<?php
// Tableau une dimension des codes postaux
$CP = array (
    'CRETEIL'    => 94000,
    'NICE'       => 6000,
    'LA_BAULE'   => 44500,
    'STRASBOURG' => 67000);
// Tableau une dimension des départements d'appartenance
$DEPT = array (
    'CRETEIL'    => 'Val-de-Marne',
    'NICE'       => 'Alpes-Maritimes',
    'LA_BAULE'   => 'Loire-Atlantique',
    'STRASBOURG' => 'Bas-Rhin');
    
// Tableau deux dimensions des codes postaux et départements
$CP_DEPT = array (
    'CRETEIL'   => array ('CP' => 94000, 'DEPT' => 'Val-de-Marne'),
    'NICE'      => array ('CP' => 6000, 'DEPT' => 'Alpes-Maritimes'),
    'LA_BAULE'  => array ('CP' => 44500, 'DEPT' => 'Loire-Atlantique'),
    'STRASBOURG'=> array ('CP' => 67000, 'DEPT' => 'Bas-Rhin'));
    
$TAB1 = array (0,-1,3,4);
$TAB2 = array ('a'=>18,'b'=>19,'c'=>33,'d'=>44);
    
// affichage des tableaux
echo '--- Affichage de $CP ---'.PHP_EOL;
print_r($CP);
echo '--- Affichage de $DEPT ---'.PHP_EOL;
print_r($DEPT);
echo '--- Affichage de $CP_DEPT ---'.PHP_EOL;
print_r($CP_DEPT);

echo '--- array_chunk ---'.PHP_EOL;
print_r(array_chunk($CP,2));

echo '--- array_column ---'.PHP_EOL;
print_r(array_column($CP_DEPT,'DEPT'));

echo '--- array_combine ---'.PHP_EOL;
print_r(array_combine($CP,$DEPT));

echo '--- array_count_values ---'.PHP_EOL;
print_r(array_count_values($DEPT));

echo '--- array_flip ---'.PHP_EOL;
print_r(array_flip($DEPT));

echo '--- array_merge ---'.PHP_EOL;
print_r(array_merge($TAB1,$TAB2));

echo '--- array_push ---'.PHP_EOL;
array_push($TAB1,100,200,300);
print_r($TAB1);

echo '--- array_rand ---'.PHP_EOL;
$clefs=array_rand($TAB1,2);
print_r($clefs);

echo '--- array_reverse ---'.PHP_EOL;
print_r(array_reverse($TAB1));

echo '--- array_slice ---'.PHP_EOL;
print_r(array_slice($TAB1,2,3));

echo '--- array_splice ---'.PHP_EOL;
array_splice($TAB1,2,4);
print_r($TAB1);

echo '--- array_sum ---'.PHP_EOL;
echo array_sum($TAB2);
echo PHP_EOL;

echo '--- array_unshift ---'.PHP_EOL;
array_unshift($TAB2,1000,2000);
print_r($TAB2);

echo '--- array_walk_recursive ---'.PHP_EOL;
function aff($val, $clef)
{echo "Case $clef : $val\n";}
array_walk_recursive($CP_DEPT, 'aff');

echo '--- array_walk ---'.PHP_EOL;
array_walk($TAB2, 'aff');

echo '--- arsort ---'.PHP_EOL;
arsort($DEPT);
print_r($DEPT);

echo '--- asort ---'.PHP_EOL;
asort($DEPT);
print_r($DEPT);

echo '--- compact ---'.PHP_EOL;
$ville  = "CRETEIL";
$code = 94000;
$depart = "Val-de-Marne";
$tab = compact("ville", "code", "depart");
print_r($tab);

echo '--- extract ---'.PHP_EOL;
extract($DEPT);
echo "$CRETEIL, $NICE, $LA_BAULE, $STRASBOURG\n";

echo '--- count ---'.PHP_EOL;
echo count($DEPT);
echo PHP_EOL;

echo '--- sizeof ---'.PHP_EOL;
echo sizeof($DEPT);
echo PHP_EOL;

echo '--- ksort ---'.PHP_EOL;
ksort($DEPT);
print_r($DEPT);

echo '--- krsort ---'.PHP_EOL;
krsort($DEPT);
print_r($DEPT);

echo '--- range ---'.PHP_EOL;
$tab=range(0,12,2);
print_r($tab);

echo '--- shuffle ---'.PHP_EOL;
shuffle($tab);
print_r($tab);

echo '--- rsort ---'.PHP_EOL;
rsort($DEPT);
print_r($DEPT);

echo '--- sort ---'.PHP_EOL;
sort($DEPT);
print_r($DEPT);

echo '--- implode ---'.PHP_EOL;
$chaine_separateur = implode(";", $CP);
var_dump($chaine_separateur);

echo '--- split ---'.PHP_EOL;
// Les délimiteurs peuvent être des tirets, points ou slash
$date = "04/03/2015";
list($jour, $mois, $annee) = split('[/.-]', $date);
echo "Jour : $jour; Mois : $mois; Année : $annee".PHP_EOL;

echo '--- preg_split ---'.PHP_EOL;
// scinde la phrase grâce aux virgules et espacements
// ce qui inclus les " ", \r, \t, \n et \f
$tab = preg_split("/[\s,]+/", "voila un, exemple");
print_r($tab);

?>


