<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
  <meta charset="utf-8" />
  <title>Simulation pr&ecirc;t</title>
  <link href="style_simulateur_2pages.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
 <?php
  // --- on récupère les données ---
  $Capital     = $_POST['Capital']        ;
  $NbAn        = $_POST['NbAn']           ;
  $TAssurance  = $_POST['TauxAssurance']  ;
  $TAnnuel_Min = $_POST['TauxAnnuel_Min'] ;
  $TAnnuel_Max = $_POST['TauxAnnuel_Max'] ;
  $TAnnuel_Pas = $_POST['TauxAnnuel_Pas'] ;
  if(empty($Capital) || empty($NbAn) || empty($TAnnuel_Min) || empty($TAnnuel_Max) || empty($TAnnuel_Pas) || empty($TAssurance))
  {
    ?>
    <fieldset>
    <legend>Valeurs &agrave; renseigner :</legend><br/>
    <?php
    if(empty($Capital))     echo "Capital <br/>";
    if(empty($NbAn))        echo "Nombre d'ann&eacute;es <br/>";
    if(empty($TAnnuel_Min)) echo "Taux Annuel Hors Assurance initial <br/>";
    if(empty($TAnnuel_Max)) echo "Taux Annuel Hors Assurance final <br/>";
    if(empty($TAnnuel_Pas)) echo "Intervalle de progression du taux  <br/>";
    if(empty($TAssurance))  echo "Taux de l'Assurance <br/>";
    ?>
    </fieldset>
  <?php
  }
  else
  {
    ?>
    <table summary="SOMMAIRE : Résultat de la simulation">
    <caption>R&eacute;sultat de la simulation</caption>
    <thead>
      <tr>
        <th>Taux Simulation %</th>
        <th>Mensualit&eacute; Assurance Comprise &euro;</th>
        <th>Assurance &euro;</th>
        <th colspan="2">Co&ucirc;t du Cr&eacute;dit en &euro; et en % du capital emprunt&eacute;</th>
      </tr>
    </thead>
    <tfoot>
      <tr>
        <th>Taux Simulation %</th>
        <th>Mensualit&eacute; Assurance Comprise &euro;</th>
        <th>Assurance &euro;</th>
        <th colspan="2">Co&ucirc;t du Cr&eacute;dit en &euro; et en % du capital emprunt&eacute;</th>
      </tr>
    </tfoot>
    <?php
    // --- on traite les données ---
    // --- remplacement de la virgule par un point décimal
    $Capital     = str_replace(",",".",$Capital)    ;
    $TAnnuel_Min = str_replace(",",".",$TAnnuel_Min);
    $TAnnuel_Max = str_replace(",",".",$TAnnuel_Max);
    $TAnnuel_Pas = str_replace(",",".",$TAnnuel_Pas);
    $TAssurance  = str_replace(",",".",$TAssurance) ;
    // --- conversion dans le bon type de données
    $Capital     = floatval($Capital)     ;
    $NbAn        = intval($NbAn)          ;
    $TAnnuel_Min = floatval($TAnnuel_Min) ;
    $TAnnuel_Max = floatval($TAnnuel_Max) ;
    $TAnnuel_Min = floatval($TAnnuel_Min) ;
    $TAnnuel_Pas = floatval($TAnnuel_Pas) ;
    $TAssurance  = floatval($TAssurance)  ;
    // --- on effectue les calculs et on affiche les résultats ---
    $NbMois = $NbAn*12 ;
    $CoutAss = round((($Capital*($TAssurance/100))/12),2);
    for ($TAnnuel=$TAnnuel_Min ; $TAnnuel<=$TAnnuel_Max ; $TAnnuel+=$TAnnuel_Pas)
    {
     $TauxMensuel  = ($TAnnuel/100)/12                      ;
     $calcul1      = $Capital*$TauxMensuel                  ;
     $calcul2      = pow((1+$TauxMensuel),$NbMois)          ;
     $calcul3      = $calcul2-1                             ;
     $MensualiteHA = round(($calcul1*($calcul2/$calcul3)),2);
     $MensualiteAC = $MensualiteHA+$CoutAss                 ;
     $CoutCredit   = ($MensualiteHA*$NbMois)-$Capital       ;
     $PourcentCout = ($CoutCredit/$Capital)*100             ;     
     // on prépare les résultat pour afficher au format français
     $TauxA     = number_format($TAnnuel,2,","," ")." %"       ;
     $MensHA    = number_format($MensualiteHA,2,","," ")." &euro;";
     $MensAC    = number_format($MensualiteAC,2,","," ")." &euro;";
     $CoutA     = number_format($CoutAss,2,","," ")." &euro;"     ;
     $CoutC     = number_format($CoutCredit,2,","," ")." &euro;"  ;
     $PcentCout = number_format($PourcentCout,2,","," ")." %"     ;
     ?>
     <tr>
       <td><?php echo $TauxA    ; ?></td>
       <td><?php echo $MensAC   ; ?></td>
       <td><?php echo $CoutA    ; ?></td>
       <td><?php echo $CoutC    ; ?></td>
       <td><?php echo $PcentCout; ?></td>
     </tr>
     <?php
    }
    ?>
    </table>
    <?php
  }
 ?>
 </body>
</html>

