<?php
// On démarre la session AVANT d'écrire du code HTML
// afin de conserver l'information indiquant si c'est le premier accès
session_start();
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Simulation pr&ecirc;t</title>
	<link href="style_simulateur_1page.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   // -------------------------------
   // --- on récupère les données ---
   // -------------------------------
   // si l'affichage de la page provient d'un reset, on vide les variables
   if (!empty($_POST['reset']))
   {
     $Capital     = '' ;
     $NbAn        = '' ;
     $TAnnuel_Min = '' ;
     $TAnnuel_Max = '' ;
     $TAnnuel_Pas = '' ;
     $TAssurance  = '' ;
     unset($_SESSION['Afficher_Messages_Champs']);
   }
   else   // sinon on récupère leur valeur pour initialiser le formulaire
   {
    if (isset($_POST['Capital'])) $Capital = $_POST['Capital']  ;
    else $Capital     = '' ;
    if (isset($_POST['NbAn'])) $NbAn = $_POST['NbAn']  ;
    else $NbAn     = '' ;
    if (isset($_POST['TAnnuel_Min'])) $TAnnuel_Min = $_POST['TAnnuel_Min'] ;
    else $TAnnuel_Min     = '' ;
    if (isset($_POST['TAnnuel_Max'])) $TAnnuel_Max = $_POST['TAnnuel_Max'] ;
    else $TAnnuel_Max     = '' ;
    if (isset($_POST['TAnnuel_Pas'])) $TAnnuel_Pas = $_POST['TAnnuel_Pas'] ;
    else $TAnnuel_Pas     = '' ;
    if (isset($_POST['TAssurance'])) $TAssurance  = $_POST['TAssurance']  ;
    else $TAssurance     = '' ;
   }
   ?>
   <!--
   --------------------------------
   --- on affiche le formulaire ---
   --------------------------------
   -->
   <!-- <form action="for_simulateur_credit_web_1page.php" method="post"> -->
   <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
    <fieldset>
    <legend>Saisissez les informations de simulation du pr&ecirc;t :</legend><br>
      Capital (exemple : 300000)&nbsp;:&nbsp;<input type="text" maxlength="7" name="Capital" size="7" value=<?php echo "\"$Capital\"" ?>/> &euro;<br><br>
      Nombre d'ann&eacute;es (exemple : 15)&nbsp;:&nbsp; <input type="text" maxlength="2" name="NbAn" size="2" value=<?php echo "\"$NbAn\"" ?>/> ans<br><br>
      Taux de l'Assurance (exemple : 0,29)&nbsp;:&nbsp; <input type="text" maxlength="5" name="TAssurance" size="5" value=<?php echo "\"$TAssurance\"" ?>/> %<br><br><br>
      Taux Annuel Hors Assurance initial  (exemple : 2,6)&nbsp;:&nbsp; <input type="text" maxlength="5" name="TAnnuel_Min" size="5" value=<?php echo "\"$TAnnuel_Min\"" ?>/> %<br><br>
      Taux Annuel Hors Assurance final (exemple : 3,6)&nbsp;:&nbsp; <input type="text" maxlength="5" name="TAnnuel_Max" size="5" value=<?php echo "\"$TAnnuel_Max\"" ?>/> %<br><br>
      Pas de progression du taux (exemple : 0,1)&nbsp;:&nbsp; <input type="text" maxlength="5" name="TAnnuel_Pas" size="5" value=<?php echo "\"$TAnnuel_Pas\"" ?>/> %<br><br>
      <input type="submit" value="Valider" />
      <!-- on modifie le bouton de type reset pour le transformer en submit  -->
      <!-- afin que PHP puisse détecter cette action via $_POST[]             -->
      <!-- <input type="reset" value="Effacer le formulaire" />              -->
      <input type="submit" name="reset" value="Effacer le formulaire" />
    </fieldset>
   </form>
   <?php
   // ----------------------------------------------
   // --- Après le formulaire, on affiche soit : ---
   // ---   * la liste des champs qui manquent   ---
   // ---   * le tableau des résultats           ---
   // ----------------------------------------------
   if(empty($Capital)||empty($NbAn)||empty($TAnnuel_Min)||empty($TAnnuel_Max)||empty($TAnnuel_Pas)||empty($TAssurance))
   {
     // --- Un des champs du formulaire est vide => on affiche la liste des champs vide à saisir
     // --- sauf si c'est le premier accès à la page  
     if (!isset($_SESSION['Afficher_Messages_Champs']))
     {
      $_SESSION['Afficher_Messages_Champs'] = "oui";
     }
     else // on affiche le message d'erreur
     {
      ?>
      <fieldset>
      <legend>Valeurs &agrave; renseigner :</legend><br>
      <?php
      if(empty($Capital))     echo "Capital <br>";
      if(empty($NbAn))        echo "Nombre d'ann&eacute;es <br>";
      if(empty($TAssurance))  echo "Taux de l'Assurance <br>";
      if(empty($TAnnuel_Min)) echo "Taux Annuel Hors Assurance initial <br>";
      if(empty($TAnnuel_Max)) echo "Taux Annuel Hors Assurance final <br>";
      if(empty($TAnnuel_Pas)) echo "Intervalle de progression du taux  <br>";
      ?>
      </fieldset>
      <?php
     }
   }
   else
   {
     // -------------------------------------------
     // --- On affiche le tableau des résultats ---
     // -------------------------------------------
     ?>
     <table summary="SOMMAIRE : Résultat de la simulation">
     <caption>R&eacute;sultat de la simulation</caption>
     <thead>
        <tr>
        <!-- entête du tableau -->
         <th>Taux Simulation<br>en %</th>
         <th>Mensualit&eacute;<br>Assurance Comprise<br>en &euro;</th>
         <th>Assurance<br>en &euro;</th>
         <th colspan="2">Co&ucirc;t du Cr&eacute;dit<br>en &euro; et en % du capital emprunt&eacute;</th>
        </tr>
     </thead>
     <!-- pied du tableau -->
     <tfoot>
        <tr>
         <th>Taux Simulation<br>en %</th>
         <th>Mensualit&eacute;<br>Assurance Comprise<br>en &euro;</th>
         <th>Assurance<br>en &euro;</th>
         <th colspan="2">Co&ucirc;t du Cr&eacute;dit<br>en &euro; et en % du capital emprunt&eacute;</th>
        </tr>
     </tfoot>
     <?php
     // --- on traite les données  ---
     // --- remplacement de la virgule par un point décimal
     $Capital     = str_replace(",",".",$Capital)     ;
     $TAnnuel_Min = str_replace(",",".",$TAnnuel_Min) ;
     $TAnnuel_Max = str_replace(",",".",$TAnnuel_Max) ;
     $TAnnuel_Pas = str_replace(",",".",$TAnnuel_Pas) ;
     $TAssurance  = str_replace(",",".",$TAssurance)  ;
     // --- conversion dans le bon type de données
     $Capital     = floatval($Capital)     ;
     $NbAn        = intval($NbAn)          ;
     $TAnnuel_Min = floatval($TAnnuel_Min) ;
     $TAnnuel_Max = floatval($TAnnuel_Max) ;
     $TAnnuel_Min = floatval($TAnnuel_Min) ;
     $TAnnuel_Pas = floatval($TAnnuel_Pas) ;
     $TAssurance  = floatval($TAssurance)  ;
     // --- on effectue les calculs et on affiche les résultats ---
     $NbMois = $NbAn*12 ;
     $CoutAss = round((($Capital*($TAssurance/100))/12),2);
     for ($TAnnuel=$TAnnuel_Min ; $TAnnuel<=$TAnnuel_Max ; $TAnnuel+=$TAnnuel_Pas)
     {
      $TauxMensuel  = ($TAnnuel/100)/12                      ;
      $calcul1      = $Capital*$TauxMensuel                  ;
      $calcul2      = pow((1+$TauxMensuel),$NbMois)          ;
      $calcul3      = $calcul2-1                             ;
      $MensualiteHA = round(($calcul1*($calcul2/$calcul3)),2);
      $MensualiteAC = $MensualiteHA+$CoutAss                 ;
      $CoutCredit   = ($MensualiteHA*$NbMois)-$Capital       ;
      $PourcentCout = ($CoutCredit/$Capital)*100             ;
      // on prépare les résultat pour afficher au format français
      $TauxA     = number_format($TAnnuel,2,","," ")." %"       ;
      $MensHA    = number_format($MensualiteHA,2,","," ")." &euro;";
      $MensAC    = number_format($MensualiteAC,2,","," ")." &euro;";
      $CoutA     = number_format($CoutAss,2,","," ")." &euro;"     ;
      $CoutC     = number_format($CoutCredit,2,","," ")." &euro;"  ;
      $PcentCout = number_format($PourcentCout,2,","," ")." %"     ;
      ?>
      <!-- --- on affiche une ligne du tableau  --- -->
      <tr>
        <td><?php echo $TauxA    ; ?></td>
        <td><?php echo $MensAC   ; ?></td>
        <td><?php echo $CoutA    ; ?></td>
        <td><?php echo $CoutC    ; ?></td>
        <td><?php echo $PcentCout; ?></td>
      </tr>
      <?php
     }
   }
   ?>
 </body>
</html>
