<!DOCTYPE html>
<html>
  <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Tableau d'amortissement du pr&ecirc;t</title>
    <link href="style_amortissement_2pages.css" rel="stylesheet" type="text/css" /> 
  </head>
  <body>
  <?php
   define("W_EOL","<br />");
   // --- on récupère les données ---
   $Capital          = $_POST['Capital']       ;
   $NbAn             = $_POST['NbAn']          ;
   $EtNbMois         = $_POST['EtNbMois']      ;
   $TauxAssurance    = $_POST['TauxAssurance'] ;
   $TauxAnnuelHA     = $_POST['TauxAnnuelHA']  ;
   // si le nombre de mois est vide on le met à 0 
   if(empty($EtNbMois)) { $EtNbMois=0;}
   // si l'une des autres données initiales est vide on affiche un message d'erreur
   if(empty($Capital)||empty($NbAn)||empty($TauxAssurance)||empty($TauxAnnuelHA))
   {
    ?>
    <fieldset>
    <legend>Valeurs &agrave; renseigner :</legend><br>
    <?php
    if(empty($Capital))       echo "Capital".W_EOL;
    if(empty($NbAn))          echo "Nombre d'ann&eacute;es".W_EOL;
    if(empty($TauxAnnuelHA))  echo "Taux Annuel Hors Assurance".W_EOL;
    if(empty($TauxAssurance)) echo "Taux de l'Assurance".W_EOL;
    ?>
    </fieldset>
    <?php
   }
   else // on effectue les calculs
   { // --- on traite les données  ---
    // --- remplacement de la virgule par un point décimal
    $Capital        = str_replace(",",".",$Capital)      ;
    $TauxAssurance  = str_replace(",",".",$TauxAssurance);
    $TauxAnnuelHA   = str_replace(",",".",$TauxAnnuelHA) ;
    // --- conversion dans le bon type de données
    $Capital        = floatval($Capital)      ;
    $NbAn           = intval($NbAn)           ;
    $EtNbMois       = intval($EtNbMois)       ;
    $TauxAssurance  = floatval($TauxAssurance);
    $TauxAnnuelHA   = floatval($TauxAnnuelHA) ;
    // -------------------------------
    // --- on effectue les calculs ---
    // -------------------------------
    $NbMois         = ($NbAn*12)+$EtNbMois ;
    $NbAnEtMois     = round($NbMois/12,2)  ;
    $AssMensuelle   = round((($Capital*($TauxAssurance/100))/12),2);
    $TauxMensuel    = ($TauxAnnuelHA/100)/12                  ;
    // --- mensualité ---
    $calcul1        = $Capital*$TauxMensuel                   ;
    $calcul2        = pow((1+$TauxMensuel),$NbMois)           ;
    $calcul3        = $calcul2-1                              ;
    $MensualiteHA   = round(($calcul1*($calcul2/$calcul3)),2) ;
    $MensualiteAC   = $MensualiteHA+$AssMensuelle             ;
    // --- coût du crédit ---
    $CoutCreditHA   = ($MensualiteHA*$NbMois)-$Capital        ;
    $PourcentCoutHA = round(($CoutCreditHA/$Capital)*100,2)   ;
    $CoutAss        = $AssMensuelle*$NbMois                   ;
    $CoutCreditAC   = $CoutCreditHA+$CoutAss                  ;
    $PourcentCoutAC = round(($CoutCreditAC/$Capital)*100,2)   ;
    // --- on prépare les résultat pour afficher au format français --- 
    $Cap         = number_format($Capital,2,","," ")." &euro;"      ;
    $TauxAss     = number_format($TauxAssurance,3,","," ")." %"     ;
    $TauxAHA     = number_format($TauxAnnuelHA,2,","," ")." %"      ;
    $MensHA      = number_format($MensualiteHA,2,","," ")." &euro;" ;
    $MensAC      = number_format($MensualiteAC,2,","," ")." &euro;" ;
    $CoutA       = number_format($CoutAss,2,","," ")." &euro;"      ;
    $CoutAC      = number_format($CoutCreditAC,2,","," ")." &euro;" ;
    $CoutHA      = number_format($CoutCreditHA,2,","," ")." &euro;" ;
    $PcentCoutHA = number_format($PourcentCoutHA,2,","," ")." %"    ;
    $PcentCoutAC = number_format($PourcentCoutAC,2,","," ")." %"    ;
    $AssM        = number_format($AssMensuelle,2,","," ")." &euro;" ;
    $NbAM        = number_format($NbAnEtMois,2,","," ")             ;
    // --- Calcul du tableau d'amortissement ---
    $TotMensualiteAC  = 0       ;
    $TotInterets      = 0       ;
    $TotAmortissement = 0       ;
    $TotAssMens       = 0       ;
    $CapRestant       = $Capital;
    // --------------------------------------------------------
    // --- on affiche un résumé des informations initiales  ---
    // --------------------------------------------------------
    ?>
    <div class="Tableau">
       <div class="col01">
        <h4>R&eacute;sum&eacute; de la demande</h4>
        <p>Capital</p>
        <p>Nombre d'ann&eacute;es</p>
        <p>Taux Annuel Hors assurance</p>
        <p>Taux de l'assurance</p>
       </div>
     
       <div class="col02">
        <h4>Valeurs Saisies</h4>
        <p><b><?php echo $Cap ; ?></b></p>
        <p><?php echo $NbAM   ; ?></p>
        <p><?php echo $TauxAHA; ?></p>
        <p><?php echo $TauxAss; ?></p>
       </div>
    </div>
    <!--
    // -------------------------------
    // --- on affiche la synthèse  ---
    // -------------------------------
    // version avec la balise div
    -->
    <div class="Tableau">
       <div class="col01">
        <h4>Synth&egrave;se du cr&eacute;dit</h4>
        <p>Mensualité Assurance Comprise </p>
        <p>Assurance par mois </p>
        <p>Coût Total Assurance </p>
        <p>Coût Total du crédit Hors Ass </p>
        <p>Coût Total du crédit Ass Comp </p>
       </div>
     
       <div class="col02">
        <h4>Montant</h4>
        <p><b><?php echo $MensAC; ?></b></p>
        <p><?php echo $AssM     ; ?></p>
        <p><?php echo $CoutA    ; ?></p>
        <p><?php echo $CoutHA   ; ?></p>
        <p><?php echo $CoutAC   ; ?></p>
       </div>
     
       <div class="col02">
        <h4>% du Capital emprunt&eacute;</h4>
        <div class="col02n">
          <p>&nbsp;</p>
          <p>&nbsp;</p>
          <p>&nbsp;</p>
        </div>
        <div class="col02c">
          <p><?php echo $PcentCoutHA ; ?></p>
          <p><?php echo $PcentCoutAC ; ?></p>
        </div>
       </div>
    </div>
    <br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br />
    <!--   Version avec un tableau
    <table summary="Synthèse du Crédit">
       <caption>Synth&egrave;se du cr&eacute;dit</caption>
       <thead>
       </thead>
       <tr>
         <td>Mensualit&eacute; Assurance Comprise en &euro;</td>
         <td><?php echo $MensAC   ; ?></td>
       </tr>
       <tr>
         <td>Assurance par mois en &euro;</td>
         <td><?php echo $AssM     ; ?></td>
       </tr>
       <tr>
         <td>Co&ucirc;t Total Assurance en &euro;</td>
         <td><?php echo $CoutA    ; ?></td>
       </tr>
       <tr>
         <td>Co&ucirc;t Total du cr&eacute;dit Hors Ass en &euro;</td>
         <td><?php echo $CoutHA   ; ?></td>
       </tr>
       <tr>
         <td>Co&ucirc;t Total du cr&eacute;dit Hors Ass en %</td>
         <td><?php echo $PcentCoutHA ; ?></td>
       </tr>
       <tr>
         <td>Co&ucirc;t Total du cr&eacute;dit Ass Comp en &euro;</td>
         <td><?php echo $CoutAC   ; ?></td>
       </tr>
       <tr>
         <td>Co&ucirc;t Total du cr&eacute;dit Ass Comp en %</td>
         <td><?php echo $PcentCoutAC ; ?></td>
       </tr>
    </table>
    -->
    <!--
     ------------------------------------------------------------------
     --- on affiche l'entête et le pied du tableau d'amortissement  ---
     ------------------------------------------------------------------
    -->
    <table summary="Tableau d'amortissement">
       <caption>Tableau d'amortissement</caption>
       <thead>
         <tr>
          <th>N&deg; Ech&eacute;ance</th>
          <th>Mensualit&eacute; Assurance Comprise &euro;</th>
          <th>Amortissement en &euro;</th>
          <th>Int&eacute;r&ecirc;ts &euro;</th>
          <th>Assurance &euro;</th>
          <th>Capital Restant D&ucirc; &euro;</th>
         </tr>
       </thead>
       <tfoot>
         <tr>
          <th>N&deg; Ech&eacute;ance</th>
          <th>Mensualit&eacute; Assurance Comprise &euro;</th>
          <th>Amortissement &euro;</th>
          <th>Int&eacute;r&ecirc;ts &euro;</th>
          <th>Assurance &euro;</th>
          <th>Capital Restant D&ucirc; &euro;</th>
         </tr>
       </tfoot>
       <?php
       for ($NumEcheance=1 ; $NumEcheance<=$NbMois ; $NumEcheance++)
       {
        $Interets=round($CapRestant*$TauxMensuel,2)    ;
        $Amortissement=$MensualiteHA-$Interets         ;
        $CapRestant=round($CapRestant-$Amortissement,2);
        // correction de la dernière échéance
        if (($NumEcheance==$NbMois) &&($CapRestant != 0))
        {
          $MensualiteAC+=$CapRestant ;
          $Amortissement+=$CapRestant;
          $CapRestant=0              ;
          // on corrige la somme affichée pour la dernière mensualité
          $MensAC      = number_format($MensualiteAC,2,","," ")." &euro;" ;
        }
        $TotMensualiteAC+=$MensualiteAC  ;
        $TotInterets+=$Interets          ;
        $TotAmortissement+=$Amortissement;
        $TotAssMens+=$AssMensuelle       ;
        // --- on prépare les résultat pour afficher au format français --- 
        $AmortCal    = number_format($Amortissement,2,","," ")." &euro;";
        $InterCal    = number_format($Interets,2,","," ")." &euro;"     ;
        $CapRestCal  = number_format($CapRestant,2,","," ")." &euro;"   ;
        // --- Affichage de chaque échéance --- 
        ?>
        <tr>
         <td><?php echo $NumEcheance ; ?></td>
         <td><?php echo $MensAC      ; ?></td>
         <td><?php echo $AmortCal    ; ?></td>
         <td><?php echo $InterCal    ; ?></td>
         <td><?php echo $AssM        ; ?></td>
         <td><?php echo $CapRestCal  ; ?></td>
        </tr>
        <?php
       }
       // -------------------------------
       // --- on affiche les totaux   ---
       // -------------------------------
       // --- on prépare les résultat pour afficher au format français --- 
       $TotMensAC = number_format($TotMensualiteAC,2,","," ")." &euro;" ;
       $TotAmort  = number_format($TotAmortissement,2,","," ")." &euro;";
       $TotInter  = number_format($TotInterets,2,","," ")." &euro;"     ;
       $TotAssM   = number_format($TotAssMens,2,","," ")." &euro;"      ;
       ?>
       <tr>
         <td><b>TOTAL</b></td>
         <td><b><?php echo $TotMensAC ; ?></b></td>
         <td><b><?php echo $TotAmort  ; ?></b></td>
         <td><b><?php echo $TotInter  ; ?></b></td>
         <td><b><?php echo $TotAssM   ; ?></b></td>
         <td></td>
       </tr>
      </table>
   <?php
   }
   ?>
  </body>
</html>

