<!DOCTYPE html>
<html>    
 <head> <!-- Entête HTML --> 
   <meta charset="utf-8" />
   <title>Fonctions sur les entiers</title>
 </head>
 <body>
 <?php
 define("WEB_EOL","<br/>");
 echo "======= abs() ========".WEB_EOL;
 echo 'Valeur absolue de -18 : '.abs(-18).WEB_EOL;
 echo "======= rand() ========".WEB_EOL;
 echo 'Nombre al&eacute;atoire entre 0 et '.getrandmax()." : ";
 echo rand() . WEB_EOL;
 echo "Nombre al&eacute;atoire entre 1 et 49 : ";
 echo rand(1, 49) . WEB_EOL;

 echo "======= srand() et rand() ========".WEB_EOL;
 srand((double) microtime() * 1000000); 
 echo 'Nombre al&eacute;atoire entre 0 et '.getrandmax()." : ";
 echo rand() . WEB_EOL;
 srand((double) microtime() * 1000000); 
 echo "Nombre al&eacute;atoire entre 1 et 49 : ";
 echo rand(1, 49) . WEB_EOL;

 echo "======= is_int() ========".WEB_EOL;
 $i=18;
 echo "is_int($i)=";
 echo var_dump(is_int($i)).WEB_EOL;

 $values = array(23, "23", 23.5, "23.5", null, true, false);

 echo "--- tableau ---".WEB_EOL ;
 var_export($values);
 echo WEB_EOL."---------------".WEB_EOL ;
 foreach ($values as $value)
 {
    echo "is_int(";
    var_export($value);
    echo ") = ";
    var_dump(is_int($value));
    echo WEB_EOL;
 }
 echo "======= intval() ========".WEB_EOL;
 echo 'intval(42) = '.intval(42).WEB_EOL;             // 42
 echo 'intval(4.2) = '.intval(4.2).WEB_EOL;           // 4
 echo 'intval(\'42\') = '.intval('42').WEB_EOL;       // 42
 echo 'intval(\'+42\') = '.intval('+42').WEB_EOL;     // 42
 echo 'intval(\'-42\') = '.intval('-42').WEB_EOL;     // -42
 echo 'intval(042) = '.intval(042).WEB_EOL;           // 34
 echo 'intval(\'042\') = '.intval('042').WEB_EOL;     // 42
 echo 'intval(1e10) = '.intval(1e10).WEB_EOL;         // 10000000000
 echo 'intval(\'1e10\') = '.intval('1e10').WEB_EOL;   // 1
 echo 'intval(0x1A) = '.intval(0x1A).WEB_EOL;         // 26
 echo 'intval(42000000) = '.intval(42000000).WEB_EOL; // 42000000
 echo 'intval(9223372036854775808) = '.intval(9223372036854775808).WEB_EOL;   // -9223372036854775808
 echo 'intval(\'9223372036854775808\') = '.intval('9223372036854775808').WEB_EOL; // 9223372036854775807
 echo 'intval(42, 8) = '.intval(42, 8).WEB_EOL;       // 42
 echo 'intval(\'42\', 8) = '.intval('42', 8).WEB_EOL; // 34
 echo 'intval($values) = '.intval($values).WEB_EOL;   // 1
 ?>
 </body>
</html>
