<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Retour Paiement Paybox</title>
	<link href="CSS/saisie_client_paybox.css" rel="stylesheet" type="text/css" /> 
 </head>
 <?php
 include 'INCLUDE/fonction_include_sprog.php';
 setlocale(LC_ALL, 'fr_FR.UTF-8');
 // ------------------------------------------------------
 // --- Récupération des différents éléments de retour ---
 // ------------------------------------------------------
 $code_erreur        = "00000"  ; // valeur PAYBOX E
 $montant            = 0        ; // valeur PAYBOX M
 $reference          = ""       ; // valeur PAYBOX R
 $autorisation       = ""       ; // valeur PAYBOX A
 $num_appel_paybox   = 0        ; // valeur PAYBOX T
 $numero_transaction = 0        ; // valeur PAYBOX S
 $heure_trans        = ""       ; // valeur PAYBOX Q
 $date_trans         = ""       ; // valeur PAYBOX W
 $date_fin_carte     = ""       ; // valeur PAYBOX D
 $numero_debut_carte = ""       ; // valeur PAYBOX N
 $numero_fin_carte   = ""       ; // valeur PAYBOX J
 $type_carte         = ""       ; // valeur PAYBOX C
 $empreinte_carte    = ""       ; // valeur PAYBOX H
 $pays_internaute    = ""       ; // valeur PAYBOX I
 $pays_carte         = ""       ; // valeur PAYBOX Y
 $garantie_3D_secure = ""       ; // valeur PAYBOX G
 $type_paiement      = ""       ; // valeur PAYBOX P
 $num_abonnement     = ""       ; // valeur PAYBOX B

 if (!empty($_GET['erreur']))  $code_erreur        = $_GET['erreur']  ; // valeur PAYBOX E
 if (!empty($_GET['mtant']))   $montant            = $_GET['mtant']   ; // valeur PAYBOX M
 if (!empty($_GET['ref']))     $reference          = $_GET['ref']     ; // valeur PAYBOX R
 if (!empty($_GET['auto']))    $autorisation       = $_GET['auto']    ; // valeur PAYBOX A
 if (!empty($_GET['appel']))   $num_appel_paybox   = $_GET['appel']   ; // valeur PAYBOX T
 if (!empty($_GET['ntrans']))  $numero_transaction = $_GET['ntrans']  ; // valeur PAYBOX S
 if (!empty($_GET['htrans']))  $heure_trans        = $_GET['htrans']  ; // valeur PAYBOX Q
 if (!empty($_GET['dtrans']))  $date_trans         = $_GET['dtrans']  ; // valeur PAYBOX W
 if (!empty($_GET['dfin']))    $date_fin_carte     = $_GET['dfin']    ; // valeur PAYBOX D
 if (!empty($_GET['ndcarte'])) $numero_debut_carte = $_GET['ndcarte'] ; // valeur PAYBOX N
 if (!empty($_GET['nfcarte'])) $numero_fin_carte   = $_GET['nfcarte'] ; // valeur PAYBOX J
 if (!empty($_GET['tcarte']))  $type_carte         = $_GET['tcarte']  ; // valeur PAYBOX C
 if (!empty($_GET['epcarte'])) $empreinte_carte    = $_GET['epcarte'] ; // valeur PAYBOX H
 if (!empty($_GET['paysi']))   $pays_internaute    = $_GET['paysi']   ; // valeur PAYBOX I
 if (!empty($_GET['paysc']))   $pays_carte         = $_GET['paysc']   ; // valeur PAYBOX Y
 if (!empty($_GET['gar']))     $garantie_3D_secure = $_GET['gar']     ; // valeur PAYBOX G
 if (!empty($_GET['tpt']))     $type_paiement      = $_GET['tpt']     ; // valeur PAYBOX P
 if (!empty($_GET['nab']))     $num_abonnement     = $_GET['nab']     ; // valeur PAYBOX B
 // -----------------------------------------
 // --- traitement des valeurs retournées ---
 // -----------------------------------------
 // --- traitement des erreurs ---
 // --- chargement du tableau des codes d'erreurs ---
 $Tab_Erreurs=chargement_codes_erreurs();
 if ($code_erreur == "00000") $msg_erreur="Paiement Valid&eacute;";
 elseif ($code_erreur == "00001") $msg_erreur="Paiement Annul&eacute;";
 else $msg_erreur="Paiement Refus&eacute;";
 if (!empty($Tab_Erreurs[$code_erreur]))
   $code_erreur=$code_erreur." : ".$Tab_Erreurs[$code_erreur];
 // --- traitement du montant ---
 if ($montant == 0)
    $Montant_formate="Aucune transaction";
 else
    $Montant_formate=number_format($montant/100,2,","," ")." &euro;";
 // --- traitement de la date de validité de la carte ---
 date_default_timezone_set('Europe/Paris');
 if (empty($date_fin_carte))
  $date_fin_carte_formatee="Non d&eacute;fini";
 else
 {
  $timestamp_en_secondes=mktime(0,0,0,substr($date_fin_carte,2,2),date("d"),substr($date_fin_carte,0,2));
  $date_fin_carte_formatee=ucwords(strftime("%B-%Y",$timestamp_en_secondes));
 }
 // --- traitement du numéro de la carte ---
if (empty($numero_debut_carte))
    $numero_carte="Non d&eacute;fini";
 else
    $numero_carte=$numero_debut_carte."********".$numero_fin_carte;
 // --- traitement des pays ---
 // --- chargement du tableau des pays ---
 $Tab_Pays=chargement_codes_pays();
 // --- Pays de l'adresse IP de l'internaute ---
 if (!empty($Tab_Pays[$pays_internaute]))
   $pays_internaute=$Tab_Pays[$pays_internaute]['MIN']." ($pays_internaute)";
 else
   $pays_internaute="Non d&eacute;fini";
 // --- Pays de la banque émettrice de la carte ---
 if (!empty($Tab_Pays[$pays_carte]))
   $pays_carte=$Tab_Pays[$pays_carte]['MIN']." ($pays_carte)";
 else
   $pays_carte="Non d&eacute;fini";
 // --- traitement de la garantie par 3D Secure ---
 if (empty($garantie_3D_secure))
   $garantie_3D_secure="Pas utilisé";
 elseif ($garantie_3D_secure == "O")
   $garantie_3D_secure="Oui";
 else
   $garantie_3D_secure="Non";
 // --- traitement de la date de la transaction ---
 if ((empty($date_trans)) && (empty($heure_trans)))
  $date_heure_transaction="Non d&eacute;fini";
 else
  $date_heure_transaction=substr($date_trans,0,2)."-".substr($date_trans,2,2)."-".substr($date_trans,4,4)." à ".$heure_trans;
 // --- traitement de l'empreinte de la carte ---
 if (empty($empreinte_carte))
    $empreinte_carte="Non d&eacute;fini";
 // --- traitement du type de la carte ---
 if (empty($type_carte))
    $type_carte="Non d&eacute;fini";
 // --- traitement de l'autorisation ---
 if (empty($autorisation))
    $autorisation="Non d&eacute;fini";
 // --- traitement du numéro de la transaction ---
 if ($numero_transaction == 0)
    $numero_transaction="Aucune transaction";
 // --- traitement du numéro d'appel Paybox ---
 if ($num_appel_paybox == 0)
    $num_appel_paybox="Aucune transaction";
 // --- traitement du type de carte ---
 if (empty($type_carte))
    $type_carte="Non d&eacute;fini";
 // --- traitement du type de carte ---
 if (empty($num_abonnement))
    $num_abonnement="Non d&eacute;fini";

 // ----------------------------------------------------
 // --- Affichage du tableau du résultat du paiement ---
 // ----------------------------------------------------
 ?>
 <table summary="R&eacute;sultat du paiement">
   <caption>R&eacute;sultat du paiement</caption>
   <?php
   echo "<tr><td>Statut</td><td>$msg_erreur</td></tr>";
   echo "<tr><td>Code retour</td><td>$code_erreur</td></tr>";
   echo "<tr><td>Référence</td><td>$reference</td></tr>";
   echo "<tr><td>Montant</td><td>$Montant_formate</td></tr>";
   echo "<tr><td>Autorisation</td><td>$autorisation</td></tr>";
   echo "<tr><td>N&deg; d’appel Paybox</td><td>$num_appel_paybox</td></tr>";
   echo "<tr><td>N&deg; transaction</td><td>$numero_transaction</td></tr>";
   echo "<tr><td>Date et Heure de la transaction</td><td>$date_heure_transaction</td></tr>";
   echo "<tr><td>Type de paiement</td><td>$type_paiement</td></tr>";
   echo "<tr><td>Type de la carte</td><td>$type_carte</td></tr>";
   echo "<tr><td>N&deg;carte</td><td>$numero_carte</td></tr>";
   echo "<tr><td>Fin de validit&eacute; de la carte</td><td>$date_fin_carte_formatee</td></tr>";
   echo "<tr><td>Pays de la banque</td><td>$pays_carte</td></tr>";
   echo "<tr><td>Empreinte de la carte</td><td>$empreinte_carte</td></tr>";
   echo "<tr><td>Garantie par 3D Secure</td><td>$garantie_3D_secure</td></tr>";
   echo "<tr><td>Pays du client</td><td>$pays_internaute</td></tr>";
   echo "<tr><td>N&deg;abonnement</td><td>$num_abonnement</td></tr>";
   ?>
 </table>
</body>
</html>

