<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Paiement Paybox</title>
	<link href="CSS/saisie_client_paybox.css" rel="stylesheet" type="text/css" /> 
 </head>
<?php
include 'INCLUDE/fonction_include_sprog.php';
// -----------------------------------------------------------------
// Récupération des données saisies
// -----------------------------------------------------------------
if (isset($_POST['Nom'])) $Nom = $_POST['Nom'] ; else $Nom = '' ;
if (isset($_POST['Prenom'])) $Prenom = $_POST['Prenom'] ; else $Prenom = '' ;
if (isset($_POST['Dossier'])) $Dossier = $_POST['Dossier'] ; else $Dossier = ''  ;
if (isset($_POST['Courriel'])) $Courriel = $_POST['Courriel'] ; else $Courriel = '' ;
if (isset($_POST['Montant_Total'])) $Montant_Total = $_POST['Montant_Total'] ; else $Montant_Total = '' ;
if (isset($_POST['PaieMult'])) $PaieMult = $_POST['PaieMult'] ; else $PaieMult = '' ;
$tab_echeances=array();
// -----------------------------------------------------------------
// Traitement des données saisies
// -----------------------------------------------------------------
$tab_validation_donnees=validation_donnees($Nom,$Prenom,$Dossier,$Courriel);
if (count($tab_validation_donnees) == 0)
{
 ?>
 <fieldset>
 <legend>Erreur :</legend><br/>
 <b>Un des champs saisis est erroné  ! <br /><br/>
 </fieldset>
 <?php
}
else
{
 list($Dossier,$Nom,$Prenom,$Courriel)=validation_donnees($Nom,$Prenom,$Dossier,$Courriel);

 // --- conversion du Montant_Total au format réel ---
 $Montant_Total = str_replace(",",".",$Montant_Total);
 $Montant_Total=round(floatval($Montant_Total),2);
 // --- préparation de Montant_Total_formate pour l'affichage ---
 $Montant_Total_formate=number_format($Montant_Total,2,","," ")." &euro;";
 $tab_validation_donnees['Montant_Total']=$Montant_Total_formate;
 // ------------------------------
 // -- récupération de la date ---
 // ------------------------------
 // --- On récupère la date au format ISO-8601 : 2015-04-03T15:27:18+02:00 ---
 date_default_timezone_set('Europe/Paris');
 $DateTime = date("c");

 // ----------------------------------------------------------------------
 // -- Calcul des montants selon le paiement immédiat ou en 3 fois ---
 // ----------------------------------------------------------------------
 if ($PaieMult == "non") // --- paiement immédiat ---
 {
  // --- Préfixe de la référence pour différencier les modes de paiement ---
  // --- au comptant : CPT
  // --- en plusieurs fois : ABT ---
  $Mode_Paiement="CPT";
  // --- conversion du Montant_Total en centimes ---
  $Montant_Total_Centimes=$Montant_Total*100;
  $PARAM['paiement_immediat']=$Montant_Total_Centimes;
  $Date_Ech1 = date('d/m/y');
  $tab_echeances[0]=$Date_Ech1;
  $tab_echeances[1]=number_format($Montant_Total,2,","," ")." &euro;";
 }
 else // paiement en 3 fois
 {
  // --- Préfixe de la référence pour différencier les modes de paiement ---
  // --- au comptant : CPT
  // --- en plusieurs fois : ABT ---
  $Mode_Paiement="ABT";
  // --- Chaque paiement est correspond à 33,33% du total ---
  $Montant_Ech1=round((($Montant_Total*33.33)/100),2);
  $Montant_Ech2=round((($Montant_Total*33.33)/100),2);
  $Montant_Ech3=round($Montant_Total-$Montant_Ech1-$Montant_Ech2,2);
  // --- conversion des Montants en centimes ---
  $Montant_Ech1_centimes=$Montant_Ech1*100;
  $Montant_Ech2_centimes=$Montant_Ech2*100;
  $Montant_Ech3_centimes=$Montant_Ech3*100;
  // --- Mise à jour du tableau des paramètres ---
  $PARAM['paiement_immediat']=$Montant_Ech1_centimes;
  $PARAM['paiement_echeance2']=$Montant_Ech2_centimes;
  $PARAM['paiement_echeance3']=$Montant_Ech3_centimes;
  // ---Calcul des dates de règlement ---
  // Echéance 1 : immédiatement
  // Echéance 2 : Echéance 1 + 1 mois
  // Echéance 3 : Echéance 1 + 2 mois
  $Date_Ech1 = date('d/m/Y'); 
  $Date_Ech2 = date('d/m/Y', strtotime('+1 month')); 
  $Date_Ech3 = date('d/m/Y', strtotime('+2 month')); 
  // --- Mise à jour du tableau des paramètres ---
  $PARAM['date_echeance2']=$Date_Ech2;
  $PARAM['date_echeance3']=$Date_Ech3;
  // --- préparation des montants pour affichage ---
  $tab_echeances[0]=$Date_Ech1;
  $tab_echeances[1]=number_format($Montant_Ech1,2,","," ")." &euro;";
  $tab_echeances[2]=$Date_Ech2;
  $tab_echeances[3]=number_format($Montant_Ech2,2,","," ")." &euro;";
  $tab_echeances[4]=$Date_Ech3;
  $tab_echeances[5]=number_format($Montant_Ech3,2,","," ")." &euro;";
 }
 // -----------------------------------
 // -- Affichage du dossier complet ---
 // -----------------------------------
 $tab_dossier=array(
       'Dossier'=>$Dossier,
       'Nom'=>$Nom,
       'Prenom'=>$Prenom,
       'Courriel'=>$Courriel,
       'Montant_Total'=>$Montant_Total_formate
       );
 affichage_dossier("Dossier à régler",$tab_dossier);
 echo WEB_EOL;
 // -----------------------------------
 // -- Affichage des échéances ---
 // -----------------------------------
 affichage_echeances("Ech&eacute;ances",$tab_echeances);
 echo WEB_EOL;
 
 // --------------------------------------------------------------------------
 // --- les paramètres sont a modifiuer dans le fichier include ci-dessous ---
 include 'INCLUDE/paybox_param_boutique.php';
 // --------------------------------------------------------------------------
 // --- voici une copie de ce qu'il contient ---
 /*
 // -----------------------------------------
 // -- Tableau des paramètres pour Paybox ---
 // -----------------------------------------
 // --- URL des serveurs Paybox System classique ---
 $PARAM['URL_SERVEUR_PREPROD']       = "https://preprod-tpeweb.paybox.com/cgi/MYchoix_pagepaiement.cgi";
 $PARAM['URL_SERVEUR_PROD_PRINCIPAL']= "https://tpeweb.paybox.com/cgi/MYchoix_pagepaiement.cgi"        ;
 $PARAM['URL_SERVEUR_PROD_SECOURS']  = "https://tpeweb1.paybox.com/cgi/MYchoix_pagepaiement.cgi"       ;
 // --- serveur utilisé pour ce programme ---
 $PARAM['URL_SERVEUR_UTILISE']       = $PARAM['URL_SERVEUR_PREPROD'] ;
 // --- Paramètres de la boutique Paybox System classique ---
 // --- ici celle de test mutualisée fournie par PAYBOX ---
 // --- pour activer (désactiver) cette boutique ---
 // --- décommenter(commenter) les 3 lignes pour SITE, RANG et IDENTIFIANT ---
 $PARAM['SITE']="1999888";
 $PARAM['RANG']="32";
 $PARAM['IDENTIFIANT']="110647233";
 // --- Pour information : accès Backoffice Paybox System classique :
 // URL : https://preprod-admin.paybox.com
 // LOGIN : 199988832
 // Mot_de_Passe : 1999888I
 // --- Paramètres de la boutique Paybox System 3D-Secure ---
 // --- ici celle de test mutualisée fournie par PAYBOX ---
 // --- pour activer (désactiver) cette boutique ---
 // --- décommenter(commenter) les 3 lignes pour SITE, RANG et IDENTIFIANT ---
 //$PARAM['SITE']="1999888";
 //$PARAM['RANG']="43";
 //$PARAM['IDENTIFIANT']="107975626";
 // --- accès Backoffice Paybox System 3D-Secure :
 // URL : https://preprod-admin.paybox.com
 // LOGIN : 199988843
 // Mot_de_Passe : 1999888I
 // --- Code de la devise suivant la norme ISO 4217 : ---
 // ---    euro: 978 ---
 // ---    dollar américain: 840 ---
 // ---    Franc CFA BCEAO: 952 ---
 // ---    Franc CFA BEAC: 950 ---
 // ---    Franc suisse: 756 ---
 // ---    Livre Sterling: 826 ---
 $PARAM['PBX_DEVISE']="978";
 // --- Référence unique du dossier ---
 // --- de la forme CPT_052426_DUPONT_PAUL_2015-04-03T15:27:18+02:00
 $PARAM['ref']=$Mode_Paiement."_".$Dossier."_".$Nom."_".$Prenom."_".$DateTime;
 // --- Adresse email du client qui recevra le reçu de la carte visa ---
 $PARAM['email']=$Courriel;
 // --- Liste des informations retournée par Paybox ---
 // E = Code d'erreur
 // M = Montant de la transaction
 // R = Référence de la transaction
 // A = Code de l'autorisation
 // T = Numéro d'appel Paybox
 // S = Numéro de transaction
 // Q = Heure de transaction
 // W = Date de transaction
 // D = Date fin de validité de la carte
 // N = 6 premiers chiffres du numéro de la carte
 // J = 2 derniers chiffres du numéro de la carte
 // C = type de carte
 // H = empreinte de la carte
 // I = Pays de l'internaute
 // Y = Pays de la banque émettrice de la carte
 // G = Garantie 3D Secure
 // P = Type de paiement
 // B = Numéro d'abonnement
 $PARAM['RETOUR']="erreur:E;mtant:M;ref:R;auto:A;appel:T;ntrans:S;htrans:Q;dtrans:W;dfin:D;ndcarte:N;nfcarte:J;tcarte:C;epcarte:H;paysi:I;paysc:Y;gar:G;tpt:P;nab:B";
 // --- Algorithme de codage ---
 $PARAM['ALG_CRYP']="SHA512";
 // -----------------------------------------------------
 // --- URL de retour pour traitement des données :   ---
 // --- celle de votre serveur qui traitera les informations ---
 // --- retournées par PAYBOX ---
 $PARAM['URL_RETOUR_UNIQUE']     = "http://serveur_de_retour.domain.fr/CoursPHP/12_Complements/12_7_Paiement_en_Ligne_Paybox/traitement_retour_paybox.php";
 // --- URL de retour via le navigateur du client --
 $PARAM['URL_RETOUR_EFFECTUE']   = $PARAM['URL_RETOUR_UNIQUE'];
 $PARAM['URL_RETOUR_REFUSE']     = $PARAM['URL_RETOUR_UNIQUE'];
 $PARAM['URL_RETOUR_ANNULE']     = $PARAM['URL_RETOUR_UNIQUE'];
 $PARAM['URL_RETOUR_ATTENTE']    = $PARAM['URL_RETOUR_UNIQUE'];
 // --- URL de retour DIRECT de serveur à serveur (url IPN)
 // --- donc sans passer par le navigateur du client --
 $PARAM['URL_RETOUR_REPONDRE_A'] = $PARAM['URL_RETOUR_UNIQUE'];
 // --- Méthode de retour GET ou POST --
 $PARAM['METHODE_RETOUR'] = "POST";
 */
 // --- fin des paramètres ---
 
 // -- Préparation calcul de la clef privée (empreinte du message) ---
 // .........................................................  
 // -1- On crée la chaîne à hacher sans URL : encodage ---
 // .........................................................  
 // l’ordre des variables doit être identique a celui du formulaire
 // La chaîne est de la forme (sans aucun espace): 
 // PBX_SITE=1999888&PBX_RANG=32&PBX_IDENTIFIANT=110647233&PBX_TOTAL=1000&...
 $param_obl = "PBX_SITE=".$PARAM['SITE'].
 "&PBX_RANG=".$PARAM['RANG'].
 "&PBX_IDENTIFIANT=".$PARAM['IDENTIFIANT'].
 "&PBX_TOTAL=".$PARAM['paiement_immediat'].
 "&PBX_DEVISE=".$PARAM['PBX_DEVISE'].
 "&PBX_CMD=".$PARAM['ref'].
 "&PBX_PORTEUR=".$PARAM['email'].
 "&PBX_RETOUR=".$PARAM['RETOUR'].
 "&PBX_HASH=".$PARAM['ALG_CRYP'].
 "&PBX_TIME=".$DateTime;
 
 if ($PaieMult == "oui")
 {
  $param_echeances="&PBX_2MONT1=".$PARAM['paiement_echeance2'].
  "&PBX_DATE1=".$PARAM['date_echeance2'].
  "&PBX_2MONT2=".$PARAM['paiement_echeance3'].
  "&PBX_DATE2=".$PARAM['date_echeance3'];
 }
 
 // --- dans le cas d'un retour via le navigateur de l'acheteur ---
 // --- il faut utiliser ces trois paramètres : ---
 // --- PBX_EFFECTUE, PBX_REFUSE et PBX_ANNULE
 $param_retour="&PBX_EFFECTUE=".$PARAM['URL_RETOUR_EFFECTUE'].
 "&PBX_REFUSE=".$PARAM['URL_RETOUR_REFUSE'].
 "&PBX_ANNULE=".$PARAM['URL_RETOUR_ANNULE'];
 
 // --- dans le cas d'un retour DIRECT de serveur à serveur (url IPN) ---
 // --- donc sans passer par le navigateur du client --
 // --- il faut utiliser ces deux paramètres à la place des ---
 // --- trois paramètres : PBX_EFFECTUE, PBX_REFUSE et PBX_ANNULE
 //$param_retour="&PBX_REPONDRE_A=".$PARAM['URL_RETOUR_REPONDRE_A'].
 //"&PBX_RUF1=".$PARAM['METHODE_RETOUR'];

 // --- construction finale de la chaine $param pour laquelle il faut générer une empreinte --- 
 if ($PaieMult == "oui") // --- paiement en 3 fois ---
 {
  $param=$param_obl.$param_echeances.$param_retour;
 }
 else // --- paiement immédiat ---
 {
  $param=$param_obl.$param_retour;
 }
  
 // ..................................................................  
 // -2- Génération de l'empreinte (clef privée) de la chaine $param ---
 // ..................................................................  
 // --- On récupère la clé secrète HMAC
 // --- (peut aussi être stockée dans une base de données par exemple)
 // --- que l’on renseigne dans la variable $keyTest = c'est la clef publique de Paybox;
 // --- Si la clé est en ASCII, On la transforme en binaire
 $keyTest="0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF";
 $binKey = pack("H*", $keyTest);
 // --- On calcule l’empreinte (à renseigner dans le paramètre PBX_HMAC) 
 // --- grâce à la fonction hash_hmac et la clé binaire
 // --- On envoie via la variable PBX_HASH l'algorithme de hachage
 // --- qui a été utilisé (SHA512 dans ce cas)
 // --- Pour afficher la liste des algorithmes disponibles sur votre environnement,
 // --- décommentez la ligne suivante
 // print_r(hash_algos());
 // ......................................................  
 $algo_cryptage=strtolower($PARAM['ALG_CRYP']);
 $empreinte_carte = strtoupper(hash_hmac($algo_cryptage, $param, $binKey));
 
 // ......................................................  
 // --- La chaîne sera envoyée en majuscules, d'où l'utilisation de strtoupper()
 // --- On crée le formulaire à envoyer à Paybox System
 // --- ATTENTION : l'ordre des champs est extrêmement important, il doit
 // --- être exactement identique à celui de la chaîne hachée : $param
 // ----------------------------------------------
 // -- Formulaire d'envoi des données à Paybox ---
 // ----------------------------------------------
 ?>
 <form method="POST" action="<?php echo $PARAM['URL_SERVEUR_UTILISE']; ?>">
 <!-- param_obl -->
 <input type="hidden" name="PBX_SITE" value="<?php echo $PARAM['SITE']; ?>">
 <input type="hidden" name="PBX_RANG" value="<?php echo $PARAM['RANG']; ?>">
 <input type="hidden" name="PBX_IDENTIFIANT" value="<?php echo $PARAM['IDENTIFIANT']; ?>">
 <input type="hidden" name="PBX_TOTAL" value="<?php echo $PARAM['paiement_immediat']; ?>">
 <input type="hidden" name="PBX_DEVISE" value="<?php echo $PARAM['PBX_DEVISE']; ?>">
 <input type="hidden" name="PBX_CMD" value="<?php echo $PARAM['ref']; ?>">
 <input type="hidden" name="PBX_PORTEUR" value="<?php echo $PARAM['email']; ?>">
 <input type="hidden" name="PBX_RETOUR" value="<?php echo $PARAM['RETOUR']; ?>">
 <input type="hidden" name="PBX_HASH" value="<?php echo $PARAM['ALG_CRYP']; ?>">
 <input type="hidden" name="PBX_HMAC" value="<?php echo $empreinte_carte; ?>">
 <input type="hidden" name="PBX_TIME" value="<?php echo $DateTime; ?>">
 <?php
 // --- traitement des échéances multiples ---
 if ($PaieMult == "oui")
 {
 ?>
 <!-- param_echeances -->
 <input type="hidden" name="PBX_2MONT1" value="<?php echo $PARAM['paiement_echeance2']; ?>">
 <input type="hidden" name="PBX_DATE1" value="<?php echo $PARAM['date_echeance2']; ?>">
 <input type="hidden" name="PBX_2MONT2" value="<?php echo $PARAM['paiement_echeance3']; ?>">
 <input type="hidden" name="PBX_DATE2" value="<?php echo $PARAM['date_echeance3']; ?>">
 <?php
 }
 ?>
 <!-- URL de retour par navigateur-->
 <input type="hidden" name="PBX_EFFECTUE" value="<?php echo $PARAM['URL_RETOUR_EFFECTUE']; ?>">
 <input type="hidden" name="PBX_REFUSE" value="<?php echo $PARAM['URL_RETOUR_REFUSE']; ?>">
 <input type="hidden" name="PBX_ANNULE" value="<?php echo $PARAM['URL_RETOUR_ANNULE']; ?>">
 <!-- URL de retour DIRECT de serveur à serveur : url IPN -->
 <!--
 <input type="hidden" name="PBX_REPONDRE_A" value="<?php echo $PARAM['URL_RETOUR_REPONDRE_A']; ?>">
 <input type="hidden" name="PBX_RUF1" value="<?php echo $PARAM['METHODE_RETOUR']; ?>">
 -->
 <!-- Bouton Payer -->
 <input type="submit" value="Payer">
 <?php
}
?>
</form>
 </body>
</html>
