<?php
define("MAXDOSSIER","10000000");
define("WEB_EOL","<br/>");
// ==========================================
// --- fonction de validation des données ---
// ===========================================
function validation_donnees($Nom,$Prenom,$Dossier,$Courriel)
{
 // --- Protection de l'injection HTML ---
 $Nom     = strip_tags($Nom)     ;
 $Prenom  = strip_tags($Prenom)  ;
 $Dossier = strip_tags($Dossier) ;
 $Courriel= strip_tags($Courriel);
 // ---------------------------------------
 // on vérifie qu'il n'y a aucun champ vide
 // ---------------------------------------
 if (!empty($Dossier) && !empty($Nom) && !empty($Prenom) && !empty($Courriel))
 {
  // ---------------------------------------
  // on vérifie la validité des chaque champ
  // ---------------------------------------
  $retourValidationDossier   = true ;
  $retourValidationCourriel  = true ;
  $retourValidationNom       = true ;
  $retourValidationPrenom    = true ;
  if (!empty($Nom))
  {
   $Nom=normalisation_nom($Nom)     ;
   $retourValidationNom=!empty($Nom);
   if ($retourValidationNom)
   {
    $Nom  = $Nom ;
   }
  }
  if (!empty($Prenom))
  {
   $Prenom=normalisation_nom($Prenom) ;
   $retourValidationPrenom=!empty($Prenom);
   if ($retourValidationPrenom) 
   {
    $Prenom  = $Prenom ;
   }
  }
  if (!empty($Dossier))
  {
   $Dossier=normalisation_numerique($Dossier)           ;
   $retourValidationDossier=validation_Dossier($Dossier);
   if ($retourValidationDossier)
   {
    $Dossier  = intval($Dossier)     ;
    $Dossier=sprintf("%06d",$Dossier);
   }
  }
  if (!empty($Courriel))
  {
   $retourValidationCourriel=validation_Courriel($Courriel);
  }
  // -------------------------------
  // si tous les champs sont valides
  // -------------------------------
  if (($retourValidationDossier) && ($retourValidationCourriel) && ($retourValidationNom) && ($retourValidationPrenom) )
  {
   $tab_retour=array($Dossier,$Nom,$Prenom,$Courriel);
  }
  else
  {
   $tab_retour=array();
  }
 }
 else
 {
   $tab_retour=array($Nom,$Prenom,$Dossier,$Courriel);
 }
 return $tab_retour;
}
// =================================================
// --- fonction outil de suppression des accents ---
// =================================================
function supprime_accent($chaine)
{
  // tableau des caractères accentués à remplacer
  $caracteres_a_remplacer     = array('À', 'Á', 'Â', 'Ã', 'Ä', 'Å', 'Æ', 'Ç', 'È', 'É', 'Ê', 'Ë', 'Ì', 'Í', 'Î', 'Ï', 'Ð', 'Ñ', 'Ò', 'Ó', 'Ô', 'Õ', 'Ö', 'Ø', 'Ù', 'Ú', 'Û', 'Ü', 'Ý', 'ß', 'à', 'á', 'â', 'ã', 'ä', 'å', 'æ', 'ç', 'è', 'é', 'ê', 'ë', 'ì', 'í', 'î', 'ï', 'ñ', 'ò', 'ó', 'ô', 'õ', 'ö', 'ø', 'ù', 'ú', 'û', 'ü', 'ý', 'ÿ', 'Ā', 'ā', 'Ă', 'ă', 'Ą', 'ą', 'Ć', 'ć', 'Ĉ', 'ĉ', 'Ċ', 'ċ', 'Č', 'č', 'Ď', 'ď', 'Đ', 'đ', 'Ē', 'ē', 'Ĕ', 'ĕ', 'Ė', 'ė', 'Ę', 'ę', 'Ě', 'ě', 'Ĝ', 'ĝ', 'Ğ', 'ğ', 'Ġ', 'ġ', 'Ģ', 'ģ', 'Ĥ', 'ĥ', 'Ħ', 'ħ', 'Ĩ', 'ĩ', 'Ī', 'ī', 'Ĭ', 'ĭ', 'Į', 'į', 'İ', 'ı', 'Ĳ', 'ĳ', 'Ĵ', 'ĵ', 'Ķ', 'ķ', 'Ĺ', 'ĺ', 'Ļ', 'ļ', 'Ľ', 'ľ', 'Ŀ', 'ŀ', 'Ł', 'ł', 'Ń', 'ń', 'Ņ', 'ņ', 'Ň', 'ň', 'ŉ', 'Ō', 'ō', 'Ŏ', 'ŏ', 'Ő', 'ő', 'Œ', 'œ', 'Ŕ', 'ŕ', 'Ŗ', 'ŗ', 'Ř', 'ř', 'Ś', 'ś', 'Ŝ', 'ŝ', 'Ş', 'ş', 'Š', 'š', 'Ţ', 'ţ', 'Ť', 'ť', 'Ŧ', 'ŧ', 'Ũ', 'ũ', 'Ū', 'ū', 'Ŭ', 'ŭ', 'Ů', 'ů', 'Ű', 'ű', 'Ų', 'ų', 'Ŵ', 'ŵ', 'Ŷ', 'ŷ', 'Ÿ', 'Ź', 'ź', 'Ż', 'ż', 'Ž', 'ž', 'ſ', 'ƒ', 'Ơ', 'ơ', 'Ư', 'ư', 'Ǎ', 'ǎ', 'Ǐ', 'ǐ', 'Ǒ', 'ǒ', 'Ǔ', 'ǔ', 'Ǖ', 'ǖ', 'Ǘ', 'ǘ', 'Ǚ', 'ǚ', 'Ǜ', 'ǜ', 'Ǻ', 'ǻ', 'Ǽ', 'ǽ', 'Ǿ', 'ǿ');
  // tableau des caractères sans accent de remplacement
  $caracteres_de_remplacement = array('A', 'A', 'A', 'A', 'A', 'A', 'AE', 'C', 'E', 'E', 'E', 'E', 'I', 'I', 'I', 'I', 'D', 'N', 'O', 'O', 'O', 'O', 'O', 'O', 'U', 'U', 'U', 'U', 'Y', 's', 'a', 'a', 'a', 'a', 'a', 'a', 'ae', 'c', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'n', 'o', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'y', 'y', 'A', 'a', 'A', 'a', 'A', 'a', 'C', 'c', 'C', 'c', 'C', 'c', 'C', 'c', 'D', 'd', 'D', 'd', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'G', 'g', 'G', 'g', 'G', 'g', 'G', 'g', 'H', 'h', 'H', 'h', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'IJ', 'ij', 'J', 'j', 'K', 'k', 'L', 'l', 'L', 'l', 'L', 'l', 'L', 'l', 'l', 'l', 'N', 'n', 'N', 'n', 'N', 'n', 'n', 'O', 'o', 'O', 'o', 'O', 'o', 'OE', 'oe', 'R', 'r', 'R', 'r', 'R', 'r', 'S', 's', 'S', 's', 'S', 's', 'S', 's', 'T', 't', 'T', 't', 'T', 't', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'W', 'w', 'Y', 'y', 'Y', 'Z', 'z', 'Z', 'z', 'Z', 'z', 's', 'f', 'O', 'o', 'U', 'u', 'A', 'a', 'I', 'i', 'O', 'o', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'A', 'a', 'AE', 'ae', 'O', 'o');
  // retour de la fonction
  return str_replace($caracteres_a_remplacer, $caracteres_de_remplacement, $chaine);
}
// =================================================
// --- fonction outil de normalisation des noms  ---
// =================================================
function normalisation_nom($chaine)
{
 // tableau des motifs de recherche
 $tab_motif=array('/[^a-zA-Z -]/', '/[ -]+/', '/^-|-$/');
 // tableau des caract&egrave;res de remplacement
 $tab_remplacement=array('', '-', '')     ;
 // chaine de caract&egrave;res sur laquelle s'effectue le remplacement
 $chaine_contexte=supprime_accent($chaine);
 // retour de la fonction
 return strtoupper(preg_replace($tab_motif,$tab_remplacement, $chaine_contexte));
}
// =================================================
// --- fonction outil de normalisation des numériques  ---
// =================================================
function normalisation_numerique($numero)
{
 // tableau des motifs de recherche
 $tab_motif=array('/[^0-9,.]/')  ;
 // tableau des caract&egrave;res de remplacement
 $tab_remplacement=array('')     ;
 // retour de la fonction
 $numero_retour=intval(preg_replace($tab_motif,$tab_remplacement, $numero));
 return $numero_retour;
}
// ==============================
// --- Validation du champ Dossier ---
// ==============================
function validation_Dossier($Dossier)
{
 $erreur=false;
 if (($Dossier == 0) || (!(($Dossier >0)&&($Dossier <MAXDOSSIER))))
 {
  $erreur=true;
 }
 return !$erreur;
}
// ====================================
// --- Validation du champ Courriel ---
// ====================================
function validation_Courriel($Courriel)
{
  $resultat=filter_var($Courriel,FILTER_VALIDATE_EMAIL);
  if (empty($resultat)) $resultat=false; else $resultat=true;
  return $resultat;
}
// ================================================
// --- fonction outil d'affichage d'un dossier  ---
// ================================================
function affichage_dossier($titre,$tab_dossier)
{
 // entête de l'affichage
  ?>
  <table summary="Dossier">
   <caption><?php echo $titre;?></caption>
   <thead>
    <tr>
    <!-- entête du tableau -->
     <th>Dossier</th>
     <th>Nom</th>
     <th>Pr&eacute;nom</th>
     <th>Courriel</th>
     <th>Montant Total</th>
    </tr>
   </thead>
 <?php
 if (count($tab_dossier) ==0)
 {
   echo "<td colspan=\"5\"><b>Aucune donn&eacute;e &agrave; afficher</b></td>";
 }
 else
 {
   // importation des variables à partir de l'étiquette des champs
   extract($tab_dossier,EXTR_OVERWRITE);
   echo "<tr>";
   echo "<td>$Dossier</td><td>$Nom</td><td>$Prenom</td><td>$Courriel</td><td>$Montant_Total</td>";
   echo "</tr>";
 }
 ?></table><?php
}
// ==================================================
// --- fonction outil d'affichage des échéances  ---
// ==================================================
function affichage_echeances($titre,$tab_echeances)
{
 // entête de l'affichage
  ?>
  <table summary="Ech&eacute;ances">
   <caption><?php echo $titre;?></caption>
   <thead>
    <tr>
    <!-- entête du tableau -->
     <th>Date</th>
     <th>Montant</th>
    </tr>
   </thead>
 <?php
 $Nb_Echeances=count($tab_echeances);
 if ($Nb_Echeances == 0)
 {
   echo "<td colspan=\"2\"><b>Aucune donn&eacute;e &agrave; afficher</b></td>";
 }
 else
 {
   for ($i=0; $i<$Nb_Echeances;$i+=2)
   {
     $date=$tab_echeances[$i];
     $montant=$tab_echeances[$i+1]; 
     echo "<tr><td>$date</td><td>$montant</td></tr>";
   }
 }
 ?></table><?php
}
// ======================================================
// --- fonction outil chargement des codes d'erreurs  ---
// ======================================================
function chargement_codes_erreurs()
{
  $Tab_Erreurs=array();
  $NomFichier="FICHIERS/Liste_Codes_Erreurs.txt";
  $f1 = @fopen($NomFichier, "rt");
  if (! $f1) // --- erreur d'ouverture ---
  { // -- on affiche les messages d'erreur ---
   $tab_erreurs      = error_get_last()       ;
   $erreur_type      = $tab_erreurs['type']   ;
   $erreur_message   = $tab_erreurs['message'];
   $erreur_programme = $tab_erreurs['file']   ;
   $erreur_ligne     = $tab_erreurs['line']   ;
   ?>
   <fieldset>
   <legend>Erreur :</legend><br/>
   <b>Chargement impossible :</b> erreur d'ouverture du fichier <b><?php echo $NomFichier; ?></b> en lecture  ! <br /><br/>
   <b>Type de l'erreur :</b> <?php echo $erreur_type ; ?><br />
   <b>Message :</b> <?php echo $erreur_message; ?><br />
   <b>Répertoire de Chargement :</b> <?php echo $repertoire_courant."/".$repertoire_chargement; ?><br /><br />
   <b>Programme PHP :</b> <?php echo $erreur_programme; ?><br />
   <b>A la ligne :</b> <?php echo $erreur_ligne; ?><br />
   </fieldset>
   <?php
  }
  else // -- on charge les données dans le tableau, et on les affiche ---
  {
    while ($Tab_Lecture=fscanf($f1,"%s\t%s"))
    {
     list ($code_erreur,$libelle_erreur) = $Tab_Lecture;
     $libelle_erreur=str_replace("_"," ",$libelle_erreur);
     if (strlen($code_erreur) == 5)
     {
       $Tab_Erreurs[$code_erreur]=$libelle_erreur;
     }
    }
  }
  return $Tab_Erreurs;
}
// =========================================================
// --- fonction outil chargement des codes ISO des pays  ---
// =========================================================
function chargement_codes_pays()
{
  $Tab_Erreurs=array();
  $NomFichier="FICHIERS/Liste_Pays_ISO.txt";
  $f1 = @fopen($NomFichier, "rt");
  if (! $f1) // --- erreur d'ouverture ---
  { // -- on affiche les messages d'erreur ---
   $tab_erreurs=error_get_last();
   $erreur_type      = $tab_erreurs['type']   ;
   $erreur_message   = $tab_erreurs['message'];
   $erreur_programme = $tab_erreurs['file']   ;
   $erreur_ligne     = $tab_erreurs['line']   ;
   ?>
   <fieldset>
   <legend>Erreur :</legend><br/>
   <b>Chargement impossible :</b> erreur d'ouverture du fichier <b><?php echo $NomFichier; ?></b> en lecture  ! <br /><br/>
   <b>Type de l'erreur :</b> <?php echo $erreur_type ; ?><br />
   <b>Message :</b> <?php echo $erreur_message; ?><br />
   <b>Répertoire de Chargement :</b> <?php echo $repertoire_courant."/".$repertoire_chargement; ?><br /><br />
   <b>Programme PHP :</b> <?php echo $erreur_programme; ?><br />
   <b>A la ligne :</b> <?php echo $erreur_ligne; ?><br />
   </fieldset>
   <?php
  }
  else // -- on charge les données dans le tableau, et on les affiche ---
  {
    while ($Tab_Lecture=fscanf($f1,"%s\t%s\t%s"))
    {
     list ($code_pays,$libelle_minuscules,$libelle_majuscules) = $Tab_Lecture;
     $libelle_minuscules=str_replace("_"," ",$libelle_minuscules);
     $libelle_majuscules=str_replace("_"," ",$libelle_majuscules);
     if (strlen($code_pays) == 3)
     {
       $Tab_Pays[$code_pays]['MIN']=$libelle_minuscules;
       $Tab_Pays[$code_pays]['MAJ']=$libelle_majuscules;
     }
    }
  }
  return $Tab_Pays;
}
?>

