<?php
require('fpdf_ex17_sector_sprog.php');

class PDF_Diag extends PDF_Sector {
	var $legends;
	var $wLegend;
	var $sum;
	var $NbVal;

	function SetLegends($data, $format)
	{
		$this->legends=array();
		$this->wLegend=0;
		$this->sum=array_sum($data);
		$this->NbVal=count($data);
		foreach($data as $l=>$val)
		{
			$p=sprintf('%.2f',$val/$this->sum*100).'%';
			$legend=str_replace(array('%l','%v','%p'),array($l,$val,$p),$format);
			$this->legends[]=$legend;
			$this->wLegend=max($this->GetStringWidth($legend),$this->wLegend);
		}
	}

	function DiagCirculaire($largeur, $hauteur, $data, $format, $couleurs=null)
	{
		$this->SetFont('Courier', '', 10);
		$this->SetLegends($data,$format);

		$XPage = $this->GetX();
		$YPage = $this->GetY();
		$marge = 2;
		$hLegende = 5;
		$rayon = min($largeur - $marge * 4 - $hLegende - $this->wLegend, $hauteur - $marge * 2);
		$rayon = floor($rayon / 2);
		$XDiag = $XPage + $marge + $rayon;
		$YDiag = $YPage + $marge + $rayon;
		if($couleurs == null) {
			for($i = 0; $i < $this->NbVal; $i++) {
				$gray = $i * intval(255 / $this->NbVal);
				$couleurs[$i] = array($gray,$gray,$gray);
			}
		}

		//Secteurs
		$this->SetLineWidth(0.2);
		$angleDebut = 0;
		$angleFin = 0;
		$i = 0;
		foreach($data as $val) {
			$angle = ($val * 360) / doubleval($this->sum);
			if ($angle != 0) {
				$angleFin = $angleDebut + $angle;
				$this->SetFillColor($couleurs[$i][0],$couleurs[$i][1],$couleurs[$i][2]);
				$this->Sector($XDiag, $YDiag, $rayon, $angleDebut, $angleFin);
				$angleDebut += $angle;
			}
			$i++;
		}

		//Lgendes
		$this->SetFont('Courier', '', 10);
		$x1 = $XPage + 2 * $rayon + 4 * $marge;
		$x2 = $x1 + $hLegende + $marge;
		$y1 = $YDiag - $rayon + (2 * $rayon - $this->NbVal*($hLegende + $marge)) / 2;
		for($i=0; $i<$this->NbVal; $i++) {
			$this->SetFillColor($couleurs[$i][0],$couleurs[$i][1],$couleurs[$i][2]);
			$this->Rect($x1, $y1, $hLegende, $hLegende, 'DF');
			$this->SetXY($x2,$y1);
			$this->Cell(0,$hLegende,$this->legends[$i]);
			$y1+=$hLegende + $marge;
		}
	}

	function DiagBatons($largeur, $hauteur, $data, $format, $couleur=null, $maxValRepere=0, $nbIndRepere=4)
	{
		$this->SetFont('Courier', '', 10);
		$this->SetLegends($data,$format);

		$XPage = $this->GetX();
		$YPage = $this->GetY();
		$marge = 2;
		$YDiag = $YPage + $marge;
		$hDiag = floor($hauteur - $marge * 2);
		$XDiag = $XPage + $marge * 2 + $this->wLegend;
		$lDiag = floor($largeur - $marge * 3 - $this->wLegend);
		if($couleur == null)
			$couleur=array(155,155,155);
		if ($maxValRepere == 0) {
			$maxValRepere = max($data);
		}
		$valIndRepere = ceil($maxValRepere / $nbIndRepere);
		$maxValRepere = $valIndRepere * $nbIndRepere;
		$lRepere = floor($lDiag / $nbIndRepere);
		$lDiag = $lRepere * $nbIndRepere;
		$unite = $lDiag / $maxValRepere;
		$hBaton = floor($hDiag / ($this->NbVal + 1));
		$hDiag = $hBaton * ($this->NbVal + 1);
		$eBaton = floor($hBaton * 80 / 100);

		$this->SetLineWidth(0.2);
		$this->Rect($XDiag, $YDiag, $lDiag, $hDiag);

		$this->SetFont('Courier', '', 10);
		$this->SetFillColor($couleur[0],$couleur[1],$couleur[2]);
		$i=0;
		foreach($data as $val) {
			//Barre
			$xval = $XDiag;
			$lval = (int)($val * $unite);
			$yval = $YDiag + ($i + 1) * $hBaton - $eBaton / 2;
			$hval = $eBaton;
			$this->Rect($xval, $yval, $lval, $hval, 'DF');
			//Lgende
			$this->SetXY(0, $yval);
			$this->Cell($xval - $marge, $hval, $this->legends[$i],0,0,'R');
			$i++;
		}

		//Echelles
		for ($i = 0; $i <= $nbIndRepere; $i++) {
			$xpos = $XDiag + $lRepere * $i;
			$this->Line($xpos, $YDiag, $xpos, $YDiag + $hDiag);
			$val = $i * $valIndRepere;
			$xpos = $XDiag + $lRepere * $i - $this->GetStringWidth($val) / 2;
			$ypos = $YDiag + $hDiag - $marge;
			$this->Text($xpos, $ypos, $val);
		}
	}
}
?>
