<?php
require('fpdf_ex17_diagrammes_sprog.php');

$pdf = new PDF_Diag();
$pdf->AddPage();

$data = array("Hommes" => 1510, "Femmes" => 1610, "Enfants" => 1400);

//Diagramme circulaire
$pdf->SetFont('Arial', 'BIU', 12);
$pdf->Cell(0, 5, "1 - Diagramme circulaire", 0, 2, 'L');
$pdf->Ln(8);

$pdf->SetFont('Arial', '', 10);
$valX = $pdf->GetX();
$valY = $pdf->GetY();
$pdf->Cell(35, 5, "Nombre d'hommes :");
$pdf->Cell(15, 5, $data["Hommes"], 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(35, 5, "Nombre de femmes :");
$pdf->Cell(15, 5, $data["Femmes"], 0, 0, 'R');
$pdf->Ln();
$pdf->Cell(35, 5, "Nombre d'enfants :");
$pdf->Cell(15, 5, $data["Enfants"], 0, 0, 'R');
$pdf->Ln();
$pdf->Ln(8);

$pdf->SetXY(90, $valY);
$col1=array(100,100,255);
$col2=array(255,100,100);
$col3=array(255,255,100);
$pdf->DiagCirculaire(100, 35, $data, '%l (%p)', array($col1,$col2,$col3));
$pdf->SetXY($valX, $valY + 40);

//Diagramme bâtons
$pdf->SetFont('Arial', 'BIU', 12);
$pdf->Cell(0, 5, utf8_decode("2 - Diagramme en bâtons"), 0, 2, 'L');
$pdf->Ln(8);
$valX = $pdf->GetX();
$valY = $pdf->GetY();
$pdf->DiagBatons(190, 70, $data, '%l : %v (%p)', array(255,175,100));
$pdf->SetXY($valX, $valY + 80);

// --- Envoie le document au navigateur (I) ---
// --- en cas de téléchargement, le nom du fichier ---
// --- est  diagrammes.pdf ---
//$pdf->Output();
$pdf->Output('diagrammes.pdf','I');
?>
