<?php
require('../INCLUDE/fpdf181/fpdf.php');

class PDF extends FPDF
{
 var $col=0;
 function SetCol($col)
 {
	//Positionnement en haut d'une colonne
	$this->col=$col;
	$this->SetLeftMargin(10+$col*40);
	$this->SetY(25);
 }
 function AcceptPageBreak()
 {
	//Va  la colonne suivante
	$this->SetCol($this->col+1);
	return false;
 }
 function DumpFont($FontName)
 {
	$this->AddPage();
	//Titre
	$this->SetFont('Arial','',16);
	$this->Cell(0,6,$FontName,0,1,'C');
	//Affichage des caractres en colonnes
	$this->SetCol(0);
	for($i=32;$i<=255;$i++)
	{
		$this->SetFont('Arial','',14);
		$this->Cell(12,5.5,"$i : ");
		$this->SetFont($FontName);
		$this->Cell(0,5.5,chr($i),0,1);
	}
	$this->SetCol(0);
 }
}

$pdf=new PDF();
$pdf->DumpFont('Arial');
$pdf->DumpFont('Symbol');
$pdf->DumpFont('ZapfDingbats');
// --- Envoie le document au navigateur (I) ---
// --- en cas de tlchargement, le nom du fichier ---
// --- est  FontDump.pdf ---
//$pdf->Output();
$pdf->Output('FontDump.pdf','I');
?>
