<?php
require('../INCLUDE/fpdf181/fpdf.php');
// --- classe PDF_MySQL_Table drive de FPDF ---
// --- classe de gestion de requtes SQL en PDF ---
class PDF_MySQL_Table extends FPDF
{
 var $TraitementTable=false;
 var $LesColonnes=array();
 var $TableX;
 var $EnteteCouleur;
 var $LigneCouleurs;
 var $CouleurIndex;
 var $tab_donnees=array();
 var $nom_colonnes=array();
 // --- Affichage de l'entte du tableau ---
 function Entete()
 {
  if($this->TraitementTable)
     $this->TableEntete();
 }
 function TableEntete()
 {
  $this->SetFont('Arial','B',12);
  $this->SetX($this->TableX);
  $remplissage=!empty($this->EnteteCouleur);
  if($remplissage)
      $this->SetFillColor($this->EnteteCouleur[0],$this->EnteteCouleur[1],$this->EnteteCouleur[2]);
  foreach($this->LesColonnes as $colonne)
      $this->Cell($colonne['w'],6,$colonne['c'],1,0,'C',$remplissage);
  $this->Ln();
 }
 // --- Affichage des lignes du tableau ---
 function Ligne($donnee)
 {
  $this->SetX($this->TableX);
  $ci=$this->CouleurIndex;
  $remplissage=!empty($this->LigneCouleurs[$ci]);
  if($remplissage)
     $this->SetFillColor($this->LigneCouleurs[$ci][0],$this->LigneCouleurs[$ci][1],$this->LigneCouleurs[$ci][2]);
  foreach($this->LesColonnes as $colonne)
  {
     $this->Cell($colonne['w'],5,$donnee[$colonne['f']],1,0,$colonne['a'],$remplissage);
  }
  $this->Ln();
  $this->CouleurIndex=1-$ci;
 }

 // --- Calcule les largeurs des colonnes ---
 function CalculeLargeurs($largeur,$alignement)
 {
  $TableLargeur=0;
  foreach($this->LesColonnes as $i=>$colonne)
  {
		$w=$colonne['w'];
		if($w==-1)
			$w=$largeur/count($this->LesColonnes);
		elseif(substr($w,-1)=='%')
			$w=$w/100*$largeur;
		$this->LesColonnes[$i]['w']=$w;
		$TableLargeur+=$w;
  }
  // --- Calcule l'abscisse du tableau ---
  if($alignement=='C')
     $this->TableX=max(($this->w-$TableLargeur)/2,0);
  elseif($alignement=='R')
     $this->TableX=max($this->w-$this->rMargin-$TableLargeur,0);
  else
     $this->TableX=$this->lMargin;
 }
 // --- ajoute une colonne au tableau ---
 function AjoutColonne($nomchamp=-1,$largeur=-1,$legende='',$alignement='L')
 {
  if($nomchamp==-1)
  {
   $numchamp=count($this->LesColonnes);
   $nomchamp=$this->nom_colonnes[$numchamp];
  }
  $this->LesColonnes[]=array('f'=>$nomchamp,'c'=>$legende,'w'=>$largeur,'a'=>$alignement);
 }
 // --- cration du tableau ---
 function Table($RequeteSQL,$proprietes=array())
 {
  global $bdd;
  $reponse = $bdd->query($RequeteSQL);
  // --- traitement des erreurs de retour sur la requte ---
  if (!$reponse)
        throw new Exception('Problme de requte sur la table.');
  // ---retourne un tableau associatif ---
  $reponse->setFetchMode(PDO::FETCH_ASSOC); 
  // --- boucle de traitement de chaque personne --- 
  $this->tab_donnees=$reponse->fetchAll();
  $this->nom_colonnes=array_keys($this->tab_donnees[0]);
  // --- Ajoute toutes les colonnes si aucune n'a t dfinie ---
  if(count($this->LesColonnes)==0)
  {
   $NbColonnes=$reponse->columnCount();
   for($i=0;$i<$NbColonnes;$i++)
       $this->AjoutColonne();
  }
  // --- Dtermine les noms des colonnes si non spcifis ---
  foreach($this->LesColonnes as $i=>$colonne)
  {
   if($colonne['c']=='')
   {
    if(is_string($colonne['f']))
    {
     $this->LesColonnes[$i]['c']=ucfirst($colonne['f']);
    }
    else
    {
     $this->LesColonnes[$i]['c']=ucfirst($this->nom_colonnes[$i]);
     $this->nom_colonnes=array_keys($this->tab_donnees[0]);
    }
   }
  }
  // --- Traitement des proprits ---
  if(!isset($proprietes['largeur']))
      $proprietes['largeur']=0;
  if($proprietes['largeur']==0)
      $proprietes['largeur']=$this->w-$this->lMargin-$this->rMargin;
  if(!isset($proprietes['align']))
      $proprietes['align']='C';
  if(!isset($proprietes['decalage']))
      $proprietes['decalage']=$this->cMargin;
  $cMargin=$this->cMargin;
  $this->cMargin=$proprietes['decalage'];
  if(!isset($proprietes['EnteteCouleur']))
      $proprietes['EnteteCouleur']=array();
  $this->EnteteCouleur=$proprietes['EnteteCouleur'];
  if(!isset($proprietes['couleur1']))
      $proprietes['couleur1']=array();
  if(!isset($proprietes['couleur2']))
      $proprietes['couleur2']=array();
  $this->LigneCouleurs=array($proprietes['couleur1'],$proprietes['couleur2']);
  // --- Calcule les largeurs des colonnes ---
  $this->CalculeLargeurs($proprietes['largeur'],$proprietes['align']);
  //Imprime l'en-tte
  $this->TableEntete();
  //--- Affiche les lignes ---
  $this->SetFont('Arial','',11);
  $this->CouleurIndex=0;
  $this->TraitementTable=true;
  foreach($this->tab_donnees as $index => $UneLigneDeDonnees)
        $this->Ligne($UneLigneDeDonnees);
  $this->TraitementTable=false;
  $this->cMargin=$cMargin;
  $this->LesColonnes=array();
 }
}
?>
