<?php
require('fpdf_ex07_MySQL_sprog.php');
include './INCLUDE/MySQL_include_param_dbb.php';
// --- classe PDF dérivée de PDF_MySQL_Table ---
class PDF extends PDF_MySQL_Table
{
 function Header()
 {
  //Titre
  $this->SetFont('Arial','',18);
  $this->Cell(0,6,'Liste des personnes',0,1,'C');
  $this->Ln(10);
  // --- Imprime l'en-tête du tableau si nécessaire ---
  parent::Header();
 }
}
try
{
 // === connexion de la base de données ===
 $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,$MDP_ADM,
               array(PDO::ATTR_PERSISTENT => true));
 // --- définition du codage en UTF8 ---    
 $bdd->exec("SET CHARACTER SET utf8");
 // --- création du PDF ---
 $pdf=new PDF();
 // --- ajout d'une page ---
 $pdf->AddPage();
 // --- Premier tableau : imprime toutes les colonnes de la requête ---
 $pdf->Table('select * from personnes');
 // --- ajout d'une page ---
 $pdf->AddPage();
 // --- Second tableau : définit les 3 colonnes à afficher ---
 $pdf->AjoutColonne('Age',20,'Age','C');
 $pdf->AjoutColonne('Nom',50,'Nom de Naissance');
 $pdf->AjoutColonne('Prenom',40,utf8_decode('Prénoms'),'R');
 $proprietes=array('EnteteCouleur'=>array(255,150,100),
            'couleur1'=>array(210,245,255),
            'couleur2'=>array(255,255,210),
            'decalage'=>1);
 $pdf->Table('select Nom, Prenom, Age from personnes order by Age DESC limit 0,20',$proprietes);
 // --- Envoie le document au navigateur (I) ---
 // --- en cas de téléchargement, le nom du fichier ---
 // --- est  Table_MySQL.pdf ---
 //$pdf->Output();
 $pdf->Output('Table_MySQL.pdf','I');
}
catch(Exception $e)
{
 echo "<fieldset>";
 echo "<legend>Erreur :</legend>";
 echo 'Erreur : '.$e->getMessage();
 echo "</fieldset>";
}
?>