<?php
require('../INCLUDE/fpdf181/fpdf.php');
// --- classe PDF dérivée de FPDF ---
class PDF extends FPDF
{
 var $B;
 var $I;
 var $U;
 var $HREF;
 // --- Constructeur ---
 function __construct($orientation='P', $unit='mm', $size='A4')
 {
  // --- Appel au constructeur parent ---
  parent::__construct($orientation,$unit,$size);
  // Initialisation
  $this->B    = 0 ;
  $this->I    = 0 ;
  $this->U    = 0 ;
  $this->HREF = '';
 }
 // --- Ecriture HTML ---
 function EcrireHTML($TexteHTML)
 {
  // --- Analyseur HTML ---
  $TexteHTML = str_replace("\n",' ',$TexteHTML);
  $a = preg_split('/<(.*)>/U',$TexteHTML,-1,PREG_SPLIT_DELIM_CAPTURE);
  foreach($a as $i=>$e)
  {
   if($i%2==0)
   {
    // Texte
    if($this->HREF)
       $this->AfficheLien($this->HREF,$e);
    else
       $this->Write(5,$e);
   }
   else
   {
    // Balise
    if($e[0]=='/')
       $this->FermerBalise(strtoupper(substr($e,1)));
    else
    {
     // Extraction des attributs
     $a2 = explode(' ',$e);
     $tag = strtoupper(array_shift($a2));
     $attr = array();
     foreach($a2 as $v)
     {
      if(preg_match('/([^=]*)=["\']?([^"\']*)/',$v,$a3))
         $attr[strtoupper($a3[1])] = $a3[2];
     }
     $this->OuvrirBalise($tag,$attr);
    }
   }
  }
 }
 // --- Change le style selon la balise ouvrante HTML ---
 function OuvrirBalise($tag, $attr)
 {
  // Balise ouvrante
  if($tag=='B' || $tag=='I' || $tag=='U')
        $this->AffecteStyle($tag,true);
  if($tag=='A')
        $this->HREF = $attr['HREF'];
  if($tag=='BR')
        $this->Ln(5);
 }
 // --- Change le style selon la balise fermante HTML ---
 function FermerBalise($tag)
 {
  // Balise fermante
  if($tag=='B' || $tag=='I' || $tag=='U')
        $this->AffecteStyle($tag,false);
  if($tag=='A')
        $this->HREF = '';
 }
 // --- Change le style ---
 function AffecteStyle($tag, $enable)
 {
  // Modifie le style et sélectionne la police correspondante
  $this->$tag += ($enable ? 1 : -1);
  $style = '';
  foreach(array('B', 'I', 'U') as $s)
  {
    if($this->$s>0)
       $style .= $s;
  }
  $this->SetFont('',$style);
 }
 // --- Affichage le Lien ---
 function AfficheLien($URL, $txt)
 {
  // Place un hyperlien
  $this->SetTextColor(0,0,255);
  $this->AffecteStyle('U',true);
  $this->Write(5,$txt,$URL);
  $this->AffecteStyle('U',false);
  $this->SetTextColor(0);
 }
}
// --- texte HTML à interpréter ---
$TexteHTML = utf8_decode('Vous pouvez maintenant imprimer facilement du texte mélangeant différents styles : <b>gras</b>,
<i>italique</i>, <u>souligné</u>, ou <b><i><u>tous à la fois</u></i></b> !<br><br>Vous pouvez aussi
insérer des liens sous forme textuelle, comme <a href="http://www.fpdf.org">www.fpdf.org</a>, ou bien
sous forme d\'image : cliquez sur le logo.');
// ---------------------------
// --- Génération du PDF -----
// ---------------------------
// --- création de l'objet ---
$pdf = new PDF();
// --- Première page ---
$pdf->AddPage();
// --- chargement de la police ---
$pdf->AddFont('Verdana','','Verdana.php');
$pdf->AddFont('Verdana','B','VerdanaB.php');
$pdf->AddFont('Verdana','I','VerdanaI.php');
$pdf->AddFont('Verdana','BI','VerdanaBI.php');
// --- sélection de la police ---
$pdf->SetFont('Verdana','',20);
// --- affichage d'un texte ---
$pdf->Write(5,utf8_decode('Pour découvrir les nouveautés de ce tutoriel, cliquez '));
$pdf->SetFont('','U');
// --- Ajout d'une redirection vers un lien interne au document ---
$LienInterne = $pdf->AddLink();
// --- le texte ICI est cliquable ---
$pdf->Write(5,'ici',$LienInterne);
// --- positionnement en style de police Normal ---
$pdf->SetFont('');
// --- Seconde page ---
$pdf->AddPage();
// --- définit la position du lien interne ---
$pdf->SetLink($LienInterne);
// --- définit une image cliquable ---
$pdf->Image('IMAGES/LogoPHP.png',10,12,30,0,'','http://www.fpdf.org');
$pdf->SetLeftMargin(45);
$pdf->SetFontSize(14);
$pdf->EcrireHTML($TexteHTML);
// --- Envoie le document au navigateur (I) ---
// --- en cas de téléchargement, le nom du fichier ---
// --- est  Liens.pdf ---
$pdf->Output('Liens.pdf','I');
?>