<?php
require('../INCLUDE/fpdf181/fpdf.php');
// --- classe PDF dérivée de FPDF ---
class PDF extends FPDF
{
 // --- Chargement des données à partir du fichier ---
 function ChargementDonnees($file)
 {// Lecture du fichier
  $lignes = file($file);
  $donnee = array();
  // --- traitement de chaque ligne dans un tableau ---
  foreach($lignes as $ligne)
    $donnee[] = explode(';',trim($ligne));
  return $donnee;
 }
 // --- affichage des données dans un tableau standard ---
 // Tableau simple
 function AfficheTabStandard($TabEntete, $donnee)
 {
  // --- Largeurs des colonnes ---
  $largeur=40;
  // --- Hauteur de chaque ligne ---
  $hauteur=6;
  // --- Affichage de l'entête ---
  foreach($TabEntete as $colonne)
          $this->Cell(40,7,$colonne,1);
  // --- Saut de ligne ---
  $this->Ln();
  // --- Boucle d'affichage des lignes du tableau ---
  foreach($donnee as $ligne)
  {
   foreach($ligne as $colonne)
           $this->Cell($largeur,$hauteur,utf8_decode($colonne),1);
   // --- Saut de ligne ---
   $this->Ln();
  }
 }
 // --- affichage des données dans un tableau amélioré ---
 // --- formatage des valeurs numériques, et largeur des colonnes proportionnelle ---
 function AfficheTabAmeliore($TabEntete, $donnee)
 {
  // --- Tableau des largeurs des colonnes ---
  $TabLargeursCol = array(40, 35, 45, 40);
  // --- Hauteur de chaque ligne ---
  $hauteur=6;
  $hauteurEntete=7;
  // En-tête : alignement centré
  for($i=0;$i<count($TabEntete);$i++)
        $this->Cell($TabLargeursCol[$i],$hauteurEntete,$TabEntete[$i],1,0,'C');
  // --- Saut de ligne ---
  $this->Ln();
  // --- Boucle d'affichage des lignes du tableau ---
  foreach($donnee as $ligne)
  {
   // bordure : LR : gauche (Left) et droite (Right)
   // alignement des numériques à droite R
   $this->Cell($TabLargeursCol[0],$hauteur,utf8_decode($ligne[0]),'LR');
   $this->Cell($TabLargeursCol[1],$hauteur,utf8_decode($ligne[1]),'LR');
   $this->Cell($TabLargeursCol[2],$hauteur,number_format($ligne[2],0,',',' '),'LR',0,'R');
   $this->Cell($TabLargeursCol[3],$hauteur,number_format($ligne[3],0,',',' '),'LR',0,'R');
   // --- Saut de ligne ---
   $this->Ln();
  }
  // --- Trait de terminaison ---
  // --- bordure : T : haut (Topic) ---
  $this->Cell(array_sum($TabLargeursCol),0,'','T');
 }
 // --- affichage des données dans un tableau coloré ---
 // --- formatage des valeurs numériques, et couleur de ---
 // --- l'entête et des lignes ---
 function AfficheTabCouleur($TabEntete, $donnee)
 {
  // --- Couleurs, épaisseur du trait et police grasse ---
  // --- couleur de remplissage en bleu ---
  $this->SetFillColor(0,0,200);
  // --- texte des titres en blanc ---
  $this->SetTextColor(255);
  // --- couleur des bordures en bleu foncé ---
  $this->SetDrawColor(0,0,128);
  // --- épaisseur des bordures ---
  $this->SetLineWidth(0.3);
  // --- Police Grasse ---
  $this->SetFont('','B');
  // --- Tableau de largeur des colonnes ---
  $TabLargeursCol = array(40, 35, 45, 40);
  // --- Hauteur de chaque ligne ---
  $hauteur=6;
  // --- Affichage de l'entête, texte centré ---
  for($i=0;$i<count($TabEntete);$i++)
      $this->Cell($TabLargeursCol[$i],7,$TabEntete[$i],1,0,'C',true);
  // --- Saut de ligne ---
  $this->Ln();
  // --- Modification des couleurs et de la police ---
  // --- Rouge:224, Vert=235, Bleu=255 ---
  $this->SetFillColor(224,235,255);
  // --- texte noir ---
  $this->SetTextColor(0);
   // --- Police Normale ---
  $this->SetFont('');
  // --- Affichage des données ---
  // --- par défaut on ne remplit pas le fond de la cellule ---
  $remplissage = false;
  // --- Boucle d'affichage des lignes du tableau ---
  foreach($donnee as $ligne)
  {
   $this->Cell($TabLargeursCol[0],$hauteur,utf8_decode($ligne[0]),'LR',0,'L',$remplissage);
   $this->Cell($TabLargeursCol[1],$hauteur,utf8_decode($ligne[1]),'LR',0,'L',$remplissage);
   $this->Cell($TabLargeursCol[2],$hauteur,number_format($ligne[2],0,',',' '),'LR',0,'R',$remplissage);
   $this->Cell($TabLargeursCol[3],$hauteur,number_format($ligne[3],0,',',' '),'LR',0,'R',$remplissage);
   // --- Saut de ligne ---
   $this->Ln();
   // --- A chaque ligne on change la valeur booléenne du remplissage ---
   // --- ainsi une ligne sur deux est colorée ---
   $remplissage = !$remplissage;
  }
  // --- Trait de terminaison ---
  // --- bordure : T : haut (Topic) ---
  $this->Cell(array_sum($TabLargeursCol),0,'','T');
 }
}
// ---------------------------
// --- Génération du PDF -----
// ---------------------------
// --- création de l'objet ---
$pdf = new PDF();
// --- Titres des colonnes ----
$TabEntete = array('Pays', 'Capitale', utf8_decode('Superficie (km²)'), 'Pop. (milliers)');
// --- Chargement des données ---
$donnee = $pdf->ChargementDonnees('FICHIERS/fpdf_ex05_Pays.txt');
// --- sélection de la police de caractères ---
$pdf->SetFont('Arial','',14);
// --- ajout d'une nouvelle page ---
$pdf->AddPage();
$pdf->AfficheTabStandard($TabEntete,$donnee);
// --- ajout d'une nouvelle page ---
$pdf->AddPage();
$pdf->AfficheTabAmeliore($TabEntete,$donnee);
// --- ajout d'une nouvelle page ---
$pdf->AddPage();
$pdf->AfficheTabCouleur($TabEntete,$donnee);
// --- Envoie le document au navigateur (I) ---
// --- en cas de téléchargement, le nom du fichier ---
// --- est  Tableau_Pays.pdf ---
$pdf->Output('Tableau_Pays.pdf','I');
?>