<?php
require('../INCLUDE/fpdf181/fpdf.php');
// --- affichage pour A4 = 210 x 297 mm ---
define("PARAM_LARGEUR_TOTALE","210");
// --- Marges d'impression de 15 mm ---
define("PARAM_MARGE","15");
// --- Nombre de colonnes ---
define("NB_COL","4");
// --- calcul des différentes dimensions paramètres ---
$Param_Distance_Entre_Col=2;
$Param_Largeur_Zone_Texte=(PARAM_LARGEUR_TOTALE-(PARAM_MARGE*2))-((NB_COL-1)*$Param_Distance_Entre_Col);
$Param_Largeur_Col=$Param_Largeur_Zone_Texte/NB_COL;
// --- les méthodes Header() et Footer() sont appelées automatiquement ---
// --- par Addpage() et Close(). Leur implémentation dans FPDF est vide ---
// --- Il faut donc dériver la classe et redéfinir ces méthodes pour ---
// --- indiquer leur contenu ---
class PDF extends FPDF
{
 // Colonne courante
 var $col = 0;
 // Ordonnée du début des colonnes
 var $y0;
 // --- Entête ---
 function Header()
 {
  global $TitreC;
  // Verdana gras 15
  $this->SetFont('Verdana','B',15);
  // Calcul de la largeur du titre et positionnement
  $marge_cadre=3;
  $largeur_titre = $this->GetStringWidth($TitreC)+(2*$marge_cadre);
  $hauteur_titre = 9 ;
  $this->SetX((PARAM_LARGEUR_TOTALE-$largeur_titre)/2);
  // Couleurs de l'entête
  // Cadre : Rouge=120, Vert=170, Bleu=230
  $this->SetDrawColor(120,170,230);
  // Fond : Rouge=250, Vert=250, Bleu=190
  $this->SetFillColor(250,250,190);
  // Texte : Rouge=50, Vert=100, Bleu=220
  $this->SetTextColor(50,100,220);
  // Epaisseur du cadre (1 mm)
  $this->SetLineWidth(1);
  // Titre
  $this->Cell($largeur_titre,$hauteur_titre,$TitreC,1,1,'C',true);
  // Saut de ligne
  $this->Ln(10);
  // Sauvegarde de l'ordonnée
  $this->y0 = $this->GetY();
 }
 // --- Pied de page ---
 function Footer()
 {
  // Positionnement à 1,5 cm du bas
  $this->SetY(-15);
  // Verdana italique 8
  $this->SetFont('Verdana','I',8);
  // Couleur du texte en gris
  $this->SetTextColor(128);
  // Numéro de page
  $this->Cell(0,10,'Page '.$this->PageNo(),0,0,'C');
 }
 // --- gestion des colonnes ---
 function SetCol($col)
 {
  global $Param_Distance_Entre_Col, $Param_Largeur_Col;
  // Positionnement sur une colonne
  $this->col = $col;
  $PositionX = PARAM_MARGE+($col*($Param_Largeur_Col+(2*$Param_Distance_Entre_Col)));
  $this->SetLeftMargin($PositionX);
  $this->SetX($PositionX);
 }
 // --- gestion du saut de page ---
 // --- réécriture de la méthode de FPDF ---
 // --- cette méthode est appelée automatiquement ---
 // --- lorsqu'une condition de saut de page est remplie ---
 function AcceptPageBreak()
 {
  // Méthode autorisant ou non le saut de page automatique
  if($this->col<NB_COL-1)
  {
   // Passage à la colonne suivante
   $this->SetCol($this->col+1);
   // Ordonnée en haut
   $this->SetY($this->y0);
   // On reste sur la page
   return false;
  }
  else
  {
   // Retour en première colonne
   $this->SetCol(0);
   // Saut de page
   return true;
  }
 }
 // --- Génération du titre du chapitre ---
 function TitreChapitre($NumC, $libelle)
 {
  $PositionX=PARAM_MARGE;
  $this->SetLeftMargin($PositionX);
  $this->SetX($PositionX);
  // --- Police Verdana, Normal,12 ---
  $this->SetFont('Verdana','',12);
  // --- Couleur de fond rouge=200, vert=220, bleu=255 ---
  $this->SetFillColor(200,220,255);
  // --- Zone d'affichage du Titre ---
  $this->Cell(0,6,utf8_decode("Chapitre $NumC : $libelle"),0,1,'L',true);
  // --- Saut de ligne ---
  $this->Ln(4);
  // --- Sauvegarde de l'ordonnée ---
  $this->y0 = $this->GetY();
 }
 // --- Affichage du corps du chapitre ---
 function CorpsChapitre($Fichier)
 {
  global $Param_Distance_Entre_Col, $Param_Largeur_Col;

  // --- Récupération du texte à partir du fichier ---
  $texte_fichier = file_get_contents($Fichier);
  // --- Police Times, Normal, 12 ---
  $this->SetFont('Times','',12);
  // --- Sortie du texte largeur selon une largeur de colonne et une taille de ligne ---
  $largeur_colonne=$Param_Largeur_Col;
  $hauteur_ligne=5;
  $this->MultiCell($largeur_colonne,$hauteur_ligne,utf8_decode($texte_fichier));
  // --- Saut de ligne ---
  $this->Ln();
  // --- Texte de fin en italique, même police ---
  $this->SetFont('','I');
  $this->Cell(0,5,"(fin de l'extrait)");
  // --- Retour en première colonne ---
  $this->SetCol(0);
 }
 // --- Ajout d'un chapitre sur une nouvelle page ---
 function AjouterChapitre($NumC, $TitreC, $Fichier)
 {
  $this->AddPage('P','A4');
  $this->TitreChapitre($NumC,$TitreC);
  $this->CorpsChapitre($Fichier);
 }
}
// ---------------------------
// --- Génération du PDF -----
// ---------------------------
// --- création de l'objet ---
$pdf = new PDF();
// --- ajout de la police de caractères Verdana ---
$pdf->AddFont('Verdana','','Verdana.php');
$pdf->AddFont('Verdana','B','VerdanaBold.php');
$pdf->AddFont('Verdana','I','VerdanaItalic.php');
$pdf->AddFont('Verdana','BI','VerdanaBoldItalic.php');
// --- sélection de la police de caractères ---
$pdf->SetFont('Verdana','',16);
$TitreC = 'Vingt mille lieues sous les mers';
$pdf->SetTitle($TitreC);
$pdf->SetAuthor('Jules Verne');
$pdf->AjouterChapitre(1,'UN ÉCUEIL FUYANT','FICHIERS/fpdf_ex03_20000Lieues_chap1.txt');
$pdf->AjouterChapitre(2,'LE POUR ET LE CONTRE','FICHIERS/fpdf_ex03_20000Lieues_chap2.txt');
// --- Envoie le document au navigateur (I) ---
// --- en cas de téléchargement, le nom du fichier ---
// --- est  Extraits_20000Lieues.pdf ---
$pdf->Output('Extraits_20000Lieues.pdf','I');
?>