<?php
require('../INCLUDE/fpdf181/fpdf.php');
define("NB_COL","3");
// --- les méthodes Header() et Footer() sont appelées automatiquement ---
// --- par Addpage() et Close(). Leur implémentation dans FPDF est vide ---
// --- Il faut donc dériver la classe et redéfinir ces méthodes pour ---
// --- indiquer leur contenu ---
class PDF extends FPDF
{
 // --- Entête ---
 function Header()
 {
  global $TitreC;
  // Verdana gras 15
  $this->SetFont('Verdana','B',15);
  // Calcul de la largeur du titre et positionnement
  $largeur = $this->GetStringWidth($TitreC)+6;
  $this->SetX((210-$largeur)/2);
  // Couleurs de l'entête
  // Cadre : Rouge=120, Vert=170, Bleu=230
  $this->SetDrawColor(120,170,230);
  // Fond : Rouge=250, Vert=250, Bleu=190
  $this->SetFillColor(250,250,190);
  // Texte : Rouge=50, Vert=100, Bleu=220
  $this->SetTextColor(50,100,220);
  // Epaisseur du cadre (1 mm)
  $this->SetLineWidth(1);
  // Titre
  $this->Cell($largeur,9,$TitreC,1,1,'C',true);
  // Saut de ligne
  $this->Ln(10);
 }
 // --- Pied de page ---
 function Footer()
 {
  // Positionnement à 1,5 cm du bas
  $this->SetY(-15);
  // Verdana italique 8
  $this->SetFont('Verdana','I',8);
  // Couleur du texte en gris
  $this->SetTextColor(128);
  // Numéro de page
  $this->Cell(0,10,'Page '.$this->PageNo(),0,0,'C');
 }
 // --- Génération du titre du chapitre ---
 function TitreChapitre($NumC, $libelle)
 {
  // Police Verdana, Normal,12
  $this->SetFont('Verdana','',12);
  // Couleur de fond
  $this->SetFillColor(200,220,255);
  // Titre
  $this->Cell(0,6,utf8_decode("Chapitre $NumC : $libelle"),0,1,'L',true);
  //ou
  //$this->Cell(0,6,iconv('UTF-8', 'ISO-8859-1', "Chapitre $NumC : $libelle"),0,1,'L',true);
  // Saut de ligne
  $this->Ln(4);
 }
 // --- Génération du corps du chapitre ---
 function CorpsChapitre($Fichier)
 {
  // Récupération du texte à partir du fichier
  $texte_fichier = file_get_contents($Fichier);
  // Police Verdana, Normal, 12
  $this->SetFont('Times','',12);
  // Sortie du texte justifié
  $this->MultiCell(0,5,utf8_decode($texte_fichier));
  //ou
  //$this->MultiCell(0,5,iconv('UTF-8', 'ISO-8859-1',$texte_fichier));
  // Saut de ligne
  $this->Ln();
  // Texte de fin en italique, même police
  $this->SetFont('','I');
  $this->Cell(0,5,"(fin de l'extrait)");
 }
 // --- Ajout d'un chapitre sur une nouvelle page ---
 function AjouterChapitre($NumC, $TitreC, $Fichier)
 {
  $this->AddPage();
  $this->TitreChapitre($NumC,$TitreC);
  $this->CorpsChapitre($Fichier);
 }
}
// --- création de l'objet ---
$pdf = new PDF();
// --- ajout de la police de caractères Verdana ---
$pdf->AddFont('Verdana','','Verdana.php');
$pdf->AddFont('Verdana','B','VerdanaBold.php');
$pdf->AddFont('Verdana','I','VerdanaItalic.php');
$pdf->AddFont('Verdana','BI','VerdanaBoldItalic.php');
// --- sélection de la police de caractères ---
$pdf->SetFont('Verdana','',16);
// --- Formatage du document ---
$TitreC = 'Vingt mille lieues sous les mers';
$pdf->SetTitle($TitreC);
$pdf->SetAuthor('Jules Verne');
$pdf->AjouterChapitre(1,'UN ÉCUEIL FUYANT','FICHIERS/fpdf_ex03_20000Lieues_chap1.txt');
$pdf->AjouterChapitre(2,'LE POUR ET LE CONTRE','FICHIERS/fpdf_ex03_20000Lieues_chap2.txt');
// --- Envoie le document au navigateur (I) ---
// --- en cas de téléchargement, le nom du fichier ---
// --- Envoie le document au navigateur (I) ---
// --- en cas de téléchargement, le nom du fichier ---
// --- est  Extraits_20000Lieues.pdf ---
$pdf->Output('Extraits_20000Lieues.pdf','I');
?>