<?php
require('../INCLUDE/fpdf181/fpdf.php');
// --- les méthodes Header() et Footer() sont appelées automatiquement ---
// --- par Addpage() et Close(). Leur implémentation dans FPDF est vide ---
// --- Il faut donc dériver la classe et redéfinir ces méthodes pour ---
// --- indiquer leur contenu ---
class PDF extends FPDF
{
 // --- Définition de l'En-tête ---
 function Header()
 {
  // --- Ajout du Logo de FPDF à gauche ---
  $this->Image('IMAGES/logoFPDF.png',10,6,25);
  // --- Ajout du Logo de PHP à droite ---
  $this->Image('IMAGES/logoPHP.png',170,6,25);
  // --- Police Arial Gras 15 ---
  $this->SetFont('Arial','I',10);
  // --- Décalage à droite de 8 centimètres ---
  $this->SetX(80);
  // --- Affichage du Titre du document ---
  $this->Cell(50,10,utf8_decode('Exemple d\'entête et de pied de page'),0,0,'C');
  // --- Saut de ligne ---
  $this->Ln(20);
 }
 // --- définition du Pied de page ---
 function Footer()
 {
  // --- Positionnement à 1,5 cm du bas ---
  $this->SetY(-15);
  // --- Police Arial italique 8 ---
  $this->SetFont('Arial','I',8);
  // --- Affichage du Numéro de page ---
  //$this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
  $this->Cell(0,10,'Page '.$this->PageNo().'/{nbpages}',0,0,'C');
 }
}
// --- Création de l'objet, instance de la classe PDF dérivée de FPDF ---
$pdf = new PDF();
// --- définit un alias pour le nombre total de page {nbpages} ---
// --- par défaut l’alias est {nb} ---
//$pdf->AliasNbPages();
$pdf->AliasNbPages('{nbpages}');
// --- création d'une nouvelle page ---
$pdf->AddPage('L','A5');
// --- Sélection de la police ---
$pdf->SetFont('Times','',12);
for($i=1;$i<=15;$i++)
{
 $pdf->Cell(0,10,utf8_decode('Ligne numéro ').$i,0,1);
}
// --- Envoie le document au navigateur (I) ---
// --- en cas de téléchargement, le nom du fichier ---
// --- est  Exemple_Entete_Pied.pdf ---
$pdf->Output('Exemple_Entete_Pied.pdf','I');
?>