<?php
// On démarre la session AVANT d'écrire du code HTML
session_start();
include './INCLUDE/MySQL_include_param_dbb.php';
include './INCLUDE/MySQL_include_sprog_commun_web.php';
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Identification</title>
    <link href="./CSS/MySQL_Login_MdP.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   define("NbMaxTentatives",3);   
   try
   {
    // --- on vide la variable de session contenant le tableau résultat de l'identification ---
    unset($_SESSION['tab_identifiants']);
    // --- début du traitement ---
    if (empty($_POST['authentification']))
    {
     // --------------------------------------
     // --- Page initiale d'identification ---
     // --------------------------------------
     $_SESSION['nbtentatives']=0;
     affiche_formulaire_identification("MySQL_PDO_Login_MdP_SecurePASSWORD_web.php","Merci de vous identifier");
    }
    else
    {
     // --------------------------------------------------------
     // --- On traite les données envoyées par le formulaire ---
     // --------------------------------------------------------
     // --- récupération des variables login et mdp ---
     $Login      = $_POST['login'];
     $MotdePasse = $_POST['mdp']  ;
     // --- on met à jour le nombre de tentatives---
     $_SESSION['nbtentatives']++;
     // === authentification de la base de données ===
     $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,$MDP_ADM,
            array(PDO::ATTR_PERSISTENT => true));
     // --- définition du codage en UTF8 ---
     $bdd->exec("SET CHARACTER SET utf8");
     // --- écriture de la requête préparée ---
     $requete_sql="SELECT Login,MotdePasse,ID_Clt FROM identification_clients WHERE Login=:Login AND MotdePasse=PASSWORD(:MotdePasse)";
     // --- préparation de la requête ---
     $RequetePreparee = $bdd->prepare($requete_sql);
     // --- traitement des erreurs de la préparation de la requête ---
     if (!$RequetePreparee)
     {
      throw new Exception('Probl&egrave;me de requ&ecirc;te pr&eacute;par&eacute;e sur la table.');
     }
     else
     {
      // --- liaison avec les paramètres ---
      $RequetePreparee->bindParam(':Login', $Login, PDO::PARAM_STR, 10);
      $RequetePreparee->bindParam(':MotdePasse', $MotdePasse, PDO::PARAM_STR, 50);
      // --- exécution de la requête préparée ---
      $RequetePreparee->execute();
      // ---retourne un tableau associatif ---
      $RequetePreparee->setFetchMode(PDO::FETCH_ASSOC); 
      // --- On traite le retour de la requête --- 
      $tab_identifiants=$RequetePreparee->fetchAll();
      // --- fermeture de la requête ---
      // --- pour permettre d'autres requêtes ---
      $RequetePreparee->closeCursor();
      // -- on regarde si le tableau contient des informations ---
      if (empty($tab_identifiants))
      {
       // -----------------------------------------------------------------------
       // --- Le login et le mot de passe n'ont pas été trouvés dans la table ---
       // -----------------------------------------------------------------------
       // --- on met à jour le nombre de tentatives restantes ---
       $nbtentatives_restantes=NbMaxTentatives-$_SESSION['nbtentatives'];
       // --- s'il reste 0 tentatives on affiche un message d'erreur ---
       if ($nbtentatives_restantes <= 0)
             throw new Exception('D&eacute;sol&eacute; le nombre maximal de tentatives a &eacute;t&eacute; atteint.');
       // --- sinon on affiche à nouveau le formulaire d'identification ---
       affiche_formulaire_identification("MySQL_PDO_Login_MdP_SecurePASSWORD_web.php","Identification erron&eacute;e.</br> Merci de r&eacute;essayer");
       // --- on affiche le nombre de tentatives restantes ---
       echo "<div align=\"center\">";
       echo "Il vous reste ".$nbtentatives_restantes." tentative(s)".WEB_EOL;
       echo "</div>";
      }
      else
      {
       // -----------------------------------------------------------------
       // --- Le login et le mot de passe ont été trouvés dans la table ---
       // -----------------------------------------------------------------
       // --- on remet à 0 le nombre de tentatives ---
       $_SESSION['nbtentatives']=0;
       // --- on passe en variable de session l'ID_Clt du client trouvé ---
       $_SESSION['tab_identifiants']=$tab_identifiants;
       // --- redirection vers l'URL ---
       redirection_immediate("MySQL_PDO_Bienvenue_ID_Clt_Secure.php");
      }
     }
    }
   }
   catch(Exception $e)
   {
     echo "<fieldset>";
     echo "<legend>Identification</legend>";
     echo WEB_EOL;
     echo 'Erreur : '.$e->getMessage().WEB_EOL;
     echo "</fieldset>";
   }
   ?>
 </body>
</html>
