<?php
// On démarre la session AVANT d'écrire du code HTML
session_start();
include './INCLUDE/MySQL_include_param_dbb.php';
include './INCLUDE/MySQL_include_sprog_commun_web.php';
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Bienvenue</title>
    <link href="./CSS/MySQL.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   try
   {
     // --------------------------------------------------------
     // --- On traite les données envoyées par le formulaire ---
     // --------------------------------------------------------
     // --- on vérifie que la variable de session contenant   ---
     // --- le tableau des identifiants est définie          ---
     // --- si ce n'est le cas, la persone n'est pas identifiée ---
     if (!identification_valide($TYPE_DBB,$SERVEUR,$BASEDD,$LOGIN_ADM,$MDP_ADM))
     {
      throw new Exception('Vous n\'&ecirc;tes par identifi&eacute;.');     
     }
     // --- on récupère le tableau des identifiants trouvés ---
     $tab_identifiants=$_SESSION['tab_identifiants'];
     // --- les informations de la case 0, seule a devoir être retournée ---
     $ID_Clt     = $tab_identifiants[0]['ID_Clt']    ;
     $Login      = $tab_identifiants[0]['Login']     ; // pour information
     $MotdePasse = $tab_identifiants[0]['MotdePasse']; // pour information
     // === authentification de la base de données ===
     $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,$MDP_ADM,
            array(PDO::ATTR_PERSISTENT => true));
     // --- définition du codage en UTF8 ---
     $bdd->exec("SET CHARACTER SET utf8");
     // --- préparation de la requête ---
     $requete_sql="SELECT * FROM clients_bancaires WHERE ID_Clt=:ID_Clt";
     $RequetePreparee = $bdd->prepare($requete_sql);
     // --- traitement des erreurs de la préparation de la requête --- 
     if (!$RequetePreparee)
     {
      throw new Exception('Probl&egrave;me de requ&ecirc;te pr&eacute;par&eacute;e sur la table.');
     }
     else
     {
      // --- liaison avec les paramètres ---
      $RequetePreparee->bindParam(':ID_Clt', $ID_Clt, PDO::PARAM_INT);
      // --- exécution de la requête préparée ---
      $RequetePreparee->execute();
      // ---retourne un tableau associatif ---
      $RequetePreparee->setFetchMode(PDO::FETCH_ASSOC); 
      // --- On traite le retour de la requête --- 
      $tab_clients=$RequetePreparee->fetchAll();
      // --- fermeture de la requête ---
      // --- pour permettre d'autres requêtes ---
      $RequetePreparee->closeCursor();
      // -- on regarde si le tableau contient des informations ---
      if (empty($tab_clients))
      {
        throw new Exception('Aucun client trouv&eacute;.');
      }
      else
      {
       $Nom    = $tab_clients[0]['Nom'];
       $Prenom = $tab_clients[0]['Prenom'];
       echo "<h3>Bonjour $Prenom $Nom.</h3>".WEB_EOL;
       // --- affichage des données retournées ---
       affichage_liste_personnes("Information sur $Prenom $Nom",$tab_clients);
      }
     }
   }
   catch(Exception $e)
   {
     echo "<fieldset>";
     echo "<legend>Acc&egrave;s client</legend>";
     echo WEB_EOL;
     echo 'Erreur : '.$e->getMessage().WEB_EOL;
     echo "</fieldset>";
   }
   ?>
 </body>
</html>
