<!DOCTYPE html>
<html>
 <head>
  <meta charset="utf-8" />
   <title>Réception de valeurs via un formulaire</title>
   <!-- Feuille de style pour le tableau --> 
   <style>
    table, th, td {
      border: 1px solid black;
      border-collapse: collapse;
    } 
    th, td {
      padding: 5px;
      text-align: left;    
    }
  </style>
 </head>
 <body>
  <table style="width:50%">
   <caption>Interprétation de la saisie du formulaire</caption>
   <thead> <!-- En-tête du tableau -->
    <tr>
     <th>Variable</th>
     <th>Valeur</th>
    </tr>
   </thead>
   <tr>
   <?php
     // défini la présentation des dates, valeurs numériques au format local (français)
     setlocale (LC_ALL, 'fr_FR','fra','fr_FR@euro');       
     // --- on récupère les données ---
     $nom          = $_GET['nom']         ;
     $prenom       = $_GET['prenom']      ;
     $age          = $_GET['age']         ;
     $categorie    = $_GET['categorie']   ;
     $genre        = $_GET['genre']       ;
     $commentaires = $_GET['commentaires'];
     $note         = $_GET['note']        ;
     // --- on protège les données contre l'injection HTML ---
     // htmlspecialchars protège contre l'injection HTML en neutralisant les balises HTML
     // strip_tags protège contre l'injection HTML en supprimant les balises HTML

     // la variable nom n'est pas protégée
     //$nom          = htmlspecialchars($nom)   ;
     $prenom       = htmlspecialchars($prenom);
     $age          = strip_tags($age)         ;
     $categorie    = strip_tags($categorie)   ;
     $genre        = strip_tags($genre)       ;
     $commentaires = strip_tags($commentaires);
     $note         = strip_tags($note)        ;
     // --- on teste les variables et on les traitent ---
     // --- traitement de nom ---  
     if (isset($nom) AND (!empty($nom))) // Si le nom est défini et non vide
     {
      echo '<td>Nom : </td><td>'.$nom.'</td>';
     }
     else
     {
      echo '<td>Nom : </td><td>Non saisi</td>';
     }
     echo "</tr><tr>";    
     // --- traitement de prenom ---      
     if (isset($prenom) AND (!empty($prenom))) // Si le prénom est défini et non vide
     { 
      echo '<td>Prénom : </td><td>'.$prenom.'</td>';
     }
     else
     {
      echo '<td>Prénom : </td><td>Non saisi</td>';
     }
     echo "</tr><tr>";    
     // --- traitement de age ---      
     if (isset($age) AND (!empty($age))) // Si l'age est défini et non vide
     { 
      $age = str_replace(",",".",$age) ;
      if (is_numeric($age))  // Si l'age est numérique
      {
       if (is_int($age))  // Si l'age est un entier
       {
        echo '<td>Age : </td><td>'.$age.'</td>';
       }
       else
       {
        echo '<td>Age : </td><td>Format invalide (pas un nombre entier)</td>';
       }
      }
      else
      {
       echo '<td>Age : </td><td>Format invalide (non numérique)</td>';
      }
     }
     else
     {
      echo '<td>Age : </td><td>Non saisi</td>';
     }
     echo "</tr><tr>";    
     // --- traitement de categorie ---      
     if (isset($categorie) AND (!empty($categorie))) // Si la categorie est définie et non vide
     {
        echo '<td>Catégorie Soc. Prof. : </td><td>'.$categorie.'</td>';
     }
     else
     {
      echo '<td>Catégorie Soc. Prof. : </td><td>Non saisi</td>';
     }
     echo "</tr><tr>";    
     // --- traitement de genre ---      
     if (isset($genre) AND (!empty($genre))) // Si le genre défini et non vide
     {
      echo '<td>Genre : </td><td>'.$genre.'</td>';
     }
     else
     {
      echo '<td>Genre : </td><td>Non saisi</td>';
     }
     echo "</tr><tr>";    
     // --- traitement de commentaires ---      
     if (isset($commentaires) AND (!empty($commentaires))) // Si les commentaires sont définis et non vide
     {
      echo '<td>Commentaires : </td><td>'.$commentaires.'</td>';
     }
     else
     {
      echo '<td>Commentaires : </td><td>Non saisi</td>';
     }
     echo "</tr><tr>";    
     // --- traitement de note ---      
     if (isset($note) AND (!empty($note))) // Si la note est définie et non vide
     { 
      if (!is_numeric($note))
      {
       $note = str_replace(".","",$note) ;
      }
      $note = str_replace(",",".",$note) ;
      $note=floatval($note);
        
      if (is_numeric($note))  // Si la note est numérique
      {
       echo '<td>Note : </td><td>'.$note.'</td>';
      }
      else
      {
       echo '<td>Note : </td><td>Format invalide (non numérique)</td>';
      }
     }
     else
     {
      echo '<td>Note : </td><td>Non saisi</td>';
     }      
   ?> 
   </tr>
  </table>
 </body>
</html>
