<?php
// On démarre la session AVANT d'écrire du code HTML
// afin de conserver l'information indiquant si c'est le premier accès
session_start();
include 'INCLUDE/MySQL_PDO_liste_personnes_include_sprog_commun_web.php';
include 'INCLUDE/MySQL_PDO_liste_personnes_include_param_dbb.php';
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Suppression d'une personne</title>
	<link href="CSS/MySQL_PDO_liste_personnes.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   setlocale (LC_ALL, 'fr_FR.UTF-8');
   try
   {
    // -- contexte pour le message d'erreur ---
    $contexte="Probl&egrave;me de suppression dans la table.";  
    // === connexion de la base de données ===
    $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,$MDP_ADM,
                   array(PDO::ATTR_PERSISTENT => true));
    // --- initialisation des Exceptions PDO  ---
    $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    // --- définition du codage en UTF8 ---    
    $bdd->exec("SET CHARACTER SET utf8");
    // ---------------------------
    // --- Début du traitement ---
    // ---------------------------   
    // --------------------------------------------------------------
    // Cette page peut être appelée de plusieurs manières différentes
    // --------------------------------------------------------------
    if (!empty($_POST['confirmer_suppression']))
    {
     // --------------------------------------------------------------
     // Traitement de la réponse à la confirmation de suppression
     // --------------------------------------------------------------
     $Reponse_Suppression=$_POST['RepSuppr'];
     // --- Protection de l'injection HTML ---
     $Reponse_Suppression = strip_tags($Reponse_Suppression);
     if ($Reponse_Suppression == "oui")
     {
      // --------------------------------
      // La réponse est oui : on supprime
      // --------------------------------
      // --- on récupère le numéro de la personne à supprimer ---
      $numero_suppression=$_SESSION['numero_suppression'];
      // --- contre l'injection SQL ---
      // --- Il faut utiliser le méthode prepare ---
      // --- préparation de la requête ---
      $requete_sql="DELETE FROM ".$TABLEPERSONNES." WHERE ID=:numero_suppression";
      $RequetePreparee = $bdd->prepare($requete_sql);
      // --- liaison avec les paramètres ---
      $RequetePreparee->bindParam(':numero_suppression', $numero_suppression, PDO::PARAM_INT,10);
      // --- exécution de la requête ---
      $RequetePreparee->execute();
      // --- fermeture de la requête ---
      $RequetePreparee->closeCursor();
      // --- on récupère le tableau des personnes trouvées ---
      $tab_personnes_trouvees=$_SESSION['tab_personnes_trouvees'] ;
      $tab_a_Supprimer[$numero_suppression]=$tab_personnes_trouvees[$numero_suppression];
      affichage_liste_personnes("Cette personne a &eacute;t&eacute; supprim&eacute;e",$tab_a_Supprimer);
     }
     else
     {
      // ------------------------------------
      // La réponse est non : on ne fait rien
      // ------------------------------------
      $TitreMessage="Aucune personne supprim&eacute;e";
      $TexteMessage="Aucune personne n'a &eacute;t&eacute; supprim&eacute;e ! ";
      affiche_message_erreur($TitreMessage,$TexteMessage);
     }
    }
    elseif (!empty($_POST['choix_suppression_personne']))
    {
     // ===================================================
     // cas où la personne à supprimer a été sélectionnée
     // on demande la confirmation de la suppression
     // ===================================================
     // --- on récupère le tableau des personnes trouvées ---
     $tab_personnes_trouvees= $_SESSION['tab_personnes_trouvees'] ;
     // --- on récupère le numéro de la personne à supprimer ---
     $numero_suppression=$_POST['NumSuppr']                      ;
     // --- Protection de l'injection HTML ---
     $numero_suppression = intval(strip_tags($numero_suppression));
     $_SESSION['numero_suppression']=$numero_suppression ;
     if ( (empty($numero_suppression)) || (!array_key_exists($numero_suppression,$tab_personnes_trouvees)) )
     {
        $TitreMessage="Aucune s&eacute;lection";
        $TexteMessage="Aucune s&eacute;lection ! ";
        affiche_message_erreur($TitreMessage,$TexteMessage);
     }
     else
     {
      unset($tab_une_personne);
      $une_personne=$tab_personnes_trouvees[$numero_suppression];
      $tab_une_personne[]=$une_personne;
      affichage_liste_personnes("Personne &agrave; supprimer",$tab_une_personne);
      ?>
      <br/>
      <!-- <form action="MySQL_PDO_liste_personnes_suppression_web.php" method="post"> -->
      <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
     <fieldset>
       <legend>Confirmation de la suppression</legend><br/>
       Merci de confirmer la suppression de cette personne :<br/>
       Oui <input type="radio" name="RepSuppr" value="oui"> 
       Non <input type="radio" name="RepSuppr" value="non" checked="checked"> <br/><br/>
       <input type="submit" name="confirmer_suppression" value="Confirmer" />
       </fieldset>
      </form>
      <?php
     }
    }
    elseif (!empty($_POST['rechercher_critere']))
    {
     // =================================================================
     // cas où le formulaire de saisie a été validé et on appelle
     // une nouvelle fois ce programme avec les données du formulaire
     // on affiche un formulaire pour sélectionner la personne à supprimer
     // parmi la liste des personnes affichées
     // =================================================================
     $crit_recherche = $_POST['CritRech'];
     $val_recherche  = $_POST['ValRech'] ;
     // --- Protection de l'injection HTML ---
     $crit_recherche = strip_tags($crit_recherche);
     $val_recherche  = strip_tags($val_recherche) ;
     // --- élement du texte du message ---
     switch($crit_recherche)
     {
      case 'ID' : case 'Age'    :$egal_contient=" = "; $deb_msg="";$fin_msg="";break;
      case 'Nom': case 'Prenom' :$egal_contient=" contient ";$deb_msg="\"";$fin_msg="\"";break;
     }
     // --- Recherche ---
     $tab_personnes_trouvees=Recherche_sur_critere($crit_recherche,$val_recherche);
     if (count($tab_personnes_trouvees) == 0)
     {
      $TitreMessage="Aucune personne trouv&eacute;e";
      $TexteMessage="La recherche pour : $crit_recherche".$egal_contient."$val_recherche".WEB_EOL." n'a trouv&eacute; aucune personne ! ";
      affiche_message_erreur($TitreMessage,$TexteMessage);
     }
     else
     {
       // --- on conserve dans une variable de session le tableau des personnes trouvées ---
       $_SESSION['tab_personnes_trouvees']=$tab_personnes_trouvees ;
       // --- affichage de la liste de personnes trouvées ---
       $titre="Liste des personnes trouv&eacute;es pour : ".$crit_recherche.$egal_contient.$deb_msg.$val_recherche.$fin_msg;
       affichage_liste_personnes($titre,$tab_personnes_trouvees);
       // affichage du formulaire de saisie de la personne à supprimer
       ?>
       <br/>
       <!-- <form action="MySQL_PDO_liste_personnes_suppression_web.php" method="post"> -->
       <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
        <fieldset>
        <legend>Saisissez le Num&eacute;ro (ID) de la personne &agrave; supprimer :</legend><br/>
        Entrez le <b>Num&eacute;ro (ID)</b> de la personne &agrave; supprimer : <input type="text" name="NumSuppr" size="20" maxlength="20" autofocus/><br/><br/>
        <input type="submit" name="choix_suppression_personne" value="Supprimer" />
        <input type="reset" value="Effacer le formulaire" />
        </fieldset>
       </form>
       <?php
     }
    }
    else
    {
     // ===============================================
     // cas où on doit afficher le formulaire de saisie
     // pour rechercher la personne à supprimer
     // ===============================================
     ?>
     <br/>
     <!-- <form action="MySQL_PDO_liste_personnes_suppression_web.php" method="post"> -->
     <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
     <fieldset>
     <legend>Saisissez les crit&egrave;res de recherche :</legend><br/>
     S&eacute;lectionnez le crit&egrave;re de recherche : <br/><br/>
     Identifiant <input type="radio" name="CritRech" value="ID"> 
     Nom <input type="radio" name="CritRech" value="Nom" checked="checked"> 
     Pr&eacute;nom <input type="radio" name="CritRech" value="Prenom"> 
     Age <input type="radio" name="CritRech" value="Age"> <br/><br/>
     Entrez la valeur selon le crit&egrave;re : <input type="text" name="ValRech" size="20" maxlength="20" autofocus/><br/><br/>
     <input type="submit" name="rechercher_critere" value="Rechercher" />
     <input type="reset" value="Effacer le formulaire" />
     </fieldset>
     </form>
     <?php
    }
   }
   catch(Exception $e)
   {
     affiche_message_erreur($contexte,$e->getMessage());
   }
   include 'INCLUDE/MySQL_PDO_liste_personnes_include_retour_menu_web.php';
   ?>
 </body>
</html>
