<?php
// On démarre la session AVANT d'écrire du code HTML
// afin de conserver l'information indiquant si c'est le premier accès
session_start();
include 'INCLUDE/MySQL_PDO_liste_personnes_include_sprog_commun_web.php';
include 'INCLUDE/MySQL_PDO_liste_personnes_include_param_dbb.php';
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Saisie de plusieurs personnes</title>
	<link href="CSS/MySQL_PDO_liste_personnes.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   setlocale (LC_ALL, 'fr_FR.UTF-8');
   try
   {
    // -- contexte pour le message d'erreur ---
    $contexte="Probl&egrave;me d'insertion dans la table.";  
    // === connexion de la base de données ===
    $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,$MDP_ADM,
                   array(PDO::ATTR_PERSISTENT => true));
    // --- initialisation des Exceptions PDO  ---
    $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    // --- définition du codage en UTF8 ---    
    $bdd->exec("SET CHARACTER SET utf8");
    // --- cas du bouton terminer qui a été sélectionné ---
    if (!empty($_POST['terminer']))
    {
     // ----------------------------------
     // --- cas de la fin de la saisie ---
     // ----------------------------------
     // --- Tri du tableau ---
     $_SESSION['tab_personnes_saisies']=tri_tab_personnes($_SESSION['tab_personnes_saisies']);
     // --- affichage du résumé de la saisie ---
     $tab_personnes_saisies=$_SESSION['tab_personnes_saisies'];
     affichage_liste_personnes("Liste des personnes saisies",$tab_personnes_saisies);  
    }
    // -----------------------------------------------------------------------
    // sinon on affiche le formulaire et les informations complémentaires 
    // -----------------------------------------------------------------------
    else   
    {
     ?>
     <!--
     --------------------------------
     --- on affiche le formulaire ---
     --------------------------------
     -->
     <!-- <form action="MySQL_PDO_liste_personnes_saisie_web.php" method="post"> -->
     <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
      <fieldset>
      <legend>Saisissez les donn&eacute;es d'une nouvelle personne :</legend><br/>
      Entrez un nom : <input type="text" name="Nom" size="20" maxlength="20" placeholder="Dupont de Nemours" autofocus/><br/><br/>
      Entrez un pr&eacute;nom : <input type="text" name="Prenom" size="40" maxlength="40" placeholder="Jean Charles"/><br/><br/>
      Entrez un &acirc;ge : <input type="text" name="Age" size="3" maxlength="3" pattern="[1-9][0-9]{1,3}" placeholder="28"/><br/><br/>
      <input type="submit" name="valider" value="Valider cette personne" />
      <input type="reset" value="Effacer le formulaire" />
      <!-- Ajout bouton terminer pour terminer la saisie  -->
      <input type="submit" name="terminer" value="Terminer la Saisie" />
      </fieldset>
     </form>
     <?php
     // -----------------------------------------------------------------
     // on affiche sous le formulaire le résultat du traitement précédent
     // - soit le rangement dans le tableau tab_personnes_saisies
     // - soit un message d'erreur (sauf pour le premier affichage) 
     // -----------------------------------------------------------------
     // --- on récupère les valeurs saisies ---
     if (isset($_POST['Nom'])) $Nom = $_POST['Nom'] ;
     else $Nom     = ''     ;
     if (isset($_POST['Prenom'])) $Prenom = $_POST['Prenom'] ;
     else $Prenom     = ''  ;
     if (isset($_POST['Age'])) $Age = $_POST['Age'] ;
     else $Age     = ''     ;
     // --- Protection de l'injection HTML ---
     $Nom    = strip_tags($Nom)    ;
     $Prenom = strip_tags($Prenom) ;
     $Age    = strip_tags($Age)    ;    
     // --- On conserve les valeurs initiales ---
     $InitNom    = $Nom    ;
     $InitPrenom = $Prenom ;
     $InitAge    = $Age    ;
     // si ce n'est pas la première saisie
     if ($_SESSION['Afficher_Messages_Champs'])
     {
      // ---------------------------------------
      // on vérifie qu'il n'y a aucun champ vide
      // ---------------------------------------
      if (!empty($InitNom) && !empty($InitPrenom) && !empty($InitAge))
      {
       // ---------------------------------------
       // on vérifie la validité des chaque champ
       // ---------------------------------------
       $retourValidationAge    = true ;
       $retourValidationNom    = true ;
       $retourValidationPrenom = true ;
       if (!empty($InitAge))
       {
        $InitAge=normalisation_numerique($InitAge)   ;
        $retourValidationAge=validation_Age($InitAge);
        if ($retourValidationAge)
        {
         $Age  = intval($InitAge) ;
        }
       }
       if (!empty($InitNom))
       {
        $InitNom=normalisation_nom($InitNom) ;
        $retourValidationNom=!empty($InitNom);
        if ($retourValidationNom)
        {
         $Nom  = $InitNom ;
        }
       }
       if (!empty($InitPrenom))
       {
        $InitPrenom=normalisation_nom($InitPrenom) ;
        $retourValidationPrenom=!empty($InitPrenom);
        if ($retourValidationPrenom)
        {
         $Prenom  = $InitPrenom ;
        }
       }
       // -------------------------------
       // si tous les champs sont valides
       // -------------------------------
       if (($retourValidationAge) && ($retourValidationNom) && ($retourValidationPrenom) )
       {
        // -----------------------------------------
        // --- insertion de la nouvelle personne ---
        // -----------------------------------------
        // --- exécution de la requête ---
        // --- contre l'injection SQL ---
        // --- Il faut utiliser le méthode prepare ---
        // --- préparation de la requête ---
        $requete_sql="INSERT INTO ".$TABLEPERSONNES." (Nom,Prenom,Age) VALUES (:Nom,:Prenom,:Age)";
        $RequetePreparee = $bdd->prepare($requete_sql);
        // --- liaison avec les paramètres ---
        $RequetePreparee->bindParam(':Nom', $Nom, PDO::PARAM_STR, 30);
        $RequetePreparee->bindParam(':Prenom', $Prenom, PDO::PARAM_STR, 30);
        $RequetePreparee->bindParam(':Age', $Age, PDO::PARAM_INT, 3);
        $RequetePreparee->execute();
        $RequetePreparee->closeCursor();
        // ---------------------------------------------------------------------
        // --- récupération des informations de la dernière personne insérée ---
        // ---------------------------------------------------------------------
        // --- exécution de la requête ---
        $requete_sql="SELECT ID,Nom,Prenom,Age FROM ".$TABLEPERSONNES." ORDER BY ID DESC  LIMIT 1";
        $RequeteQuery = $bdd->query($requete_sql);
        // ---retourne un tableau associatif ---
        $RequeteQuery->setFetchMode(PDO::FETCH_ASSOC);
        unset($une_personne);
        $une_personne = $RequeteQuery->fetch()       ;
        // --- fermeture de la requête ---
        // --- pour permettre d'autres requêtes ---
        $RequeteQuery->closeCursor();
        // -------------------------------------------------------------
        // --- rangement dans le tableau tab_personnes_saisies de la session ---
        // -------------------------------------------------------------
        $_SESSION['tab_personnes_saisies'][]=$une_personne ;
        // --- affichage de la personne qui vient d'être insérerée dans la table des personnes ---
        affichage_une_personne("Derni&egrave;re personne saisie",$une_personne)  ;
       }
      }
      // -----------------------------------------------------------------
      // on affiche les éventuels messages d'erreur en cas de champs vides
      // -----------------------------------------------------------------
      else
      {
       echo "<fieldset>";
       echo "<legend>Valeurs &agrave; renseigner :</legend><br/>";
       if (empty($InitNom))    echo "Le champ Nom est vide".WEB_EOL;
       if (empty($InitPrenom)) echo "Le champ Pr&eacute;nom est vide".WEB_EOL;
       if (empty($InitAge))    echo "Le champ Age est vide".WEB_EOL;
       if ($InitAge == 0)      echo "Le champ Age est invalide".WEB_EOL;
       echo "</fieldset>";
      }
     }
     // ------------------------------------------------------------------
     // ce n'est pas la première saisie : la variable indiquant d'afficher
     // les éventuels messages d'erreur est positionnée
     // ------------------------------------------------------------------
     else
     {
      $_SESSION['Afficher_Messages_Champs']=true;
     }
    }
   }
   catch(Exception $e)
   {
     affiche_message_erreur($contexte,$e->getMessage());
   }
   include 'INCLUDE/MySQL_PDO_liste_personnes_include_retour_menu_web.php';
   ?>
 </body>
</html>
