<?php
// On démarre la session AVANT d'écrire du code HTML
// afin de conserver l'information indiquant si c'est le premier accès
session_start();
include 'INCLUDE/MySQL_PDO_liste_personnes_include_sprog_commun_web.php';
include 'INCLUDE/MySQL_PDO_liste_personnes_include_param_dbb.php';
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Modification d'une personne</title>
	<link href="CSS/MySQL_PDO_liste_personnes.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   setlocale (LC_ALL, 'fr_FR.UTF-8');
   try
   {
    // -- contexte pour le message d'erreur ---
    $contexte="Probl&egrave;me de modification dans la table.";  
    // === connexion de la base de données ===
    $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,$MDP_ADM,
                   array(PDO::ATTR_PERSISTENT => true));
    // --- initialisation des Exceptions PDO  ---
    $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    // --- définition du codage en UTF8 ---    
    $bdd->exec("SET CHARACTER SET utf8");
    // ---------------------------
    // --- Début du traitement ---
    // ---------------------------   
    // --------------------------------------------------------------
    // Cette page peut être appelée de plusieurs manières différentes
    // --------------------------------------------------------------
    if (!empty($_POST['valeur_modification_personne']))
    {
      // ===================================================
      // cas où les données des champs ont été saisies
      // on traite ces données et on modifie la personne
      // ===================================================
      // --- on récupère le numéro de la personne à modifier ---
      $numero_modification=$_SESSION['numero_modification'];
      // --- on récupère le tableau des personnes trouvées ---
      $tab_personnes_trouvees= $_SESSION['tab_personnes_trouvees'] ;
      // --- on récupère la personne à modifier ---
      $une_personne=$tab_personnes_trouvees[$numero_modification];
      // --- on mémorise la personne avant la modification ---
      $tab_a_modifier[$numero_modification]=$une_personne;
      // --- on récupère les informations avant la modification ---      
      $ID     = $une_personne['ID']     ;
      $Nom    = $une_personne['Nom']    ;
      $Prenom = $une_personne['Prenom'] ;
      $Age    = $une_personne['Age']    ;
      // --- pas de modification pour l'ID ---      
      $NouvID = $ID                     ;
      // --- on récupère les valeurs saisies ---
      if (isset($_POST['NouvNom'])) $NouvNom = $_POST['NouvNom'] ;
      else $NouvNom     = ''     ;
      if (isset($_POST['NouvPrenom'])) $NouvPrenom = $_POST['NouvPrenom'] ;
      else $NouvPrenom     = ''  ;
      if (isset($_POST['NouvAge'])) $NouvAge = $_POST['NouvAge'] ;
      else $NouvAge     = ''     ;
      // --- Protection de l'injection HTML ---
      $NouvNom    = strip_tags($NouvNom)   ;
      $NouvPrenom = strip_tags($NouvPrenom);
      $NouvAge    = strip_tags($NouvAge)   ;
      // --- on initialise les différents éléments de la requete SQL UPDATE ---
      $MAJ_Nom    ='';
      $MAJ_Prenom ='';
      $MAJ_Age    ='';
      // -----------------------------------------------
      // on vérifie qu'il y a au moins un champ non vide
      // -----------------------------------------------
      if (!empty($NouvNom) || !empty($NouvPrenom) || !empty($NouvAge))
      {
        // ---------------------------------------
        // on vérifie la validité des chaque champ
        // ---------------------------------------
        $retourValidationID     = true;
        $retourValidationAge    = true;
        $retourValidationNom    = true;
        $retourValidationPrenom = true;
        if ((!empty($NouvAge)) && ($Age!=normalisation_numerique($NouvAge)))
        {
         $NouvAge=normalisation_numerique($NouvAge);
         $retourValidationAge=validation_Age($NouvAge);
         if ($retourValidationAge)
         {
          $Age     = intval($NouvAge);
          $MAJ_Age =',Age=:Age'      ;
         }
        }
        if ( (!empty($NouvNom)) && ($Nom!=normalisation_nom($NouvNom)))
        {
         $NouvNom=normalisation_nom($NouvNom);
         $retourValidationNom=!empty($NouvNom);
         if ($retourValidationNom)
         {
          $Nom     = $NouvNom  ;
          $MAJ_Nom =',Nom=:Nom';
         }
        }
        if ( (!empty($NouvPrenom)) && ($Prenom!=normalisation_nom($NouvPrenom)))
        {
         $NouvPrenom=normalisation_nom($NouvPrenom);
         $retourValidationPrenom=!empty($NouvPrenom);
         if ($retourValidationPrenom)
         {
          $Prenom     = $NouvPrenom     ;
          $MAJ_Prenom =',Prenom=:Prenom';
         }
        }
        // ----------------------------------------------------
        // vérification du résultat de la validation des champs
        // ----------------------------------------------------
        if ((!$retourValidationID) || (!$retourValidationAge) || (!$retourValidationNom) || (!$retourValidationPrenom) )
        {
          // -------------------------------
          // si un des champs est invalide
          // -------------------------------
          redirection_delai("modification","MySQL_PDO_liste_personnes_modification_web.php",15);
        }
        else
        {
          // --------------------------------------
          // si tous les champs sont valides
          // on met à jour la table MySQL personnes
          // --------------------------------------
          // --- Construction de la requête ---
          $requete_sql='UPDATE '.$TABLEPERSONNES.' SET '.$MAJ_Nom.$MAJ_Prenom.$MAJ_Age.' WHERE ID='.$ID;
          // --- on supprime les espaces multiples ---
          $requete_sql= preg_replace('/\s{2,}/',' ',$requete_sql);
          // --- on supprime le caractere apostrophe juste apres SET ---
          $requete_sql= str_replace('SET ,','SET ',$requete_sql);
          // --- préparation de la requête ---
          $RequetePreparee = $bdd->prepare($requete_sql);
          // --- liaison avec les paramètres ---
          if (!empty($MAJ_Nom))
              $RequetePreparee->bindParam(':Nom', $Nom, PDO::PARAM_STR,30);
          if (!empty($MAJ_Prenom))
              $RequetePreparee->bindParam(':Prenom', $Prenom, PDO::PARAM_STR,30);
          if (!empty($MAJ_Age))
              $RequetePreparee->bindParam(':Age', $Age, PDO::PARAM_INT,3);
          // --- modification de la table ---   
          $RequetePreparee->execute();
          // --- affichage du résumé de la modification ---
          // on affiche la personne avant sa modification
          affichage_liste_personnes("La personne suivante",$tab_a_modifier);
          echo WEB_EOL;
          // on affiche la personne après sa modification
          $une_personne=compact('ID','Nom','Prenom','Age');
          $tab_Modifiee[$numero_modification]=$une_personne;
          affichage_liste_personnes("est modifi&eacute;e en",$tab_Modifiee);
        }
      }
      else
      {
        $TitreMessage="Aucune modification";
        $TexteMessage="Pas de modification : tous les champs sont vides ! ";
        affiche_message_erreur($TitreMessage,$TexteMessage);
      }
    }
    elseif (!empty($_POST['choix_modification_personne']))
    {
     // ===================================================
     // cas où la personne à modifier a été sélectionnée
     // on demande la confirmation de la modification
     // ===================================================
     // --- on récupère le tableau des personnes trouvées ---
     $tab_personnes_trouvees= $_SESSION['tab_personnes_trouvees'] ;
     // --- on récupère le numéro de la personne à modifier ---
     $numero_modification=$_POST['NumModif']                      ;
     // --- Protection de l'injection HTML ---
     $numero_modification = intval(strip_tags($numero_modification));
     $_SESSION['numero_modification']=$numero_modification ;
     if ( (empty($numero_modification)) || (!array_key_exists($numero_modification,$tab_personnes_trouvees)) )
     {
        $TitreMessage="Aucune s&eacute;lection";
        $TexteMessage="Aucune s&eacute;lection ! ";
        affiche_message_erreur($TitreMessage,$TexteMessage);
     }
     else
     {
      unset($tab_une_personne);
      $une_personne=$tab_personnes_trouvees[$numero_modification];
      $tab_une_personne[]=$une_personne;
      affichage_liste_personnes("Personne &agrave; modifier",$tab_une_personne);
      $Nom    = $une_personne['Nom']   ;
      $Prenom = $une_personne['Prenom'];
      $Age    = $une_personne['Age']   ;
      ?>
      <br/>
      <!-- <form action="MySQL_PDO_liste_personnes_modification_web.php" method="post"> -->
      <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
       <fieldset>
       <legend>Saisissez les nouvelles valeurs :</legend><br/>
       <b>ATTENTION</b> : un champ non renseign&eacute; (vide) laisse la valeur inchang&eacute;e !
       <table summary="Tableau de modification">
        <caption>&nbsp;</caption>
        <thead>
         <tr>
          <!-- entête du tableau -->
          <th>Nouveau Nom</th>
          <th>Nouveau Pr&eacute;nom</th>
          <th>Nouvel Age</th>
         </tr>
        </thead>
        <tr>
         <td><input type="text" name="NouvNom" size="20" maxlength="20" placeholder="<?php echo $Nom; ?>" autofocus/></td>
         <td><input type="text" name="NouvPrenom" size="40" maxlength="40" placeholder="<?php echo $Prenom; ?>"/></td>
         <td><input type="text" name="NouvAge" size="3" maxlength="3" pattern="[1-9][0-9]{1,3}" placeholder="<?php echo $Age; ?>" /></td>
        </tr>
       </table>
       <br/><br/>
       <input type="submit" name="valeur_modification_personne" value="Modifier cette personne" />
       <input type="reset" value="Effacer le formulaire" />
       </fieldset>
      </form>
      <?php
     }
    }
    elseif (!empty($_POST['rechercher_critere']))
    {
     // =================================================================
     // cas où le formulaire de saisie a été validé et on appelle
     // une nouvelle fois ce programme avec les données du formulaire
     // on affiche un formulaire pour sélectionner la personne à modifier
     // parmi la liste des personnes affichées
     // =================================================================
     $crit_recherche = $_POST['CritRech'];
     $val_recherche  = $_POST['ValRech'] ;
     // --- Protection de l'injection HTML ---
     $crit_recherche = strip_tags($crit_recherche);
     $val_recherche  = strip_tags($val_recherche) ;
     // --- élement du texte du message ---
     switch($crit_recherche)
     {
      case 'ID' : case 'Age'    :$egal_contient=" = "; $deb_msg="";$fin_msg="";break;
      case 'Nom': case 'Prenom' :$egal_contient=" contient ";$deb_msg="\"";$fin_msg="\"";break;
     }
     // --- Recherche ---
     $tab_personnes_trouvees=Recherche_sur_critere($crit_recherche,$val_recherche);
     if (count($tab_personnes_trouvees) == 0)
     {
      $TitreMessage="Aucune personne trouv&eacute;e";
      $TexteMessage="La recherche pour : $crit_recherche".$egal_contient."$val_recherche".WEB_EOL." n'a trouv&eacute; aucune personne ! ";
      affiche_message_erreur($TitreMessage,$TexteMessage);
     }
     else
     {
       // --- on conserve dans une variable de session le tableau des personnes trouvées ---
       $_SESSION['tab_personnes_trouvees']=$tab_personnes_trouvees ;
       // --- affichage de la liste de personnes trouvées ---
       $titre="Liste des personnes trouv&eacute;es pour : ".$crit_recherche.$egal_contient.$deb_msg.$val_recherche.$fin_msg;
       affichage_liste_personnes($titre,$tab_personnes_trouvees);
       // affichage du formulaire de saisie de la personne à modifier
       ?>
       <br/>
       <!-- <form action="MySQL_PDO_liste_personnes_modification_web.php" method="post"> -->
       <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
        <fieldset>
        <legend>Saisissez le Num&eacute;ro (ID) de la personne &agrave; modifier :</legend><br/>
        Entrez le <b>Num&eacute;ro (ID)</b> de la personne &agrave; modifier : <input type="text" name="NumModif" size="20" maxlength="20" autofocus/><br/><br/>
        <input type="submit" name="choix_modification_personne" value="Modifier" />
        <input type="reset" value="Effacer le formulaire" />
        </fieldset>
       </form>
       <?php
     }
    }
    else
    {
     // ===============================================
     // cas où on doit afficher le formulaire de saisie
     // pour rechercher la personne à modifier
     // ===============================================
     ?>
     <br/>
     <!-- <form action="MySQL_PDO_liste_personnes_modification_web.php" method="post"> -->
     <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
     <fieldset>
     <legend>Saisissez les crit&egrave;res de recherche :</legend><br/>
     S&eacute;lectionnez le crit&egrave;re de recherche : <br/><br/>
     Identifiant <input type="radio" name="CritRech" value="ID"> 
     Nom <input type="radio" name="CritRech" value="Nom" checked="checked"> 
     Pr&eacute;nom <input type="radio" name="CritRech" value="Prenom"> 
     Age <input type="radio" name="CritRech" value="Age"> <br/><br/>
     Entrez la valeur selon le crit&egrave;re : <input type="text" name="ValRech" size="20" maxlength="20" autofocus/><br/><br/>
     <input type="submit" name="rechercher_critere" value="Rechercher" />
     <input type="reset" value="Effacer le formulaire" />
     </fieldset>
     </form>
     <?php
    }
   }
   catch(Exception $e)
   {
     affiche_message_erreur($contexte,$e->getMessage());
   }
   include 'INCLUDE/MySQL_PDO_liste_personnes_include_retour_menu_web.php';
   ?>
 </body>
</html>
