<?php
include 'INCLUDE/MySQL_PDO_liste_personnes_include_sprog_commun_web.php';
include 'INCLUDE/MySQL_PDO_liste_personnes_include_param_dbb.php';
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Affichage des personnes</title>
	<link href="CSS/MySQL_PDO_liste_personnes.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   try
   {
    // -- contexte pour le message d'erreur ---
    $contexte="Probl&egrave;me de requ&circ;te sur la table.";  
    // --------------------------------------------
    // --- Affichage de la liste des personnes  ---
    // --------------------------------------------
    // === connexion de la base de données ===
    $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,$MDP_ADM,
                 array(PDO::ATTR_PERSISTENT => true));
    // --- initialisation des Exceptions PDO  ---
    $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    // --- définition du codage en UTF8 ---    
    $bdd->exec("SET CHARACTER SET utf8");
    // --- préparation de la requête ---
    $requete_sql="SELECT * FROM ".$TABLEPERSONNES;
    $RequetePreparee = $bdd->prepare($requete_sql);
    // --- exécution de la requête préparée ---
    $RequetePreparee->execute();
    // ---retourne un tableau associatif ---
    $RequetePreparee->setFetchMode(PDO::FETCH_ASSOC); 
    // --- boucle de traitement de chaque personne --- 
    $tab_personnes=$RequetePreparee->fetchAll();
    // tri du tableau en retirant les doublons
    sort($tab_personnes);
    $tab_personnes=array_unique($tab_personnes,SORT_REGULAR );
    $nbpersonnes=count($tab_personnes);
    if ($nbpersonnes == 0)
    {
      $TexteMessage="Aucune personne &agrave; afficher ! ";
      affiche_message_erreur($contexte,$TexteMessage);
    }
    else
    {
      Affichage_liste_personnes("Liste des personnes",$tab_personnes);
    }
    // --- fermeture de la requête ---
    // --- pour permettre d'autres requêtes ---
    $RequetePreparee->closeCursor();
   }
   catch(Exception $e)
   {
     affiche_message_erreur($contexte,$e->getMessage());
   }
   // ----------------------------------
   // -- lien pour retourner au menu ---
   // ----------------------------------
   include 'INCLUDE/MySQL_PDO_liste_personnes_include_retour_menu_web.php';
   ?>
 </body>
</html>
