<?php
define("MAXAGE","120");
define("WEB_EOL","<br/>");
// ==================================================
// --- fonction outil d'affichage d'une personne  ---
// ==================================================
function affichage_une_personne($titre,$tunepersonne)
{
 // entête de l'affichage
  ?>
  <table summary="Tableau de r&eacute;sultat">
   <caption><?php echo $titre;?></caption>
   <thead>
    <tr>
    <!-- entête du tableau -->
     <th>ID</th>
     <th>Nom</th>
     <th>Pr&eacute;nom</th>
     <th>Age</th>
    </tr>
   </thead>
 <?php
 if (count($tunepersonne) ==0)
 {
   echo "<td colspan=\"4\"><b>Aucune donn&eacute;e &agrave; afficher</b></td>";
 }
 else
 {
   // importation des variables à partir de l'étiquette des champs
   extract($tunepersonne,EXTR_OVERWRITE);
   echo "<tr>";
   echo "<td>$ID</td><td>$Nom</td><td>$Prenom</td><td>$Age</td>";
   echo "</tr>";
 }
 ?></table><?php
}
// ========================================================
// --- fonction outil de tri d'un tableau de personnes  ---
// ========================================================
function tri_tab_personnes($tpersonnes)
{
  if (count($tpersonnes) !=0)
  {
   // tri du tableau en retirant les doublons
   $tpersonnes=array_unique($tpersonnes,SORT_REGULAR );
   sort($tpersonnes);
  }
   return $tpersonnes;
}
// ==========================================
// --- Redirection vers URL avec un délai --- 
// ==========================================
function redirection_delai($texte_page,$page_web, $delai_secondes)
{
 $delai_microsecondes=$delai_secondes*1000;
  
 echo "<h2>".$texte_page."  dans ".$delai_secondes." secondes ...</h3><br/>";
 // --- javascript d'attente de 5 secondes avant de rediriger vers la page de chargement --- 
 echo "<script type=\"text/javascript\">
          setInterval(function () {
            window.location = '".$page_web."';
          }, ".$delai_microsecondes.");
        </script>";
}
// ========================================
// --- Redirection vers URL immédiat    --- 
// ========================================
function redirection_immediate($page_web)
{
 // --- rediriger vers la page de chargement --- 
 //echo'<script>window.location="'.$page_web.'";</script>';
 print('<meta http-equiv="refresh" content="0;URL='.$page_web.'">');
}
// ============================================================
// --- fonction outil d'affichage d'un tableau de personnes  ---
// ============================================================
function affichage_liste_personnes($titre,$tpersonnes)
{
 // --- affichage entête du tableau ---
 reset($tpersonnes);
 $une_personne=current($tpersonnes);
 $liste_champs=array_keys($une_personne);
 ?>
 <table summary="Tableau de r&eacute;sultat">
  <caption><?php echo $titre;?></caption>
  <thead>
  <tr>
  <!-- entête du tableau -->
  <?php
  echo "<tr>";
  $nbchamps=0;
  foreach($liste_champs as $nom_champ)
  {
   echo "<th>$nom_champ</th>";
   $nbchamps++;
  }
  echo "</tr>";
  // --- affichage des lignes du tableau ---
  if (count($tpersonnes) ==0)
  {
   echo "<td colspan=\"$nbchamps\"><b>Aucune personne &agrave; afficher</b></td>";
  }
  else
  {
   foreach ($tpersonnes as $indice => $une_personne)
   {
    echo "<tr>";
    // importation des variables à partir de l'étiquette des champs
    extract($une_personne,EXTR_OVERWRITE);
    echo "<td>$ID</td><td>$Nom</td><td>$Prenom</td><td>$Age</td>";
    echo "</tr>";
   }
  }
  ?>
 </table>
 <?php
}
// =======================================================
// --- fonction outil d'affichage du message d'erreur  ---
// =======================================================
function affiche_message_erreur($titre,$message)
{
 ?>
 <fieldset>
 <legend><?php echo $titre ?></legend><br/>
 <b><?php echo $message ?></b><br />
 </fieldset>
 <?php
}
// =================================================
// --- fonction outil de normalisation des noms  ---
// =================================================
function normalisation_nom($chaine)
{
 // tableau des motifs de recherche
 $tab_motif=array('/[^a-zA-Z -]/', '/[ -]+/', '/^-|-$/');
 // tableau des caract&egrave;res de remplacement
 $tab_remplacement=array('', '-', '')     ;
 // chaine de caract&egrave;res sur laquelle s'effectue le remplacement
 $chaine_contexte=supprime_accent($chaine);
 // retour de la fonction
 return strtoupper(preg_replace($tab_motif,$tab_remplacement, $chaine_contexte));
}
// =================================================
// --- fonction outil de normalisation des numériques  ---
// =================================================
function normalisation_numerique($numero)
{
 // tableau des motifs de recherche
 $tab_motif=array('/[^0-9,.]/');
 // tableau des caract&egrave;res de remplacement
 $tab_remplacement=array('')     ;
 // retour de la fonction
 $numero_retour=intval(preg_replace($tab_motif,$tab_remplacement, $numero));
 return $numero_retour;
}
// =================================================
// --- fonction outil de suppression des accents ---
// =================================================
function supprime_accent($chaine)
{
  // tableau des caractères accentués à remplacer
  $caracteres_a_remplacer     = array('À', 'Á', 'Â', 'Ã', 'Ä', 'Å', 'Æ', 'Ç', 'È', 'É', 'Ê', 'Ë', 'Ì', 'Í', 'Î', 'Ï', 'Ð', 'Ñ', 'Ò', 'Ó', 'Ô', 'Õ', 'Ö', 'Ø', 'Ù', 'Ú', 'Û', 'Ü', 'Ý', 'ß', 'à', 'á', 'â', 'ã', 'ä', 'å', 'æ', 'ç', 'è', 'é', 'ê', 'ë', 'ì', 'í', 'î', 'ï', 'ñ', 'ò', 'ó', 'ô', 'õ', 'ö', 'ø', 'ù', 'ú', 'û', 'ü', 'ý', 'ÿ', 'Ā', 'ā', 'Ă', 'ă', 'Ą', 'ą', 'Ć', 'ć', 'Ĉ', 'ĉ', 'Ċ', 'ċ', 'Č', 'č', 'Ď', 'ď', 'Đ', 'đ', 'Ē', 'ē', 'Ĕ', 'ĕ', 'Ė', 'ė', 'Ę', 'ę', 'Ě', 'ě', 'Ĝ', 'ĝ', 'Ğ', 'ğ', 'Ġ', 'ġ', 'Ģ', 'ģ', 'Ĥ', 'ĥ', 'Ħ', 'ħ', 'Ĩ', 'ĩ', 'Ī', 'ī', 'Ĭ', 'ĭ', 'Į', 'į', 'İ', 'ı', 'Ĳ', 'ĳ', 'Ĵ', 'ĵ', 'Ķ', 'ķ', 'Ĺ', 'ĺ', 'Ļ', 'ļ', 'Ľ', 'ľ', 'Ŀ', 'ŀ', 'Ł', 'ł', 'Ń', 'ń', 'Ņ', 'ņ', 'Ň', 'ň', 'ŉ', 'Ō', 'ō', 'Ŏ', 'ŏ', 'Ő', 'ő', 'Œ', 'œ', 'Ŕ', 'ŕ', 'Ŗ', 'ŗ', 'Ř', 'ř', 'Ś', 'ś', 'Ŝ', 'ŝ', 'Ş', 'ş', 'Š', 'š', 'Ţ', 'ţ', 'Ť', 'ť', 'Ŧ', 'ŧ', 'Ũ', 'ũ', 'Ū', 'ū', 'Ŭ', 'ŭ', 'Ů', 'ů', 'Ű', 'ű', 'Ų', 'ų', 'Ŵ', 'ŵ', 'Ŷ', 'ŷ', 'Ÿ', 'Ź', 'ź', 'Ż', 'ż', 'Ž', 'ž', 'ſ', 'ƒ', 'Ơ', 'ơ', 'Ư', 'ư', 'Ǎ', 'ǎ', 'Ǐ', 'ǐ', 'Ǒ', 'ǒ', 'Ǔ', 'ǔ', 'Ǖ', 'ǖ', 'Ǘ', 'ǘ', 'Ǚ', 'ǚ', 'Ǜ', 'ǜ', 'Ǻ', 'ǻ', 'Ǽ', 'ǽ', 'Ǿ', 'ǿ');
  // tableau des caractères sans accent de remplacement
  $caracteres_de_remplacement = array('A', 'A', 'A', 'A', 'A', 'A', 'AE', 'C', 'E', 'E', 'E', 'E', 'I', 'I', 'I', 'I', 'D', 'N', 'O', 'O', 'O', 'O', 'O', 'O', 'U', 'U', 'U', 'U', 'Y', 's', 'a', 'a', 'a', 'a', 'a', 'a', 'ae', 'c', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'n', 'o', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'y', 'y', 'A', 'a', 'A', 'a', 'A', 'a', 'C', 'c', 'C', 'c', 'C', 'c', 'C', 'c', 'D', 'd', 'D', 'd', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'G', 'g', 'G', 'g', 'G', 'g', 'G', 'g', 'H', 'h', 'H', 'h', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'IJ', 'ij', 'J', 'j', 'K', 'k', 'L', 'l', 'L', 'l', 'L', 'l', 'L', 'l', 'l', 'l', 'N', 'n', 'N', 'n', 'N', 'n', 'n', 'O', 'o', 'O', 'o', 'O', 'o', 'OE', 'oe', 'R', 'r', 'R', 'r', 'R', 'r', 'S', 's', 'S', 's', 'S', 's', 'S', 's', 'T', 't', 'T', 't', 'T', 't', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'W', 'w', 'Y', 'y', 'Y', 'Z', 'z', 'Z', 'z', 'Z', 'z', 's', 'f', 'O', 'o', 'U', 'u', 'A', 'a', 'I', 'i', 'O', 'o', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'A', 'a', 'AE', 'ae', 'O', 'o');
  // retour de la fonction
  return str_replace($caracteres_a_remplacer, $caracteres_de_remplacement, $chaine);
}
// =================================================
// --- fonction outil de validation du champ Age ---
// =================================================
function validation_Age($Age)
{
 $erreur=false;
 $erreurEntete="Erreur : champ Age <?php echo $Age; ?>";
 if (($Age == 0) || (!(($Age >0)&&($Age <MAXAGE))))
 {
  $erreur=true;
  $val=MAXAGE;
  $erreurMessage="Le champ Age est invalide ($Age). Il doit être compris entre 1 et $val ans";
 }
 if ($erreur)
 {
  affiche_message_erreur($erreurEntete,$erreurMessage);
 }
 return !$erreur;
}

// ================================
// --- Recherche sur critere ---
// ================================
function Recherche_sur_critere($crit_recherche,$val_recherche)
{
 global $TYPE_DBB,$SERVEUR,$BASEDD,$TABLEPERSONNES,$LOGIN_ADM,$MDP_ADM;
 $tab_personnes_retourne=array();
 switch($crit_recherche)
 {
  case 'ID'    :$val_recherche=intval($val_recherche);break;
  case 'Nom'   :$val_recherche="%".normalisation_Nom($val_recherche)."%";break;
  case 'Prenom':$val_recherche="%".normalisation_Nom($val_recherche)."%";break;
  case 'Age'   :$val_recherche=intval($val_recherche);break;
 }
 try
 {
  if (!empty($val_recherche) && $val_recherche!="%%")
  {
   // -- contexte pour le message d'erreur ---
   $contexte="Probl&egrave;me de recherche sur la table.";  
   // === connexion de la base de données ===
   $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,$MDP_ADM,
                array(PDO::ATTR_PERSISTENT => true));
   // --- initialisation des Exceptions PDO  ---
   $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
   // --- définition du codage en UTF8 ---    
   $bdd->exec("SET CHARACTER SET utf8");
   // --- exécution de la requête ---
   $requete_sql='SELECT * FROM '.$TABLEPERSONNES.' WHERE '.$crit_recherche.' LIKE :val_recherche';
   $RequetePreparee = $bdd->prepare($requete_sql);
   // --- liaison avec les paramètres ---
   switch($crit_recherche)
   {
    case 'ID' : case 'Age'    : $RequetePreparee->bindParam(':val_recherche', $val_recherche, PDO::PARAM_INT, 10);break;
    case 'Nom': case 'Prenom' : $RequetePreparee->bindParam(':val_recherche', $val_recherche, PDO::PARAM_STR, 50);break;
   }
   // --- exécution de la requête préparée ---
   $RequetePreparee->execute();
   // ---retourne un tableau associatif ---
   $RequetePreparee->setFetchMode(PDO::FETCH_ASSOC); 
   // --- boucle de traitement de chaque personne --- 
   unset($tab_personnes);
   unset($tab_personnes_retourne);
   // --- boucle de traitement de chaque personne --- 
   $tab_personnes=$RequetePreparee->fetchAll();
   foreach($tab_personnes as $une_personne)
   {
     extract($une_personne,EXTR_OVERWRITE);
     $tab_personnes_retourne[$ID]=$une_personne;
   }
   if ($tab_personnes_retourne)
       $tab_personnes_retourne=array_unique($tab_personnes_retourne,SORT_REGULAR);
  }
 }
 catch(Exception $e)
 {
      affiche_message_erreur($contexte,$e->getMessage());
 }
 return $tab_personnes_retourne;
}
?>
