<?php
// =======================================
// -- saisie d'une liste de personnes --
// =======================================
function Saisie()
{global $TYPE_DBB,$SERVEUR,$BASEDD,$TABLEPERSONNES,$LOGIN_ADM,$MDP_ADM;
 // -- saisi des données dans un tableau tab_personnes --
 $entree="saisie non vide";
 while (!empty($entree))
 {echo "Entrez un un Nom, un Prénom et un Age (ex : Dupont;Jean;28) : ";
  $entree=fgets(STDIN) ;
  // on supprime les espaces au début et à la fin et le saut de ligne
  $entree=trim($entree);
  // on vérifie que la saisie n'est pas vide
  if (!empty($entree))
  {$erreur_saisie=false;
   // rangement dans le tableau associatif
   list($une_personne['Nom'],$une_personne['Prenom'],$une_personne['Age'])=explode(';',$entree);
   $indice=count($une_personne);
   $nb_champs=$indice+1;
   if ($indice != 3)
   {echo "  Erreur : La saisie ne contient $nb_champs champs ! ".PHP_EOL;
    $erreur_saisie=true;
   }
   else
   {// normalisation_Nom et vérification de chaque champ
    foreach($une_personne as $etiquette => $val_champ)
    {if (($etiquette == 'Nom') || ($etiquette == 'Prenom') )
     {$une_personne[$etiquette]=normalisation_Nom($val_champ);
     }
     if  ($etiquette == 'Age')
     {$val_champ=intval($val_champ)       ;
      $une_personne[$etiquette]=$val_champ;
      if ($val_champ <= 0)
      {echo "  Erreur : Valeur du champ $etiquette doit être un entier positif ! ".PHP_EOL;
       $erreur_saisie=true;
      }
     }
     if (empty($val_champ))
     {echo "  Erreur : Valeur du champ $etiquette  est non valide ! ".PHP_EOL;
      $erreur_saisie=true;
     }
    }
   }
   if (!$erreur_saisie)
   { // on renverse le tableau $une_personne à cause de l'ordre inverse de list
    $tab_personnes[]=array_reverse($une_personne);
   }
   else
   {echo "  Erreur : Merci de saisir à nouveau les informations !".PHP_EOL;
   }
  }
 }
 // -- si le tableau $tab_personnes n'est pas vide on insert des données dans la table personnes --
 if (count($tab_personnes) != 0)
 {try
  {// -- contexte pour le message d'erreur --
   $contexte="Problème d'insertion dans la  table.";  
   // -------------------------------------------
   // -- Affichage de la liste des personnes  --
   // -------------------------------------------
   // === connexion de la base de données ===
   $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,
          $MDP_ADM,array(PDO::ATTR_PERSISTENT => true));
   // -- initialisation des Exceptions PDO  --
   $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
   // -- définition du codage en UTF8 --    
   $bdd->exec("SET CHARACTER SET utf8");
   // -- préparation de la requête --
   $requete_sql="INSERT INTO ".$TABLEPERSONNES." (Nom,Prenom,Age) VALUES (:Nom,:Prenom,:Age)";
   $RequetePreparee = $bdd->prepare($requete_sql);
   // -- liaison avec les paramètres --
   $RequetePreparee->bindParam(':Nom', $Nom, PDO::PARAM_STR, 30);
   $RequetePreparee->bindParam(':Prenom', $Prenom, PDO::PARAM_STR, 30);
   $RequetePreparee->bindParam(':Age', $Age, PDO::PARAM_INT, 3);
   // -- insertion de chaque personne du tableau --   
   foreach ($tab_personnes as $une_personne)
   {// importe les variables dans la table des symboles
    extract($une_personne);
    $RequetePreparee->execute();
   }
  }
  catch(Exception $e)
  {echo $contexte.PHP_EOL;
   echo 'Erreur : '.$e->getMessage().PHP_EOL;
  }
 }
 else
 {echo "Aucune personne à ajouter !".PHP_EOL;
 }
}
// ===========================================
// -- Affichage de la liste des personnes --
// ===========================================
function Affichage()
{global $TYPE_DBB,$SERVEUR,$BASEDD,$TABLEPERSONNES,$LOGIN_ADM,$MDP_ADM;
 try
 {// -- contexte pour le message d'erreur --
  $contexte="Problème de requête sur la table.";  
  // -------------------------------------------
  // -- Affichage de la liste des personnes  --
  // -------------------------------------------
  // === connexion de la base de données ===
  $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,
        $MDP_ADM,array(PDO::ATTR_PERSISTENT => true));
  // -- initialisation des Exceptions PDO  --
  $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  // -- définition du codage en UTF8 --    
  $bdd->exec("SET CHARACTER SET utf8");
  // -- préparation de la requête --
  $requete_sql="SELECT * FROM ".$TABLEPERSONNES;
  $RequetePreparee = $bdd->prepare($requete_sql);
  // -- exécution de la requête préparée --
  $RequetePreparee->execute();
  // --retourne un tableau associatif --
  $RequetePreparee->setFetchMode(PDO::FETCH_ASSOC); 
  // -- boucle de traitement de chaque personne -- 
  $tab_personnes=$RequetePreparee->fetchAll();
  // tri du tableau en retirant les doublons
  sort($tab_personnes);
  $tab_personnes=array_unique($tab_personnes,SORT_REGULAR );
  $nbpersonnes=count($tab_personnes);
  if ($nbpersonnes == 0)
  {echo "Aucune personne à afficher !".PHP_EOL;
  }
  else
  {Affichage_liste_personnes("Liste des personnes",$tab_personnes);
  }
  // -- fermeture de la requête --
  // -- pour permettre d'autres requêtes --
  $RequetePreparee->closeCursor();
 }
 catch(Exception $e)
 {echo $contexte.PHP_EOL;
  echo 'Erreur : '.$e->getMessage().PHP_EOL;
 }
}
// ==================================
// -- Suppression d'une personne --
// ==================================
function Supprimer()
{global $TYPE_DBB,$SERVEUR,$BASEDD,$TABLEPERSONNES,$LOGIN_ADM,$MDP_ADM;
 // -- menu des critères --
 $tab_critere=choix_critere();
 if (count($tab_critere) != 0)
 {$critere          = $tab_critere[0];
  $valeur_recherche = $tab_critere[1];
  // -- recherche multi critères --             
  $tab_resultat=Recherche_sur_critere($critere,$valeur_recherche);
  if (count($tab_resultat) == 0)
  {echo "Aucune personne trouvée avec ce critère".PHP_EOL;
  }
  else
  {affichage_liste_personnes("Liste des personnes trouvées",$tab_resultat);
   echo "Sélectionnez l'ID de la personne à supprimer : ";
   fscanf(STDIN,"%d", $numero_ID);
   if (empty($numero_ID)) echo "Aucune sélection".PHP_EOL;
   else
   {// -- on récupère la colonne des ID --
    $colone_ID=array_column($tab_resultat,'ID');
    // -- on récupère l'indice numérique de la case --
    $numcase=array_search($numero_ID,$colone_ID);
    // -- array_search() retourne le numéro de la case du tableau --
    // -- ou false en cas d'échec --
    // -- attention il faut utiliser le triple = afin de --
    // -- résoudre le problème de la donnée trouvée --
    // -- dans la case 0 valeur qui peut être interprétée --
    // -- comme false si le test est noté : if (!$numcase) --
    if ($numcase === false)
    {echo "ID $numero_ID non trouvé dans la sélection !".PHP_EOL;
    }
    else
    {$une_personne=$tab_resultat[$numcase];
     extract($une_personne,EXTR_OVERWRITE);
     echo "-----------------------------------------".PHP_EOL;
     fprintf(STDOUT,"%6s %-20s %-20s %4s %s","ID","Nom","Prénom","Age",PHP_EOL);
     echo "-----------------------------------------".PHP_EOL;
     fprintf(STDOUT,"%6d %-20s %-20s %4d %s",$ID,$Nom,$Prenom,$Age,PHP_EOL)    ;
     echo "-----------------------------------------".PHP_EOL;
     echo "Confirmez la suppression (o/n) : ";
     fscanf(STDIN,"%s",$reponse);
     if ($reponse == "o")
     {// -- on supprime dans la table personnes --
      try
      {// -- contexte pour le message d'erreur --
       $contexte="Problème de suppression dans la  table.";  
       // -------------------------------------------
       // -- Affichage de la liste des personnes  --
       // -------------------------------------------
       // === connexion de la base de données ===
       $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,
              $MDP_ADM,array(PDO::ATTR_PERSISTENT => true));
       // -- initialisation des Exceptions PDO  --
       $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
       // -- définition du codage en UTF8 --    
       $bdd->exec("SET CHARACTER SET utf8");
       // -- préparation de la requête --
       $requete_sql="DELETE FROM ".$TABLEPERSONNES." WHERE ID=:ID";
       $RequetePreparee = $bdd->prepare($requete_sql);
       // -- liaison avec les paramètres --
       $RequetePreparee->bindParam(':ID', $ID, PDO::PARAM_INT);
       // -- suppresion de la table --   
       $RequetePreparee->execute();
       echo "$Nom  $Prenom supprimé".PHP_EOL    ;
      }
      catch(Exception $e)
      {echo $contexte.PHP_EOL;
       echo 'Erreur : '.$e->getMessage().PHP_EOL;
      }
     }
     else
     {echo "Aucune donnée supprimée".PHP_EOL;
     } 
    }
   }
  }
 }
}
// ==================================
// -- Modification d'une personne --
// ==================================
function Modifier()
{global $TYPE_DBB,$SERVEUR,$BASEDD,$TABLEPERSONNES,$LOGIN_ADM,$MDP_ADM;
 // -- menu des critères --
 $tab_critere=choix_critere();
 if (count($tab_critere) != 0)
 {$critere          = $tab_critere[0];
  $valeur_recherche = $tab_critere[1];
  // -- recherche multi critères --             
  $tab_resultat=Recherche_sur_critere($critere,$valeur_recherche);
  if (count($tab_resultat) == 0)
  {echo "Aucune personne trouvée avec ce critère".PHP_EOL;
  }
  else
  {affichage_liste_personnes("Liste des personnes trouvées",$tab_resultat);
   echo "Sélectionnez l'ID de la personne à modifier : ";
   fscanf(STDIN,"%d", $numero_ID);
   if (empty($numero_ID)) echo "Aucune sélection".PHP_EOL;
   else
   {// -- on récupère la colonne des ID --
    $colone_ID=array_column($tab_resultat,'ID');
    // -- on récupère l'indice numérique de la case --
    $numcase=array_search($numero_ID,$colone_ID);
    // -- array_search() retourne le numéro de la case du --
    // -- tableau ou false en cas d'échec --
    // -- attention il faut utiliser le triple = afin de --
    // -- résoudre le problème de la donnée trouvée dans la --
    // -- case 0 valeur qui peut être interprétée comme --
    // -- false si le test est noté : if (!$numcase) --
    if ($numcase === false)
    {echo "ID $numero_ID non trouvé dans la sélection !".PHP_EOL;
    }
    else
    {$une_personne=$tab_resultat[$numcase];
     extract($une_personne,EXTR_OVERWRITE);
     echo "-----------------------------------------".PHP_EOL;
     fprintf(STDOUT,"%6s %-20s %-20s %4s %s","ID","Nom","Prénom","Age",PHP_EOL);
     echo "-----------------------------------------".PHP_EOL;
     fprintf(STDOUT,"%6d %-20s %-20s %4d %s",$ID,$Nom,$Prenom,$Age,PHP_EOL)    ;
     echo "-----------------------------------------".PHP_EOL;
     echo "Confirmez la modification (o/n) : ";
     fscanf(STDIN,"%s",$reponse);
     if ($reponse == "o")
     {// -- on initialise les différents éléments de la requete SQL UPDATE --
      $MAJ_Nom    ='';
      $MAJ_Prenom ='';
      $MAJ_Age    ='';
      echo "Saisissez les nouvelles informations (vide pour inchangé) !".PHP_EOL;
      // -- saisie du nom --
      fprintf(STDOUT, "Nom    actuel : %-20s Nouveau Nom    : ",$Nom);
      $entree=fgets(STDIN) ;
      // normalisation_nom du nom
      $entree=normalisation_nom($entree);
      // on vérifie que la saisie n'est pas vide
      if (!empty($entree))
      {$Nom=$entree ;
       $MAJ_Nom =',Nom=:Nom';
      }
      else
      {echo "Pas de modification du nom".PHP_EOL;
      }
      // -- saisie du prénom --
      fprintf(STDOUT, "Prénom actuel : %-20s Nouveau Prénom : ",$Prenom);
      $entree=fgets(STDIN) ;
      // normalisation_nom du prénom
      $entree=normalisation_nom($entree);
      // on vérifie que la saisie n'est pas vide
      if (!empty($entree))
      {$Prenom=$entree ;
       $MAJ_Prenom =',Prenom=:Prenom';
      }
      else
      {echo "Pas de modification du prénom".PHP_EOL;
      }
      // -- saisie de l'âge --
      fprintf(STDOUT, "Age    actuel : %-20d Nouvel Age     : ",$Age);
      $entree=fgets(STDIN) ;
      // on supprime les espaces au début et à la fin et le saut de ligne  
      $entree=trim($entree);
      // on vérifie que la saisie n'est pas vide
      if (!empty($entree))
      {$entree=intval($entree)       ;
       if ($entree == 0)
       {echo "  Erreur : Valeur du champ âge doit être un entier ! => Pas de modification ".PHP_EOL;
       }
       else // on met à jour la donnée
       {$Age=$entree ;
        $MAJ_Age =',Age=:Age';
       }
      }
      else
      {echo "Pas de modification de l'âge".PHP_EOL;
      }
      // -- un des champs à été mis à jour : le traitement --
      if (!empty($MAJ_Nom) || !empty($MAJ_Prenom) || !empty($MAJ_Age))
      {// -- Construction de la requête --
       $requete_sql='UPDATE '.$TABLEPERSONNES.' SET '.$MAJ_Nom.$MAJ_Prenom.$MAJ_Age.' WHERE ID='.$ID;
       // -- on supprime les espaces multiples --
       $requete_sql= preg_replace('/\s{2,}/',' ',$requete_sql);
       // -- Supprime le caractère apostrophe après SET --
       $requete_sql= str_replace('SET ,','SET ',$requete_sql);
       // -- Modification dans la table personnes --
       try
       {// -- contexte pour le message d'erreur --
        $contexte="Problème de modification dans la  table.";  
        // -------------------------------------------
        // -- Affichage de la liste des personnes  --
        // -------------------------------------------
        // === connexion de la base de données ===
        $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,
               $MDP_ADM,array(PDO::ATTR_PERSISTENT => true));
        // -- initialisation des Exceptions PDO  --
        $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        // -- définition du codage en UTF8 --    
        $bdd->exec("SET CHARACTER SET utf8");
        // -- préparation de la requête --
        $RequetePreparee = $bdd->prepare($requete_sql);
        // -- liaison avec les paramètres --
        if (!empty($MAJ_Nom))
            $RequetePreparee->bindParam(':Nom', $Nom, PDO::PARAM_STR,30);
        if (!empty($MAJ_Prenom))
            $RequetePreparee->bindParam(':Prenom', $Prenom, PDO::PARAM_STR,30);
        if (!empty($MAJ_Age))
            $RequetePreparee->bindParam(':Age', $Age, PDO::PARAM_INT,3);
        // -- modification de la table --   
        $RequetePreparee->execute();
        echo "$Nom  $Prenom modifié".PHP_EOL    ;
       }
       catch(Exception $e)
       {echo $contexte.PHP_EOL;
        echo 'Erreur : '.$e->getMessage().PHP_EOL;
       }
      }
      else
      {echo "Aucun champ n'a été modifié".PHP_EOL;
      }
     }
     else
     {echo "Aucune donnée modifiée".PHP_EOL;
     } 
    }
   }
  }
 }
}
// ========================
// -- fonction quitter --
// ========================
function Quitter()
{echo "Au revoir !".PHP_EOL;}
// ===================================================
// -- Outil de sélection du choix pour la recherche --
// ===================================================
function choix_critere()
{ $tab_critere_retour=array();
  echo "Critère de recherche : ".PHP_EOL;;
  echo "    -a- Identifiant (ID)".PHP_EOL;
  echo "    -b- Nom".PHP_EOL;
  echo "    -c- Prénom".PHP_EOL;
  echo "    -d- Age".PHP_EOL;
  echo "Entrez le critère (a,b,c ou d) : ";
  fscanf(STDIN,"%s",$critere);
  $critere=$critere[0];
  switch ($critere)
  { case 'a' : echo "Identifiant : "; break;
    case 'b' : echo "Nom         : "; break;
    case 'c' : echo "Prénom      : "; break;
    case 'd' : echo "Age         : "; break;
    default  : echo "Choix erroné !".PHP_EOL; break;
  }
  if (($critere >='a') && ($critere <='d'))
  {$valeur_recherche=fgets(STDIN);
   trim($valeur_recherche);
   $tab_critere_retour[0]=$critere;
   $tab_critere_retour[1]=$valeur_recherche;
  }
 return $tab_critere_retour;
}
// ================================
// -- Recherche sur critere --
// ================================
function Recherche_sur_critere($crit_recherche,$val_recherche)
{global $TYPE_DBB,$SERVEUR,$BASEDD,$TABLEPERSONNES,$LOGIN_ADM,$MDP_ADM;
 $tab_personnes_retourne=array();
 switch($crit_recherche)
 {case 'a':$Nom_champ='ID'    ;$val_recherche=intval($val_recherche);break;
  case 'b':$Nom_champ='Nom'   ;$val_recherche="%".normalisation_Nom($val_recherche)."%";break;
  case 'c':$Nom_champ='PreNom';$val_recherche="%".normalisation_Nom($val_recherche)."%";break;
  case 'd':$Nom_champ='Age'   ;$val_recherche=intval($val_recherche);break;
 }
 try
 {
  if (!empty($val_recherche) && $val_recherche!="%%")
  {
   // -- contexte pour le message d'erreur --
   $contexte="Problème de requête sur la table.";  
   // === connexion de la base de données ===
   $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,
          $MDP_ADM, array(PDO::ATTR_PERSISTENT => true));
   // -- initialisation des Exceptions PDO  --
   $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
   // -- définition du codage en UTF8 --    
   $bdd->exec("SET CHARACTER SET utf8");
   // -- exécution de la requête --
   $requete_sql='SELECT * FROM '.$TABLEPERSONNES.' WHERE '.$Nom_champ.' LIKE :val_recherche';
   $RequetePreparee = $bdd->prepare($requete_sql);
   // -- liaison avec les paramètres --
   switch($crit_recherche)
   {case 'a': case 'd' : $RequetePreparee->bindParam(':val_recherche', $val_recherche, PDO::PARAM_INT, 10);break;
    case 'b': case 'c' : $RequetePreparee->bindParam(':val_recherche', $val_recherche, PDO::PARAM_STR, 50);break;
   }
   // -- exécution de la requête préparée --
   $RequetePreparee->execute();
   // --retourne un tableau associatif --
   $RequetePreparee->setFetchMode(PDO::FETCH_ASSOC); 
   // -- boucle de traitement de chaque personne -- 
   unset($tab_personnes_retourne);
   $tab_personnes_retourne=$RequetePreparee->fetchAll();
   sort($tab_personnes_retourne);
   $tab_personnes_retourne=array_unique($tab_personnes_retourne,SORT_REGULAR);
   }
  }
 catch(Exception $e)
 { echo $contexte.PHP_EOL;
   echo 'Erreur : '.$e->getMessage().PHP_EOL;
 }
 return $tab_personnes_retourne;
}
?>
