<?php
// ================================================
// -- fonction d'affichage du tableau --
// ================================================
function affichage_liste_personnes($texte,$tab_mixte)
{if (count($tab_mixte)==0)
        throw new Exception('Aucun élément à afficher.');
 // -- affichage entête du tableau --
 reset($tab_mixte);
 $une_personne=current($tab_mixte);
 $liste_champs=array_keys($une_personne);
 echo "-------------------------------------------".PHP_EOL;
 echo " $texte".PHP_EOL;
 echo "-------------------------------------------".PHP_EOL;
 foreach($liste_champs as $nom_champ)
 {echo "$nom_champ\t";
 }
 echo PHP_EOL;
 echo "-------------------------------------------".PHP_EOL;
 // -- boucle de traitement de chaque personne -- 
 foreach ($tab_mixte as $une_personne)
 {// -- on affiche le contenu des champs --
  foreach($liste_champs as $nom_champ)
  {echo $une_personne[$nom_champ]."\t";
  }
  echo PHP_EOL; 
 }
 echo "-------------------------------------------".PHP_EOL;
}
// ================================================
// -- fonction outil de suppression des accents --
// ================================================
function supprime_accent($chaine)
{// tableau des caractères accentués à remplacer
  $caracteres_a_remplacer     = array('À', 'Á', 'Â', 'Ã', 'Ä', 'Å', 'Æ', 'Ç', 'È', 'É', 'Ê', 'Ë', 'Ì', 'Í', 'Î', 'Ï', 'Ð', 'Ñ', 'Ò', 'Ó', 'Ô', 'Õ', 'Ö', 'Ø', 'Ù', 'Ú', 'Û', 'Ü', 'Ý', 'ß', 'à', 'á', 'â', 'ã', 'ä', 'å', 'æ', 'ç', 'è', 'é', 'ê', 'ë', 'ì', 'í', 'î', 'ï', 'ñ', 'ò', 'ó', 'ô', 'õ', 'ö', 'ø', 'ù', 'ú', 'û', 'ü', 'ý', 'ÿ', 'Ā', 'ā', 'Ă', 'ă', 'Ą', 'ą', 'Ć', 'ć', 'Ĉ', 'ĉ', 'Ċ', 'ċ', 'Č', 'č', 'Ď', 'ď', 'Đ', 'đ', 'Ē', 'ē', 'Ĕ', 'ĕ', 'Ė', 'ė', 'Ę', 'ę', 'Ě', 'ě', 'Ĝ', 'ĝ', 'Ğ', 'ğ', 'Ġ', 'ġ', 'Ģ', 'ģ', 'Ĥ', 'ĥ', 'Ħ', 'ħ', 'Ĩ', 'ĩ', 'Ī', 'ī', 'Ĭ', 'ĭ', 'Į', 'į', 'İ', 'ı', 'Ĳ', 'ĳ', 'Ĵ', 'ĵ', 'Ķ', 'ķ', 'Ĺ', 'ĺ', 'Ļ', 'ļ', 'Ľ', 'ľ', 'Ŀ', 'ŀ', 'Ł', 'ł', 'Ń', 'ń', 'Ņ', 'ņ', 'Ň', 'ň', 'ŉ', 'Ō', 'ō', 'Ŏ', 'ŏ', 'Ő', 'ő', 'Œ', 'œ', 'Ŕ', 'ŕ', 'Ŗ', 'ŗ', 'Ř', 'ř', 'Ś', 'ś', 'Ŝ', 'ŝ', 'Ş', 'ş', 'Š', 'š', 'Ţ', 'ţ', 'Ť', 'ť', 'Ŧ', 'ŧ', 'Ũ', 'ũ', 'Ū', 'ū', 'Ŭ', 'ŭ', 'Ů', 'ů', 'Ű', 'ű', 'Ų', 'ų', 'Ŵ', 'ŵ', 'Ŷ', 'ŷ', 'Ÿ', 'Ź', 'ź', 'Ż', 'ż', 'Ž', 'ž', 'ſ', 'ƒ', 'Ơ', 'ơ', 'Ư', 'ư', 'Ǎ', 'ǎ', 'Ǐ', 'ǐ', 'Ǒ', 'ǒ', 'Ǔ', 'ǔ', 'Ǖ', 'ǖ', 'Ǘ', 'ǘ', 'Ǚ', 'ǚ', 'Ǜ', 'ǜ', 'Ǻ', 'ǻ', 'Ǽ', 'ǽ', 'Ǿ', 'ǿ');
  // tableau des caractères sans accent de remplacement
  $caracteres_de_remplacement = array('A', 'A', 'A', 'A', 'A', 'A', 'AE', 'C', 'E', 'E', 'E', 'E', 'I', 'I', 'I', 'I', 'D', 'N', 'O', 'O', 'O', 'O', 'O', 'O', 'U', 'U', 'U', 'U', 'Y', 's', 'a', 'a', 'a', 'a', 'a', 'a', 'ae', 'c', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'n', 'o', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'y', 'y', 'A', 'a', 'A', 'a', 'A', 'a', 'C', 'c', 'C', 'c', 'C', 'c', 'C', 'c', 'D', 'd', 'D', 'd', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'G', 'g', 'G', 'g', 'G', 'g', 'G', 'g', 'H', 'h', 'H', 'h', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'IJ', 'ij', 'J', 'j', 'K', 'k', 'L', 'l', 'L', 'l', 'L', 'l', 'L', 'l', 'l', 'l', 'N', 'n', 'N', 'n', 'N', 'n', 'n', 'O', 'o', 'O', 'o', 'O', 'o', 'OE', 'oe', 'R', 'r', 'R', 'r', 'R', 'r', 'S', 's', 'S', 's', 'S', 's', 'S', 's', 'T', 't', 'T', 't', 'T', 't', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'W', 'w', 'Y', 'y', 'Y', 'Z', 'z', 'Z', 'z', 'Z', 'z', 's', 'f', 'O', 'o', 'U', 'u', 'A', 'a', 'I', 'i', 'O', 'o', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'A', 'a', 'AE', 'ae', 'O', 'o');
  // retour de la fonction
  return str_replace($caracteres_a_remplacer, $caracteres_de_remplacement, $chaine);
}
// ================================================
// -- fonction outil de normalisation des noms  --
// ================================================
function normalisation_nom($chaine)
{// tableau des motifs de recherche
 $tab_motif=array('/[^a-zA-Z -]/', '/[ -]+/', '/^-|-$/');
 // tableau des caract&egrave;res de remplacement
 $tab_remplacement=array('', '-', '')     ;
 // chaine de caract&egrave;res sur laquelle s'effectue le remplacement
 $chaine_contexte=supprime_accent($chaine);
 // retour de la fonction
 return strtoupper(preg_replace($tab_motif,$tab_remplacement, $chaine_contexte));
}
// ================================================
// -- fonction outil de normalisation des numériques  --
// ================================================
function normalisation_numerique($numero)
{// tableau des motifs de recherche
 $tab_motif=array('/[^0-9,.]/');
 // tableau des caract&egrave;res de remplacement
 $tab_remplacement=array('')     ;
 // retour de la fonction
 $numero_retour=intval(preg_replace($tab_motif,$tab_remplacement, $numero));
 return $numero_retour;
}
?>
