<?php
define("MAXID","1000000");
define("MAXAGE","120");
define("WEB_EOL","<br/>");
// =================================================
// --- fonction d'affichage du tableau ---
// =================================================
function affichage_liste_personnes($texte,$tab_mixte)
{
 if (count($tab_mixte)==0)
        throw new Exception('Aucun élément à afficher.');
 // --- affichage entête du tableau ---
 reset($tab_mixte);
 $une_personne=current($tab_mixte);
 $liste_champs=array_keys($une_personne);
 ?>
 <table summary="<?php echo $texte;?>">
 <caption><?php echo $texte;?></caption>
 <?php
 echo "<thead>";
 echo "<tr>";
 foreach($liste_champs as $nom_champ)
 {
  echo "<th>$nom_champ</th>";
 }
 echo "</tr>";
 echo "</thead>";

 // --- boucle de traitement de chaque personne --- 
 foreach ($tab_mixte as $une_personne)
 {
  // --- on affiche le contenu des champs ---
  echo "<tr>";
  foreach($liste_champs as $nom_champ)
  {
    echo "<td>".$une_personne[$nom_champ]."</td>";
  }
  echo "</tr>"; 
 }
 ?>
 </table>
 <?php
}
// =================================================
// --- fonctions de vérification et de conversion des dates ---
// =================================================
date_default_timezone_set("Europe/Paris");
// --- validation d'un format de date ---
function ValidationDate($date_dep, $format = 'Y-m-d H:i:s')
{
    $date_cree = DateTime::createFromFormat($format, $date_dep);
    return ($date_cree && ($date_cree->format($format) == $date_dep));
}
// --- conversion d'un format de date ---
function ConversionDate($date_dep,$format_dep='d/m/Y',$format_cible='Y-m-d')
{
    $date_cree = DateTime::createFromFormat($format_dep,$date_dep);
    $date_cible=$date_cree->format($format_cible);
    return $date_cible; 
}
// =================================================
// --- fonction d'affichage du contenu de la table ---
// =================================================
function affichage_table($bdd,$texte,$nom_table)
{
 // --- exécution de la requête ---
 $reponse = $bdd->query('SELECT * FROM '.$nom_table);
 // --- traitement des erreurs de retour sur la requête ---
 if (!$reponse)
     throw new Exception('Problème de requête sur la table.');
 // ---retourne un tableau associatif ---
 $reponse->setFetchMode(PDO::FETCH_ASSOC); 
 // --- boucle de traitement de chaque enregistrement --- 
 $tab_clients=$reponse->fetchAll();
 // --- affichage des données retournées ---
 affichage_liste_personnes("$texte",$tab_clients);
 // --- fermeture de la requête ---
 // --- pour permettre d'autres requêtes ---
 $reponse->closeCursor();
}
// =================================================
// --- fonction outil de suppression des accents ---
// =================================================
function supprime_accent($chaine)
{
  // tableau des caractères accentués à remplacer
  $caracteres_a_remplacer     = array('À', 'Á', 'Â', 'Ã', 'Ä', 'Å', 'Æ', 'Ç', 'È', 'É', 'Ê', 'Ë', 'Ì', 'Í', 'Î', 'Ï', 'Ð', 'Ñ', 'Ò', 'Ó', 'Ô', 'Õ', 'Ö', 'Ø', 'Ù', 'Ú', 'Û', 'Ü', 'Ý', 'ß', 'à', 'á', 'â', 'ã', 'ä', 'å', 'æ', 'ç', 'è', 'é', 'ê', 'ë', 'ì', 'í', 'î', 'ï', 'ñ', 'ò', 'ó', 'ô', 'õ', 'ö', 'ø', 'ù', 'ú', 'û', 'ü', 'ý', 'ÿ', 'Ā', 'ā', 'Ă', 'ă', 'Ą', 'ą', 'Ć', 'ć', 'Ĉ', 'ĉ', 'Ċ', 'ċ', 'Č', 'č', 'Ď', 'ď', 'Đ', 'đ', 'Ē', 'ē', 'Ĕ', 'ĕ', 'Ė', 'ė', 'Ę', 'ę', 'Ě', 'ě', 'Ĝ', 'ĝ', 'Ğ', 'ğ', 'Ġ', 'ġ', 'Ģ', 'ģ', 'Ĥ', 'ĥ', 'Ħ', 'ħ', 'Ĩ', 'ĩ', 'Ī', 'ī', 'Ĭ', 'ĭ', 'Į', 'į', 'İ', 'ı', 'Ĳ', 'ĳ', 'Ĵ', 'ĵ', 'Ķ', 'ķ', 'Ĺ', 'ĺ', 'Ļ', 'ļ', 'Ľ', 'ľ', 'Ŀ', 'ŀ', 'Ł', 'ł', 'Ń', 'ń', 'Ņ', 'ņ', 'Ň', 'ň', 'ŉ', 'Ō', 'ō', 'Ŏ', 'ŏ', 'Ő', 'ő', 'Œ', 'œ', 'Ŕ', 'ŕ', 'Ŗ', 'ŗ', 'Ř', 'ř', 'Ś', 'ś', 'Ŝ', 'ŝ', 'Ş', 'ş', 'Š', 'š', 'Ţ', 'ţ', 'Ť', 'ť', 'Ŧ', 'ŧ', 'Ũ', 'ũ', 'Ū', 'ū', 'Ŭ', 'ŭ', 'Ů', 'ů', 'Ű', 'ű', 'Ų', 'ų', 'Ŵ', 'ŵ', 'Ŷ', 'ŷ', 'Ÿ', 'Ź', 'ź', 'Ż', 'ż', 'Ž', 'ž', 'ſ', 'ƒ', 'Ơ', 'ơ', 'Ư', 'ư', 'Ǎ', 'ǎ', 'Ǐ', 'ǐ', 'Ǒ', 'ǒ', 'Ǔ', 'ǔ', 'Ǖ', 'ǖ', 'Ǘ', 'ǘ', 'Ǚ', 'ǚ', 'Ǜ', 'ǜ', 'Ǻ', 'ǻ', 'Ǽ', 'ǽ', 'Ǿ', 'ǿ');
  // tableau des caractères sans accent de remplacement
  $caracteres_de_remplacement = array('A', 'A', 'A', 'A', 'A', 'A', 'AE', 'C', 'E', 'E', 'E', 'E', 'I', 'I', 'I', 'I', 'D', 'N', 'O', 'O', 'O', 'O', 'O', 'O', 'U', 'U', 'U', 'U', 'Y', 's', 'a', 'a', 'a', 'a', 'a', 'a', 'ae', 'c', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'n', 'o', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'y', 'y', 'A', 'a', 'A', 'a', 'A', 'a', 'C', 'c', 'C', 'c', 'C', 'c', 'C', 'c', 'D', 'd', 'D', 'd', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'G', 'g', 'G', 'g', 'G', 'g', 'G', 'g', 'H', 'h', 'H', 'h', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'IJ', 'ij', 'J', 'j', 'K', 'k', 'L', 'l', 'L', 'l', 'L', 'l', 'L', 'l', 'l', 'l', 'N', 'n', 'N', 'n', 'N', 'n', 'n', 'O', 'o', 'O', 'o', 'O', 'o', 'OE', 'oe', 'R', 'r', 'R', 'r', 'R', 'r', 'S', 's', 'S', 's', 'S', 's', 'S', 's', 'T', 't', 'T', 't', 'T', 't', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'W', 'w', 'Y', 'y', 'Y', 'Z', 'z', 'Z', 'z', 'Z', 'z', 's', 'f', 'O', 'o', 'U', 'u', 'A', 'a', 'I', 'i', 'O', 'o', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'A', 'a', 'AE', 'ae', 'O', 'o');
  // retour de la fonction
  return str_replace($caracteres_a_remplacer, $caracteres_de_remplacement, $chaine);
}
// =================================================
// --- fonction outil de normalisation des noms  ---
// =================================================
function normalisation_nom($chaine)
{
 // tableau des motifs de recherche
 $tab_motif=array('/[^a-zA-Z -]/', '/[ -]+/', '/^-|-$/');
 // tableau des caractères de remplacement
 $tab_remplacement=array('', '-', '')     ;
 // chaine de caractères sur laquelle s'effectue le remplacement
 $chaine_contexte=supprime_accent($chaine);
 // retour de la fonction
 return strtoupper(preg_replace($tab_motif,$tab_remplacement, $chaine_contexte));
}
// =================================================
// --- fonction outil de normalisation des numériques  ---
// =================================================
function normalisation_numerique($numero)
{
 // tableau des motifs de recherche
 $tab_motif=array('/[^0-9,.]/');
 // tableau des caractères de remplacement
 $tab_remplacement=array('')     ;
 // retour de la fonction
 $numero_retour=intval(preg_replace($tab_motif,$tab_remplacement, $numero));
 return $numero_retour;
}
// ===============================
// --- Validation du champ Age ---
// ===============================
function validation_Age($Age)
{
 $erreur=false;
 $erreurEntete="Erreur : champ Age <?php echo $Age; ?>";
 if (($Age == 0) || (!(($Age >0)&&($Age <MAXAGE))))
 {
  $erreur=true;
  $val=MAXAGE;
  $erreurMessage="Le champ Age est invalide ($Age). Il doit être compris entre 1 et $val ans";
 }
 if ($erreur)
 {
  ?>
  <fieldset>
  <legend><?php echo $erreurEntete ?></legend><br/>
  <?php
  if (!empty($erreurMessage)) echo $erreurMessage;
  ?>
  <br/>
  </fieldset>
  <?php
 }
 return !$erreur;
}
// ==================================================
// --- fonction outil d'affichage d'une personne  ---
// ==================================================
function affichage_une_personne($titre,$tunepersonne)
{
 // entête de l'affichage
  ?>
  <table summary="Tableau de r&eacute;sultat">
   <caption><?php echo $titre;?></caption>
   <thead>
    <tr>
    <!-- entête du tableau -->
     <th>Identifiant</th>
     <th>Nom</th>
     <th>Pr&eacute;nom</th>
     <th>Age</th>
    </tr>
   </thead>
 <?php
 if (count($tunepersonne) ==0)
 {
   echo "<td colspan=\"4\"><b>Aucune donn&eacute;e &agrave; afficher</b></td>";
 }
 else
 {
   // importation des variables à partir de l'étiquette des champs
   extract($tunepersonne,EXTR_OVERWRITE);
   echo "<tr>";
   echo "<td>$ID</td><td>$Nom</td><td>$Prenom</td><td>$Age</td>";
   echo "</tr>";
 }
 ?></table><?php
}
// ============================================================
// --- fonction outil d'affichage d'un tableau de personnes  ---
// ============================================================
function affichage_tab_personnes($titre,$tpersonnes)
{
 // entête de l'affichage
  ?>
  <table summary="Tableau des r&eacute;sultat">
   <caption><?php echo $titre;?></caption>
   <thead>
    <tr>
    <!-- entête du tableau -->
     <th>Identifiant</th>
     <th>Nom</th>
     <th>Pr&eacute;nom</th>
     <th>Age</th>
    </tr>
   </thead>
 <?php
 if (count($tpersonnes) ==0)
 {
   echo "<td colspan=\"4\"><b>Aucune donn&eacute;e &agrave; afficher</b></td>";
 }
 else
 {
  foreach ($tpersonnes as $indice => $une_personne)
  {
   echo "<tr>";
   // importation des variables à partir de l'étiquette des champs
   extract($une_personne,EXTR_OVERWRITE);
   // la fonction extract est équivante à 
   /*
   $ID     = $une_personne['ID']    ;
   $nom    = $une_personne['nom']   ;
   $prenom = $une_personne['prenom'];
   $age    = $une_personne['age']   ;
   */
   echo "<td>$ID</td><td>$Nom</td><td>$Prenom</td><td>$Age</td>";
   echo "</tr>";
  }
 }
 ?></table><?php
}
// ========================================================
// --- fonction outil de tri d'un tableau de personnes  ---
// ========================================================
function tri_tab_personnes($tpersonnes)
{
  if (count($tpersonnes) !=0)
  {
   // tri du tableau en retirant les doublons
   $tpersonnes=array_unique($tpersonnes,SORT_REGULAR );
   sort($tpersonnes);
  }
   return $tpersonnes;
}
// ================================
// --- Recherche sur critere ---
// ================================
function Recherche_sur_critere($bdd,$nom_table,$crit_recherche,$val_recherche)
{
  switch($crit_recherche)
  {
    case 'ID'    :$nom_champ='ID'    ;
                  $val_recherche=intval($val_recherche);
                  break;
    case 'Nom'   :$nom_champ='Nom'   ;
                  $val_recherche="'%".normalisation_nom($val_recherche)."%'";
                  break;
    case 'Prenom':$nom_champ='Prenom';
                  $val_recherche="'%".normalisation_nom($val_recherche)."%'";
                  break;
    case 'Age'   :$nom_champ='Age'   ;
                  $val_recherche=intval($val_recherche);break;
  }
 // --- exécution de la requête ---
 $requete='SELECT * FROM '.$nom_table.' WHERE '.$nom_champ.' LIKE '.$val_recherche;
 $reponse = $bdd->query($requete);
 // --- traitement des erreurs de retour sur la requête ---
 if (!$reponse)
     throw new Exception('Problème de requête sur la table.');
 // ---retourne un tableau associatif ---
 $reponse->setFetchMode(PDO::FETCH_ASSOC); 
 // --- boucle de traitement de chaque personne --- 
 $tab_personnes=$reponse->fetchAll();
 unset($tab_personnes_retourne);
 foreach($tab_personnes as $une_personne)
 {
    $numero=$une_personne['ID'];
    $tab_personnes_retourne[$numero]=$une_personne;
 }
 return $tab_personnes_retourne;
}
// ======================================================
//  --- formulaire de saisie du login et mot de passe ---
// ======================================================
function affiche_formulaire_identification($url_action,$texte)
{
  ?>  
 <div align="center"><h1><?php echo $texte ?></h1></div>
  <div align="center">
  <form action="<? echo $url_action ?>" method="post">
     <table>
      <tr>
       <td>Login</td>
       <td><input type="text" name="login" size="10" maxlength="10" autofocus></td> </tr>
      <tr>
       <td>Mot de passe</td>
       <td><input type="password" name="mdp" size="20" maxlength="50"></td>
      </tr>
      <tr>
       <td colspan=2 align="center"><input type="submit" name="authentification" value="S'identifier"></td>
      </tr>
     </table>
  </form>
  </div>
  <?php   
}
// ==========================================
// --- Redirection vers URL avec un délai --- 
// ==========================================
function redirection_delai($texte_page,$page_web, $delai_secondes)
{
 $delai_microsecondes=$delai_secondes*1000;
  
 echo "<h2>".$texte_page."  dans ".$delai_secondes." secondes ...</h3><br/>";
 // --- javascript d'attente de 5 secondes avant de rediriger vers la page de chargement --- 
 echo "<script type=\"text/javascript\">
          setInterval(function () {
            window.location = '".$page_web."';
          }, ".$delai_microsecondes.");
        </script>";
}
// ========================================
// --- Redirection vers URL immédiat    --- 
// ========================================
function redirection_immediate($page_web)
{
 // --- rediriger vers la page de chargement --- 
 //echo'<script>window.location="'.$page_web.'";</script>';
 print('<meta http-equiv="refresh" content="0;URL='.$page_web.'">');
}

?>
