<?php
define("MAXID","1000000");
define("MAXAGE","120");
define("WEB_EOL","<br/>");
// =================================================
// --- fonction d'affichage du tableau ---
// =================================================
function affichage_liste_personnes($texte,$tab_mixte)
{
 if (count($tab_mixte)==0)
        throw new Exception('Aucun élément à afficher.');
 // --- affichage entête du tableau ---
 reset($tab_mixte);
 $une_personne=current($tab_mixte);
 $liste_champs=array_keys($une_personne);
 echo "-------------------------------".PHP_EOL;
 echo " $texte".PHP_EOL;
 echo "-------------------------------".PHP_EOL;
 foreach($liste_champs as $nom_champ)
 {
  echo "$nom_champ\t";
 }
 echo PHP_EOL;
 echo "-------------------------------".PHP_EOL;
 // --- boucle de traitement de chaque personne --- 
 foreach ($tab_mixte as $une_personne)
 {
 // --- on affiche le contenu des champs ---
 foreach($liste_champs as $nom_champ)
 {
  echo $une_personne[$nom_champ]."\t";
 }
 echo PHP_EOL; 
 }
}
// =================================================
// --- fonctions de vérification et de conversion des dates ---
// =================================================
date_default_timezone_set("Europe/Paris");
// --- validation d'un format de date ---
function ValidationDate($date_dep, $format = 'Y-m-d H:i:s')
{
    $date_cree = DateTime::createFromFormat($format, $date_dep);
    return ($date_cree && ($date_cree->format($format) == $date_dep));
}
// --- conversion d'un format de date ---
function ConversionDate($date_dep,$format_dep='d/m/Y',$format_cible='Y-m-d')
{
    $date_cree = DateTime::createFromFormat($format_dep,$date_dep);
    $date_cible=$date_cree->format($format_cible);
    return $date_cible; 
}
// =================================================
// --- fonction d'affichage du contenu de la table ---
// =================================================
function affichage_table($bdd,$texte,$nom_table)
{
 // --- exécution de la requête ---
 $reponse = $bdd->query('SELECT * FROM '.$nom_table);
 // --- traitement des erreurs de retour sur la requête ---
 if (!$reponse)
     throw new Exception('Problème de requête sur la table.');
 // ---retourne un tableau associatif ---
 $reponse->setFetchMode(PDO::FETCH_ASSOC); 
 // --- boucle de traitement de chaque enregistrement --- 
 $tab_clients=$reponse->fetchAll();
 // --- affichage des données retournées ---
 affichage_liste_personnes("$texte",$tab_clients);
 // --- fermeture de la requête ---
 // --- pour permettre d'autres requêtes ---
 $reponse->closeCursor();
}
// =================================================
// --- fonction outil de suppression des accents ---
// =================================================
function supprime_accent($chaine)
{
  // tableau des caractères accentués à remplacer
  $caracteres_a_remplacer     = array('À', 'Á', 'Â', 'Ã', 'Ä', 'Å', 'Æ', 'Ç', 'È', 'É', 'Ê', 'Ë', 'Ì', 'Í', 'Î', 'Ï', 'Ð', 'Ñ', 'Ò', 'Ó', 'Ô', 'Õ', 'Ö', 'Ø', 'Ù', 'Ú', 'Û', 'Ü', 'Ý', 'ß', 'à', 'á', 'â', 'ã', 'ä', 'å', 'æ', 'ç', 'è', 'é', 'ê', 'ë', 'ì', 'í', 'î', 'ï', 'ñ', 'ò', 'ó', 'ô', 'õ', 'ö', 'ø', 'ù', 'ú', 'û', 'ü', 'ý', 'ÿ', 'Ā', 'ā', 'Ă', 'ă', 'Ą', 'ą', 'Ć', 'ć', 'Ĉ', 'ĉ', 'Ċ', 'ċ', 'Č', 'č', 'Ď', 'ď', 'Đ', 'đ', 'Ē', 'ē', 'Ĕ', 'ĕ', 'Ė', 'ė', 'Ę', 'ę', 'Ě', 'ě', 'Ĝ', 'ĝ', 'Ğ', 'ğ', 'Ġ', 'ġ', 'Ģ', 'ģ', 'Ĥ', 'ĥ', 'Ħ', 'ħ', 'Ĩ', 'ĩ', 'Ī', 'ī', 'Ĭ', 'ĭ', 'Į', 'į', 'İ', 'ı', 'Ĳ', 'ĳ', 'Ĵ', 'ĵ', 'Ķ', 'ķ', 'Ĺ', 'ĺ', 'Ļ', 'ļ', 'Ľ', 'ľ', 'Ŀ', 'ŀ', 'Ł', 'ł', 'Ń', 'ń', 'Ņ', 'ņ', 'Ň', 'ň', 'ŉ', 'Ō', 'ō', 'Ŏ', 'ŏ', 'Ő', 'ő', 'Œ', 'œ', 'Ŕ', 'ŕ', 'Ŗ', 'ŗ', 'Ř', 'ř', 'Ś', 'ś', 'Ŝ', 'ŝ', 'Ş', 'ş', 'Š', 'š', 'Ţ', 'ţ', 'Ť', 'ť', 'Ŧ', 'ŧ', 'Ũ', 'ũ', 'Ū', 'ū', 'Ŭ', 'ŭ', 'Ů', 'ů', 'Ű', 'ű', 'Ų', 'ų', 'Ŵ', 'ŵ', 'Ŷ', 'ŷ', 'Ÿ', 'Ź', 'ź', 'Ż', 'ż', 'Ž', 'ž', 'ſ', 'ƒ', 'Ơ', 'ơ', 'Ư', 'ư', 'Ǎ', 'ǎ', 'Ǐ', 'ǐ', 'Ǒ', 'ǒ', 'Ǔ', 'ǔ', 'Ǖ', 'ǖ', 'Ǘ', 'ǘ', 'Ǚ', 'ǚ', 'Ǜ', 'ǜ', 'Ǻ', 'ǻ', 'Ǽ', 'ǽ', 'Ǿ', 'ǿ');
  // tableau des caractères sans accent de remplacement
  $caracteres_de_remplacement = array('A', 'A', 'A', 'A', 'A', 'A', 'AE', 'C', 'E', 'E', 'E', 'E', 'I', 'I', 'I', 'I', 'D', 'N', 'O', 'O', 'O', 'O', 'O', 'O', 'U', 'U', 'U', 'U', 'Y', 's', 'a', 'a', 'a', 'a', 'a', 'a', 'ae', 'c', 'e', 'e', 'e', 'e', 'i', 'i', 'i', 'i', 'n', 'o', 'o', 'o', 'o', 'o', 'o', 'u', 'u', 'u', 'u', 'y', 'y', 'A', 'a', 'A', 'a', 'A', 'a', 'C', 'c', 'C', 'c', 'C', 'c', 'C', 'c', 'D', 'd', 'D', 'd', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'E', 'e', 'G', 'g', 'G', 'g', 'G', 'g', 'G', 'g', 'H', 'h', 'H', 'h', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'I', 'i', 'IJ', 'ij', 'J', 'j', 'K', 'k', 'L', 'l', 'L', 'l', 'L', 'l', 'L', 'l', 'l', 'l', 'N', 'n', 'N', 'n', 'N', 'n', 'n', 'O', 'o', 'O', 'o', 'O', 'o', 'OE', 'oe', 'R', 'r', 'R', 'r', 'R', 'r', 'S', 's', 'S', 's', 'S', 's', 'S', 's', 'T', 't', 'T', 't', 'T', 't', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'W', 'w', 'Y', 'y', 'Y', 'Z', 'z', 'Z', 'z', 'Z', 'z', 's', 'f', 'O', 'o', 'U', 'u', 'A', 'a', 'I', 'i', 'O', 'o', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'U', 'u', 'A', 'a', 'AE', 'ae', 'O', 'o');
  // retour de la fonction
  return str_replace($caracteres_a_remplacer, $caracteres_de_remplacement, $chaine);
}
// =================================================
// --- fonction outil de normalisation des noms  ---
// =================================================
function normalisation_nom($chaine)
{
 // tableau des motifs de recherche
 $tab_motif=array('/[^a-zA-Z -]/', '/[ -]+/', '/^-|-$/');
 // tableau des caractères de remplacement
 $tab_remplacement=array('', '-', '')     ;
 // chaine de caractères sur laquelle s'effectue le remplacement
 $chaine_contexte=supprime_accent($chaine);
 // retour de la fonction
 return strtoupper(preg_replace($tab_motif,$tab_remplacement, $chaine_contexte));
}
// =================================================
// --- fonction outil de normalisation des numériques  ---
// =================================================
function normalisation_numerique($numero)
{
 // tableau des motifs de recherche
 $tab_motif=array('/[^0-9,.]/');
 // tableau des caractères de remplacement
 $tab_remplacement=array('')     ;
 // retour de la fonction
 $numero_retour=intval(preg_replace($tab_motif,$tab_remplacement, $numero));
 return $numero_retour;
}
// =========================================================================
// -- fonction outil de sélection du choix pour la recherche par critère  --
// =========================================================================
function choix_critere()
{
  $tab_critere_retour=array();
  echo "Critère de recherche : ".PHP_EOL;;
  echo "    -a- Identifiant (ID)".PHP_EOL;
  echo "    -b- Nom".PHP_EOL;
  echo "    -c- Prénom".PHP_EOL;
  echo "    -d- Age".PHP_EOL;
  echo "Entrez le critère (a,b,c ou d) : ";
  fscanf(STDIN,"%s",$critere);
  $critere=$critere[0];
  switch ($critere)
  {
    case 'a' : echo "Identifiant : "; break;
    case 'b' : echo "Nom         : "; break;
    case 'c' : echo "Prénom      : "; break;
    case 'd' : echo "Age         : "; break;
    default  : echo "Choix erroné !".PHP_EOL; break;
  }
  if (($critere >='a') && ($critere <='d'))
  {
   $valeur_recherche=fgets(STDIN);
   trim($valeur_recherche);
   $tab_critere_retour[0]=$critere;
   $tab_critere_retour[1]=$valeur_recherche;
  }
 return $tab_critere_retour;
}

// ================================
// --- Recherche sur critere ---
// ================================
function Recherche_sur_critere($bdd,$nom_table,$crit_recherche,$val_recherche)
{
  switch($crit_recherche)
  {
    case 'a':$nom_champ='ID'    ;$val_recherche=intval($val_recherche);break;
    case 'b':$nom_champ='Nom'   ;$val_recherche="'%".normalisation_nom($val_recherche)."%'";break;
    case 'c':$nom_champ='Prenom';$val_recherche="'%".normalisation_nom($val_recherche)."%'";break;
    case 'd':$nom_champ='Age'   ;$val_recherche=intval($val_recherche);break;
  }
 // --- exécution de la requête ---
 $requete='SELECT * FROM '.$nom_table.' WHERE '.$nom_champ.' LIKE '.$val_recherche;
 $reponse = $bdd->query($requete);
 // --- traitement des erreurs de retour sur la requête ---
 if (!$reponse)
     throw new Exception('Problème de requête sur la table.');
 // ---retourne un tableau associatif ---
 $reponse->setFetchMode(PDO::FETCH_ASSOC); 
 // --- boucle de traitement de chaque personne --- 
 $tab_personnes=$reponse->fetchAll();
 unset($tab_personnes_retourne);
 foreach($tab_personnes as $une_personne)
 {
    $numero=$une_personne['ID'];
    $tab_personnes_retourne[$numero]=$une_personne;
 }
 return $tab_personnes_retourne;
}
?>
