<?php
// On démarre la session AVANT d'écrire du code HTML
// pour les varaibles de session
session_start();
include 'INCLUDE/MySQL_PDO_transaction_include_sprog_commun_web.php';
include 'INCLUDE/MySQL_PDO_transaction_include_param_dbb.php';
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Virement bancaire</title>
	<link href="CSS/MySQL_PDO_transaction.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
 <?php
 $ERR_TRAIT=false;
 // ---------------------------
 // --- Début du traitement ---
 // ---------------------------   
 // --------------------------------------------------------------
 // Cette page peut être appelée de plusieurs manières différentes
 // --------------------------------------------------------------
 if (!empty($_POST['confirmation_virement']))
 {
  if (isset($_POST['RepVir'])) $ConfirmationVirement = $_POST['RepVir'] ;
  else $ConfirmationVirement = 'non' ;
  if ($ConfirmationVirement == "oui")
  {
   $Num_Cpt_Debit            = $_SESSION['Num_Cpt_Debit']            ;
   $Num_Cpt_Credit           = $_SESSION['Num_Cpt_Credit']           ;
   $Montant_Virement_formate = $_SESSION['Montant_Virement_formate'] ;
   $Montant_Virement         = $_SESSION['Montant_Virement']         ;

   // === on gère le virement  dans une transaction SQL ===
   $virementOK=Virement($Num_Cpt_Debit,$Num_Cpt_Credit,$Montant_Virement);
   // -----------------------------------------------------
   if ($virementOK)
   {
    // --- on affiche le résultat du virement ---
    $Tab_deux_comptes[0]=Info_Compte($Num_Cpt_Debit);
    $Tab_deux_comptes[1]=Info_Compte($Num_Cpt_Credit);
    if (!$ERR_TRAIT)
      Affichage_Liste_Comptes("R&eacute;sultat : Virement de $Montant_Virement_formate, du compte $Num_Cpt_Debit -> le compte $Num_Cpt_Credit",$Tab_deux_comptes);
   }
  }
  else
  {
    $TitreMessage="Aucun virement"       ;
    $TexteMessage="Aucun virement n'a &eacute;t&eacute;  effectu&eacute; !";
    Affiche_Message_Erreur($TitreMessage,$TexteMessage);
  }
 }
 elseif (!empty($_POST['info_virement']))
 {
  // --- on récupère la variable de session le tableau des comptes ---
  $Tab_Tous_les_Comptes=$_SESSION['Tab_Tous_les_Comptes'] ;
  $Tab_Colonne_IDCpt=array_column($Tab_Tous_les_Comptes,'ID_Cpt');
  // --- initialisation des infos sur les comptes --- 
  $Infos_Cpt_Debit =array();
  $Infos_Cpt_Credit=array();
  // --- on récupère les valeurs saisies ---
  if (isset($_POST['Num_Cpt_Debit'])) $Num_Cpt_Debit = $_POST['Num_Cpt_Debit'] ;
  else $Num_Cpt_Debit     = ''     ;
  if (isset($_POST['Num_Cpt_Credit'])) $Num_Cpt_Credit = $_POST['Num_Cpt_Credit'] ;
  else $Num_Cpt_Credit     = ''  ;
  if (isset($_POST['MtVir'])) $MtVir = $_POST['MtVir'] ;
  else $MtVir     = ''     ;
  // --- Protection de l'injection HTML ---
  $Num_Cpt_Debit  = strip_tags($Num_Cpt_Debit) ;
  $Num_Cpt_Credit = strip_tags($Num_Cpt_Credit);
  $MtVir          = strip_tags($MtVir)         ;
  // --- Normalisation au format entier ou réel ---
  $Num_Cpt_Debit  = intval($Num_Cpt_Debit)               ;
  $Num_Cpt_Credit = intval($Num_Cpt_Credit)              ;
  $MtVir          = floatval(str_replace(",",".",$MtVir));
  if (($Num_Cpt_Debit!=0) || ($Num_Cpt_Credit!=0) || ($MtVir!=0))
  {
   $Montant_Virement_formate=number_format($MtVir,2,","," ")." &euro;";
   // --- on récupère l'indice numérique de la case --- 
   $numcaseDebit  = array_search($Num_Cpt_Debit,$Tab_Colonne_IDCpt) ;
   $numcaseCredit = array_search($Num_Cpt_Credit,$Tab_Colonne_IDCpt);
   // --- array_search() retourne le numéro de la case du tableau --- 
   // --- ou bien false en cas d'échec --- 
   // --- attention il faut utiliser le triple = afin de résoudre --- 
   // --- le problème de la donnée trouvée dans la case 0  --- 
   // --- valeur qui peut être interprétée comme false si le test  --- 
   // --- est noté : if (!$numcaseDebit) --- 
   if ($numcaseDebit === false)
   {
    $TitreMessage = "Num&eacute;ro de compte invalide"       ;
    $TexteMessage = "Compte &agrave; d&eacute;biter num&eacute;ro $Num_Cpt_Debit inexistant !";
    Affiche_Message_Erreur($TitreMessage,$TexteMessage);
    $ERR_TRAIT    = true;
   }
   elseif ($numcaseCredit === false)
   {
    $TitreMessage = "Num&eacute;ro de compte invalide"       ;
    $TexteMessage = "Compte &agrave; cr&eacute;diter num&eacute;ro $Num_Cpt_Credit inexistant !";
    Affiche_Message_Erreur($TitreMessage,$TexteMessage);
    $ERR_TRAIT    = true;
   }
   else
   {
     // --- on affiche le résultat du virement ---
     $Tab_deux_comptes[0] = Info_Compte($Num_Cpt_Debit) ;
     $Tab_deux_comptes[1] = Info_Compte($Num_Cpt_Credit);
     if (!$ERR_TRAIT)
        Affichage_Liste_Comptes("R&eacute;sum&eacute; : Virement de $Montant_Virement_formate, du compte $Num_Cpt_Debit -> le compte $Num_Cpt_Credit",$Tab_deux_comptes);
     $_SESSION['Num_Cpt_Debit']            = $Num_Cpt_Debit            ;
     $_SESSION['Num_Cpt_Credit']           = $Num_Cpt_Credit           ;
     $_SESSION['Montant_Virement_formate'] = $Montant_Virement_formate ;
     $_SESSION['Montant_Virement']         = $MtVir                    ;
     ?>
     <br/>
     <!-- <form action="MySQL_PDO_transaction_secure_prepare_web.php" method="post"> -->
     <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
     <fieldset>
     <legend>Confirmation du virement</legend><br/>
     Merci de confirmer le virement :<br/>
     Oui <input type="radio" name="RepVir" value="oui"> 
     Non <input type="radio" name="RepVir" value="non" checked="checked"> <br/><br/>
     <input type="submit" name="confirmation_virement" value="Confirmer" />
     </fieldset>
     </form>
     <?php
   }
  }
 }
 else
 {
  // --- on affiche l'état des comptes AVANT la transaction ---
  $Tab_Tous_les_Comptes=Affiche_Etat_Comptes("Etat des comptes AVANT le virement");
  // --- on récupère la colonne des ID_Cpt ---
  if (!$ERR_TRAIT)
  {
   // --- on conserve dans une variable de session le tableau des comptes ---
   $_SESSION['Tab_Tous_les_Comptes']=$Tab_Tous_les_Comptes ;
   // affichage du formulaire de saisie
   ?>
   <br/>
   <!-- <form action="MySQL_PDO_transaction_secure_prepare_web.php" method="post"> -->
   <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
   <fieldset>
   <legend>Saisissez les informations du virement :</legend><br/>
   Num&eacute;ro (ID_Cpt) du compte &agrave; <b>d&eacute;biter</b> : <input type="text" name="Num_Cpt_Debit" size="3" maxlength="3" required pattern="[1-9][0-9]{0,2}" placeholder="7" autofocus/><br/><br/>
   Num&eacute;ro (ID_Cpt) du compte &agrave; <b>cr&eacute;diter</b>  : <input type="text" name="Num_Cpt_Credit""Num_Cpt_Debit"  size="3" maxlength="3" required pattern="[1-9][0-9]{0,2}" placeholder="12" /><br/><br/>
   <b>Montant du virement</b>  : <input type="text" name="MtVir" size="8" maxlength="8" placeholder="185,33" required pattern="[1-9][0-9\.\,]{0,7}" /> &euro;<br /><br />
   <input type="submit" name="info_virement" value="Effectuer le virement" />
   <!-- on ajoute le bouton terminer pour terminer la saisie  -->
   <input type="reset" value="Effacer le formulaire" />
   </fieldset>
   </form>
   <?php
  }
 }
 ?>
 </body>
</html>
