<?php
// On démarre la session AVANT d'écrire du code HTML
if (session_status() != PHP_SESSION_ACTIVE)
  session_start();
include 'INCLUDE/MySQL_PDO_transaction_include_param_dbb.php';
include 'INCLUDE/MySQL_PDO_transaction_include_sprog_commun_web.php';
//define("WEB_EOL","<br/>");
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
 <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
 <meta http-equiv="Content-Language" content="fr" />
 <title>Virement bancaire</title>
 <meta name="Description" content="Saisie du virement." />
 <link rel="stylesheet" type="text/css" href="CSS/virement_formulaire_ajax.css" />
 <script type="text/javascript" src="INCLUDE/MySQL_PDO_fonctions_ajax_query.js"></script>
 </head>
 <body>
  <?php
  $ERR_TRAIT            = false;
  $reinitialiser        = false;
  $Virement_a_Effectuer = false;
  $_SESSION['virement_effectue']=false;
  // --------------------------------------------------------------
  // --- traitement du formulaire posté par le bouton "Effacer" ---
  // --------------------------------------------------------------
  if(isset($_POST["Effacer"]))
  {
   // --- on réinitialise les variables de sessions ---
   $_SESSION["agenceD"] = 'vide';
   $_SESSION["clientD"] = 'vide';
   $_SESSION["compteD"] = 'vide';
   $_SESSION["agenceC"] = 'vide';
   $_SESSION["clientC"] = 'vide';
   $_SESSION["compteC"] = 'vide';
   unset($_SESSION["MtVir"]);
   unset($_POST["MtVir"]);
   $reinitialiser       = true  ;
  }
  // --------------------------------------------
  // --- récupération de la liste des agences ---
  // --------------------------------------------
  try
  {
  // === connexion de la base de données ===
  $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,$MDP_ADM,
                 array(PDO::ATTR_PERSISTENT => true));
  // --- initialisation des Exceptions PDO  ---
  $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  // --- définition du codage en UTF8 ---    
  $bdd->exec("SET CHARACTER SET utf8");
  // --- On sélectionnne toutes les agences ---
  $requete_sql='SELECT num_agence,nom_agence FROM agences_bancaires ORDER BY nom_agence';
  $RequeteQuery = $bdd->query($requete_sql);
  // ---retourne un tableau associatif ---
  $RequeteQuery->setFetchMode(PDO::FETCH_ASSOC); 
  // --- On range toutes les agences dans un tableau --- 
  $Liste_des_Agences=$RequeteQuery->fetchAll();
  // --- fermeture de la requête ---
  $RequeteQuery->closeCursor();   
  }
  catch(Exception $e)
  {
   $TitreMessage = "Acc&egrave;s base MySQL";
   $TexteMessage = $e->getMessage();
   Affiche_Message_Erreur($TitreMessage,$TexteMessage);
   $ERR_TRAIT=true;
  }   
  if (!$ERR_TRAIT)
  {
   ?>
   <div id="centre">
   <fieldset>
   <h1>Saisie du virement</h1>
   <!-- ----------------------------------------------- -->
   <!-- Début du formulaire avec des listes déroulantes -->
   <!-- ----------------------------------------------- -->
   <form method="post" name="liste">
   <!-- ======================== -->
   <!-- Pour le compte à débiter -->
   <!-- ======================== -->
   <?php
   $_SESSION["agenceD"]="vide";
   $_SESSION["clientD"]="vide";
   $_SESSION["compteD"]="vide";
   ?>
   <h3>Compte &agrave; d&eacute;biter</h3>
   <!-- Liste déroulante des agences -->
   <label>Agence : </label>
   <select name="agenceD" id="agenceD" onchange="FctAgenceDebit(this.value);">
   <?php
   if ($reinitialiser)
   {
    ?><option value="vide"  selected>--- Choisissez une agence ---</option><?php
   }
   else
   {
    ?><option value="vide">--- Choisissez une agence ---</option><?php
   }
   $Tab_Agences=$_SESSION['Tab_Agences'];
   // --- boucle de génération  de la liste déroulante ---
   foreach ($Liste_des_Agences as $num => $une_agence)
   {
    $Agence_Num      = $une_agence['num_agence'];
    $Agence_Nom      = $une_agence['nom_agence'];
    $CetteAgence['num_agence'] = $Agence_Num    ;
    $CetteAgence['nom_agence'] = $Agence_Nom    ;   
    echo '<option value="'.$une_agence['num_agence'].'"';
    // --- maintient de la sélection si elle a déjà été faite et qu'elle n'est pas réinitialisée ---
    if(isset($_POST["agenceD"]) && ($_POST["agenceD"]==$Agence_Num) && (!$reinitialiser))
    {
     echo " selected";
    }
    echo '>'.$Agence_Num." ".$Agence_Nom.'</option>';
    $Tab_Agences[$Agence_Num]=$CetteAgence;
   }
   $_SESSION['Tab_Agences']=$Tab_Agences;
   ?>
   </select><br/>
   <!-- ---------------------------------------- -->
   <!-- Bloc d'affichage de la liste des clients -->
   <!-- ---------------------------------------- -->
   <div id="blocClientDebit">
   <?php
   // --- Si la sélection de l'agence a été faite, on affiche la liste déroulante des clients ---
   // --- sinon il n'y a aucun affichage de la liste déroulante suivante ---
   if(isset($_POST['agenceD']))
   {
    // --- variable utilisée dans la page traitement_clients.php ---
    $include_clients_debit = 1;
    // --- On inclut le traitement pour la liste déroulante des clients ---
    include('traitement_clients_debit_query.php');
   }
   ?>
   </div>
   <!-- Débit : Fin du bloc des clients -->
  
   <!-- ========================= -->
   <!-- Pour le compte à créditer -->
   <!-- ========================= -->
   <?php
   $_SESSION["agenceC"]="vide";
   $_SESSION["clientC"]="vide";
   $_SESSION["compteC"]="vide";
   ?>
   <h3>Compte &agrave; cr&eacute;diter</h3>
   <!-- Liste déroulante des agences -->
   <label>Agence : </label>
   <select name="agenceC" id="agenceC" onchange="FctAgenceCredit(this.value);">
   <?php
   if ($reinitialiser)
   {
    ?>
    <option value="vide"  selected>--- Choisissez une agence ---</option>
    <?php
   }
   else
   {
    ?>
    <option value="vide">--- Choisissez une agence ---</option>
    <?php
   }
   $Tab_Agences=$_SESSION['Tab_Agences'];
   // --- boucle de génération  de la liste déroulante ---
   foreach ($Liste_des_Agences as $num => $une_agence)
   {
    $Agence_Num      = $une_agence['num_agence'];
    $Agence_Nom      = $une_agence['nom_agence'];
    $CetteAgence['num_agence'] = $Agence_Num    ;
    $CetteAgence['nom_agence'] = $Agence_Nom    ;   
    echo '<option value="'.$Agence_Num.'"';
    // --- maintient de la sélection si elle a déjà été faite et qu'elle n'est pas réinitialisée ---
    if(isset($_POST["agenceC"]) && ($_POST["agenceC"]==$Agence_Num) && (!$reinitialiser))
    {
     echo " selected";
    }
    echo '>'.$Agence_Num." ".$Agence_Nom.'</option>';
    $Tab_Agences[$Agence_Num]=$CetteAgence;
   }
   $_SESSION['Tab_Agences']=$Tab_Agences;
   ?>
   </select><br/>
   <!-- ---------------------------------------- -->
   <!-- Bloc d'affichage de la liste des clients -->
   <!-- ---------------------------------------- -->
   <div id="blocClientCredit">
   <?php
   // --- Si la sélection de l'agence a été faite, on affiche la liste déroulante des clients ---
   // --- sinon il n'y a aucun affichage de la liste déroulante suivante ---
   if(isset($_POST['agenceC']))
   {
    // --- variable utilisée dans la page traitement_clients.php ---
    $include_clients_credit = 1;
    // --- On inclut le traitement pour la liste déroulante des clients ---
    include('traitement_clients_credit_query.php');
   }
   ?>
   </div>
   <!-- Crédit : Fin du bloc des clients -->
   <h3>Montant du virement</h3>
   <label>Montant : </label>
   <input type="text" name="MtVir" value="<?php if (!empty($_POST["MtVir"])) echo $_POST["MtVir"]; else echo ""; ?>" size="8" maxlength="8" placeholder="185,33" required" /> &euro;
   <br /><br />
   <label>Valider : </label>
   <input type="submit" name="Valider" value="Valider"/>
   <!-- Le bouton Effacer est de type "submit" et non "reset" pour effectuer le traitement -->
   <!-- au début de l'appel de ce fichier -->
   <input type="submit" name="Effacer" value="Effacer"/>
   </form>
   <!-- Fin du formulaire -->
   <?php
   // --------------------------------------------------------------
   // --- traitement du formulaire posté par le bouton "Valider" ---
   // --------------------------------------------------------------
   if(isset($_POST["Valider"]))
   {
    $Tab_Clients=$_SESSION['Tab_Clients'];
    $Tab_Agences=$_SESSION['Tab_Agences'];
    
    if (isset($_POST["MtVir"]))
     $_SESSION["MtVir"]=floatval(str_replace(",",".",$_POST["MtVir"]));
    else
     unset($_SESSION["MtVir"]);
    // --- Débit : cas de la liste des agences  vide ---
    if(isset($_SESSION["agenceD"]) && $_SESSION["agenceD"] == 'vide')
    {
     echo '<br /><div id="erreur"> D&eacute;bit : Veuillez sélectionner une agence !</div>';
    }
    // --- Débit : cas de la liste des clients  vide ---
    else if(isset($_SESSION["clientD"]) && $_SESSION["clientD"] == 'vide')
    {
     $Agence_Num      = $_SESSION["agenceD"];
     $CetteAgence=$Tab_Agences[$Agence_Num];
     $Agence_Nom=$CetteAgence['nom_agence'];
     echo '<br /><div id="erreur">D&eacute;bit : Sélectionnez un client pour : '.$Agence_Num.' '.$Agence_Nom.' !</div>';
    }
    // --- Débit : cas de la liste des comptes  vide ---
    else if(isset($_SESSION["compteD"]) && $_SESSION["compteD"] == 'vide')
    {
     $Client_ID=$_SESSION["clientD"];
     $CeClient=$Tab_Clients[$Client_ID];
     $Client_Nom=$CeClient['Nom'];
     $Client_Prenom=$CeClient['Prenom'];
     echo '<br /><div id="erreur">D&eacute;bit : Sélectionnez un compte pour : '.$Client_Nom.' '.$Client_Prenom.' !</div>';
    }
    // --- Crédit : cas de la liste des agences  vide ---
    else if(isset($_SESSION["agenceC"]) && $_SESSION["agenceC"] == 'vide')
    {
     echo '<br /><div id="erreur"> Cr&eacute;dit : Sélectionner une agence !</div>';
    }
    // --- Crédit : cas de la liste des clients  vide ---
    else if(isset($_SESSION["clientC"]) && $_SESSION["clientC"] == 'vide')
    {
     $Agence_Num      = $_SESSION["agenceC"];
     $CetteAgence=$Tab_Agences[$Agence_Num];
     $Agence_Nom=$CetteAgence['nom_agence'];
     echo '<br /><div id="erreur">Cr&eacute;dit : Sélectionnez un client pour : '.$Agence_Num.' '.$Agence_Nom.' !</div>';
    }
    // --- Crédit : cas de la liste des comptes  vide ---
    // --- cas de la liste des Client  vide ---
    else if(isset($_SESSION["compteC"]) && $_SESSION["compteC"] == 'vide')
    {
     $Client_ID=$_SESSION["clientC"];
     $CeClient=$Tab_Clients[$Client_ID];
     $Client_Nom=$CeClient['Nom'];
     $Client_Prenom=$CeClient['Prenom'];
     echo '<br /><div id="erreur">Cr&eacute;dit : Sélectionnez un compte pour : '.$Client_Nom.' '.$Client_Prenom.' !</div>';
    }
    else if (($_SESSION["agenceD"]==$_SESSION["agenceC"]) && ($_SESSION["clientD"]==$_SESSION["clientC"]) && ($_SESSION["compteD"]==$_SESSION["compteC"]))
    {
     echo '<br /><div id="erreur">D&eacute;cit et Cr&eacute;dit sur le m&ecirc;me compte impossible !!!</div>';
    }
    else if ($_SESSION["MtVir"]==0)
    {
     echo '<br /><div id="erreur">Virement : Indiquez un montant !</div>';
    }
    // --------------------------
    // -- on fait le virement ---
    // --------------------------
    else
    {
      // --- on récupère les différentes  variables de session ---
      $agenceD = $_SESSION["agenceD"];
      $clientD = $_SESSION["clientD"];
      $compteD = $_SESSION["compteD"];
      $agenceC = $_SESSION["agenceC"];
      $clientC = $_SESSION["clientC"];
      $compteC = $_SESSION["compteC"];
      $Montant_Virement         = $_SESSION["MtVir"];
      $Montant_Virement_formate = number_format($Montant_Virement,2,","," ")." &euro;";
      // --- Pour information : on peut afficher un récapitulatif des données saisies
      // --- sans faire le traitement => vérification des données seulement
      // --- pour voir ce récapitulatif, il faut :
      //        1- décommenter la partie ci-dessous contenant les lignes commençant par echo
      //        2- et mettre en commentaire ligne de redirection_immediate() ci-après pour éviter le traitement
      // a décommenter si l'affichage du récapitulatif est souhaité
      /*
      echo '<br />';
      echo '<div id="info">Informations techniques :</div>';
      echo '<div id="info">D&eacutebit : agence : '.$agenceD.' - client : '.$clientD.' - compte : '.$compteD.'</div>';
      echo '<div id="info">Cr&eacutedit : agence : '.$agenceC.' - client : '.$clientC.' - compte : '.$compteC.'</div>';
      echo '<div id="info">Montant virement : '.$Montant_Virement_formate.'</div>';
      */
      $Virement_a_Effectuer=true;
      // --- données à transmettre au programme suivant ---
      $_SESSION["Num_Cpt_Debit"]            = $compteD                 ;
      $_SESSION["Num_Cpt_Credit"]           = $compteC                 ;
      $_SESSION["Montant_Virement"]         = $Montant_Virement        ;
      $_SESSION["Montant_Virement_formate"] = $Montant_Virement_formate;
      // --------------------------------------------------------
      // --- redirection vers l'URL de traitement du virement ---
      // --- commenter la ligne ci-dessous si l'affichage du récapitulatif est souhaité => pas de traitement
      redirection_immediate("MySQL_PDO_transaction_secure_prepare_ajax_web.php");
      // --------------------------------------------------------
    }
   }
   ?>
   </fliedset>
   </div>
  <?php
  }
  ?>
 </body>
</html>