<?php
// On démarre la session AVANT d'écrire du code HTML
if (session_status() != PHP_SESSION_ACTIVE)
  session_start();
//include 'INCLUDE/MySQL_PDO_transaction_include_sprog_commun_web.php';
include 'INCLUDE/MySQL_PDO_transaction_include_param_dbb.php';
//define("WEB_EOL","<br/>");
// --- Numéro du client ---
if(isset($_POST["clientD"]) && $_POST["clientD"] != 'vide')
{
 $contexte="Débit - Compte : MySQL";
 try
 {
  // -- Si la variable $include_comptes_debit n'existe pas,
  // -- c'est que le numéro du client est envoyé par AJAX,
  // -- On a alors besoin d'avoir une connexion avec la base de données.
  // -- Quand on poste le formulaire, cette page est inclue directement dans le div "blocCompteDebit",
  // -- la connexion devient inutile.
  // -- Si on inclut cette page au moment de la validation,
  // -- c'est uniquement pour garder la sélection "selected" de la liste.
  if(!isset($include_comptes_debit))
  {
   // --- On indique le Content-Type utilisé ---
   header('Content-Type: text/html; charset="utf-8"');
   // === connexion de la base de données ===
   $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,$MDP_ADM,
                  array(PDO::ATTR_PERSISTENT => true));
   // --- initialisation des Exceptions PDO  ---
   $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
   // --- définition du codage en UTF8 ---    
   $bdd->exec("SET CHARACTER SET utf8");
  }
  $clientD=$_POST["clientD"]   ;
  $_SESSION["clientD"]=$clientD;
  $agenceD=$_SESSION["agenceD"];
  ?>
  <!-- Liste déroulante des comptes -->
  <label>Compte : </label>
  <select name="compteD" id="compteD" >
  <?php
  if ($reinitialiser)
  {
   ?>
   <option value="vide"  selected>--- Choisissez un compte ---</option>
   <?php
  }
  else
  {
   ?>
   <option value="vide">--- Choisissez un compte ---</option>
   <?php
  }
  // --- on récupère la liste des comptes uniquement pour cette agence et ce client ---
  // --- on exclu le type "Carte_Différé" qui correspond à une carte de crédit addosée à un compte courant ---
  // --- et qui ne peut être utilisée dans un virement ---
  // --- préparation de la requête ---
  $requete_sql='SELECT ID_Cpt,Numero,Libelle,Solde  FROM '.$TABLECOMPTES.' WHERE Agence=:agenceD AND ID_Clt=:clientD AND Type<>"Carte_Différé" ORDER BY Libelle';
  $RequetePreparee = $bdd->prepare($requete_sql);
  // --- liaison avec les paramètres ---
  $RequetePreparee->bindParam(':agenceD', $agenceD, PDO::PARAM_STR);
  $RequetePreparee->bindParam(':clientD', $clientD, PDO::PARAM_INT);
  // --- exécution de la requête ---
  $RequetePreparee->execute();
  // ---retourne un tableau associatif ---
  $RequetePreparee->setFetchMode(PDO::FETCH_ASSOC); 
  // --- boucle de traitement de chaque compte --- 
  $Liste_Comptes_dans_Client=$RequetePreparee->fetchAll();
  // --- fermeture de la requête ---
  $RequetePreparee->closeCursor();
  // --- boucle de génération  de la liste déroulante ---
  foreach ($Liste_Comptes_dans_Client as $num => $un_compte)
  {
   echo '<option value="'.$un_compte['ID_Cpt'].'"';
   if(isset($_POST["compteD"]) && ($_POST["compteD"]==$un_compte['ID_Cpt']) && (!$reinitialiser)){ echo " selected"; }
   echo '>';
   echo $un_compte['Numero']." ".$un_compte['Libelle']." : ";
   echo number_format($un_compte['Solde'],2,","," ")." &euro;";
   echo '</option>';
  }
  ?>
  </select><br/>
  <?php
 }
 catch(Exception $e)
 {
  $TitreMessage = $contexte       ;
  $TexteMessage = $e->getMessage();
  echo '<br /><div id="erreur">'.$TitreMessage.' : '.$TexteMessage.'</div>';
 }   
}
?>