<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Affichage de la table personnes</title>
    <link href="../../CSS/MySQL.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   include '../../INCLUDE/MySQL_include_param_dbb.php';
   include '../../INCLUDE/MySQL_include_sprog_commun_web.php';
   try{
    // ----------------------------------------------------
    // --- affichage de la liste complète des personnes ---
    // ----------------------------------------------------
    if (empty($_POST['valider']))
    {
     // === connexion de la base de données ===
     $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,$MDP_ADM,
            array(PDO::ATTR_PERSISTENT => true));
     // --- définition du codage en UTF8 ---
     $bdd->exec("SET CHARACTER SET utf8");
     // --- exécution de la requête ---
     $reponse = $bdd->query('SELECT * FROM personnes');
     // --- traitement des erreurs de retour sur la requête ---
     if (!$reponse)
        throw new Exception('Problème de requête sur la table.');
     // ---retourne un tableau associatif ---
     $reponse->setFetchMode(PDO::FETCH_ASSOC); 
     // --- boucle de traitement de chaque personne --- 
     $tab_personnes=$reponse->fetchAll();
     // --- affichage des données retournées ---
     affichage_liste_personnes("Liste des personnes",$tab_personnes);
     // --- fermeture de la requête ---
     // --- pour permettre d'autres requêtes ---
     $reponse->closeCursor();
     ?>
     <!--
     ---------------------------------------------------
     --- formulaire de saisie du critère de filtrage ---
     ---------------------------------------------------
     -->
     <form action="MySQL_PDO_query_fetch_where_personnes_web.php" method="post">
      <fieldset>
      <legend>Saisissez les donn&eacute;es pour un filtrage :</legend><br/>
      Entrez l'&acirc;ge de s&eacute;lection (ex : 54) : <input type="text" name="Age_Min" size="3" maxlength="3" pattern="[1-9][0-9]{1,2}" /><br/><br/>
      <input type="submit" name="valider" value="Valider le filtrage" />
      <input type="reset" value="Effacer le formulaire" />
      </fieldset>
     </form>
     <?php
    }
    else
    {
     // -------------------------------------------------------------------------
     // --- affichage de la liste des personnes selon le critère de sélection ---
     // -------------------------------------------------------------------------
     // --- récupération de la variable Age_Min ---
     $Age_Min=$_POST['Age_Min'];
     $Age_Min=intval($Age_Min);
     // === connexion de la base de données ===
     $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,$MDP_ADM,
            array(PDO::ATTR_PERSISTENT => true));
     // --- définition du codage en UTF8 ---    
     $bdd->exec("SET CHARACTER SET utf8");
     // --- exécution de la requête ---
     $reponse = $bdd->query('SELECT * FROM personnes WHERE Age>='.$Age_Min);
     // --- traitement des erreurs de retour sur la requête ---
     if (!$reponse)
        throw new Exception('Problème de requête sur la table.');
     // ---retourne un tableau associatif ---
     $reponse->setFetchMode(PDO::FETCH_ASSOC); 
     // --- boucle de traitement de chaque personne --- 
     $tab_personnes=$reponse->fetchAll();
     // --- affichage des données retournées ---
     affichage_liste_personnes("Personnes ayant un Age >= $Age_Min",$tab_personnes);
     // --- fermeture de la requête ---
     // --- pour permettre d'autres requêtes ---
     $reponse->closeCursor();
    }
   }
   catch(Exception $e){
     echo "<fieldset>";
     echo "<legend>Erreur d'accès aux données :</legend>".WEB_EOL;
     echo 'Erreur : '.$e->getMessage().WEB_EOL;
     echo "</fieldset>";
   }
   ?>
 </body>
</html>







