<?php
// On démarre la session AVANT d'écrire du code HTML
// afin de conserver l'information indiquant si c'est le premier accès
session_start();
?>
<!DOCTYPE html>
<html>
 <head> <!-- Entête HTML -->
    <meta charset="utf-8" />
    <title>Saisie de plusieurs personnes</title>
    <link href="../../CSS/MySQL.css" rel="stylesheet" type="text/css" /> 
 </head>
 <body>
   <?php
   include '../../INCLUDE/MySQL_include_param_dbb.php';
   include '../../INCLUDE/MySQL_include_sprog_commun_web.php';
   setlocale (LC_ALL, 'fr_FR.UTF-8');
   try {
    // === connexion de la base de données ===
    $bdd = new PDO($TYPE_DBB.":host=".$SERVEUR.";dbname=".$BASEDD,$LOGIN_ADM,$MDP_ADM,
                   array(PDO::ATTR_PERSISTENT => true));
     // --- définition du codage en UTF8 ---
    $bdd->exec("SET CHARACTER SET utf8");
    // ---------------------------
    // --- Début du traitement ---
    // ---------------------------   
    // --------------------------------------------------------------
    // Cette page peut être appelée de plusieurs manières différentes
    // --------------------------------------------------------------
    if (!empty($_POST['confirmer_suppression']))
    {
     // --------------------------------------------------------------
     // Traitement de la réponse à la confirmation de suppression
     // --------------------------------------------------------------
     $Reponse_Suppression=$_POST['RepSuppr'];
     // --- Protection de l'injection HTML ---
     $Reponse_Suppression = strip_tags($Reponse_Suppression);
     if ($Reponse_Suppression == "oui")
     {
      // --------------------------------
      // La réponse est oui : on supprime
      // --------------------------------
      // --- on récupère le numéro de la personne à supprimer ---
      $numero_suppression=$_SESSION['numero_suppression'];
      // --- on récupère le tableau des personnes trouvées ---
      $tab_personnes_trouvees= $_SESSION['tab_personnes_trouvees'] ;
      $tab_a_Supprimer[$numero_suppression]=$tab_personnes_trouvees[$numero_suppression];
      affichage_tab_personnes("Cette personne a &eacute;t&eacute; supprim&eacute;e",$tab_a_Supprimer);
      // -------------------------------     
      // --- exécution de la requête ---
      // -------------------------------     
      $requete='DELETE FROM personnes WHERE ID='.$numero_suppression;
      $reponse = $bdd->exec($requete);
      if (!$reponse)
      {
          throw new Exception('Problème de requête sur la table.'.WEB_EOL);
      }
     }
     else
     {
      // ------------------------------------
      // La réponse est non : on ne fait rien
      // ------------------------------------
      ?>
      <fieldset>
      <legend>Aucune personne supprim&eacute;e :</legend><br/>
      <b>Aucune personne n'a &eacute;t&eacute; supprim&eacute;e ! </b><br />
      </fieldset>
      <?php
     }
    }
    elseif (!empty($_POST['choix_suppression_personne']))
    {
     // --------------------------------------------------------------
     // cas où la personne à supprimer a été sélectionnée
     // on demande la confirmation de la suppression
     // --------------------------------------------------------------
     // --- on récupère le tableau des personnes trouvées ---
     $tab_personnes_trouvees= $_SESSION['tab_personnes_trouvees'] ;
     // --- on récupère le numéro de la personne à supprimer ---
     $numero_suppression=$_POST['NumSuppr']                       ;
     // --- Protection de l'injection HTML ---
     $numero_suppression = intval(strip_tags($numero_suppression));
     $_SESSION['numero_suppression']=$numero_suppression ;
     if ( (empty($numero_suppression)) || (!array_key_exists($numero_suppression,$tab_personnes_trouvees)) )
     {
      ?>
      <fieldset>
      <legend>Aucune s&eacute;lection :</legend><br/>
      <b>Aucune s&eacute;lection ! </b><br />
      </fieldset>
      <?php
     }
     else
     {
      unset($tab_une_personne);
      $tab_une_personne[]=$tab_personnes_trouvees[$numero_suppression];
      affichage_liste_personnes("Personne a supprimer",$tab_une_personne);
      ?>
      <br/>
      <form action="MySQL_PDO_suppression_personnes_web.php" method="post">
      <fieldset>
       <legend>Confirmation de la suppression</legend><br/>
       Merci de confirmer la suppression de cette personne :<br/>
       Oui <input type="radio" name="RepSuppr" value="oui"> 
       Non <input type="radio" name="RepSuppr" value="non" checked="checked"> <br/><br/>
       <input type="submit" name="confirmer_suppression" value="Confirmer" />
       </fieldset>
      </form>
      <?php
     }
    }
    elseif (!empty($_POST['rechercher_critere']))
    {
     // --------------------------------------------------------------
     // cas où le formulaire de saisie a été validé et on appelle
     // une nouvelle fois ce programme avec les données du formulaire
     // on affiche un formulaire pour sélectionner la personne à supprimer
     // parmi la liste des personnes affichées
     // --------------------------------------------------------------
     $crit_recherche = $_POST['CritRech'];
     $val_recherche  = $_POST['ValRech'] ;
     // --- Protection de l'injection HTML ---
     $crit_recherche = strip_tags($crit_recherche);
     $val_recherche  = strip_tags($val_recherche) ;
     // --- Recherche ---
     $tab_personnes_trouvees=Recherche_sur_critere($bdd,'personnes',$crit_recherche,$val_recherche);
     if (count($tab_personnes_trouvees) == 0)
     {
       ?>
       <fieldset>
       <legend>Aucune personne trouv&eacute;e :</legend><br/>
       <b>La recherche pour <?php echo "$crit_recherche=$val_recherche";?> n'a trouv&eacute; aucune personne ! </b><br />
       </fieldset>
       <?php
     }
     else
     {
       // --- on conserve dans une variable de session le tableau des personnes trouvées ---
       $_SESSION['tab_personnes_trouvees']=$tab_personnes_trouvees ;
       // --- affichage de la liste de personnes trouvées ---
       affichage_liste_personnes("Liste des personnes trouvées",$tab_personnes_trouvees);
       // affichage du formulaire de saisie de la personne à supprimer
       ?>
       <br/>
       <form action="MySQL_PDO_suppression_personnes_web.php" method="post">
        <fieldset>
        <legend>Saisissez le Num&eacute;ro (ID) de la personne &agrave; supprimer :</legend><br/>
        Entrez le <b>Num&eacute;ro</b> de la personne &agrave; supprimer : <input type="text" name="NumSuppr" size="20" maxlength="20" autofocus/><br/><br/>
        <input type="submit" name="choix_suppression_personne" value="Supprimer" />
        <input type="reset" value="Effacer le formulaire" />
        </fieldset>
       </form>
       <?php
     }
    }
    else
    {
     // -----------------------------------------------
     // cas où on doit afficher le formulaire de saisie
     // pour rechercher la personne à supprimer
     // -----------------------------------------------
     ?>
     <br/>
     <form action="MySQL_PDO_suppression_personnes_web.php" method="post">
     <fieldset>
     <legend>Saisissez les crit&egrave;res de recherche :</legend><br/>
     S&eacute;lectionnez le crit&egrave;re de recherche : <br/><br/>
     Identifiant <input type="radio" name="CritRech" value="ID"> 
     Nom <input type="radio" name="CritRech" value="Nom" checked="checked"> 
     Pr&eacute;nom <input type="radio" name="CritRech" value="Prenom"> 
     Age <input type="radio" name="CritRech" value="Age"> <br/><br/>
     Entrez la valeur selon le crit&egrave;re : <input type="text" name="ValRech" size="20" maxlength="20" autofocus/><br/><br/>
     <input type="submit" name="rechercher_critere" value="Rechercher" />
     <input type="reset" value="Effacer le formulaire" />
     </fieldset>
     </form>
     <?php
    }
   }
   catch(Exception $e) {
    echo "<fieldset>";
    echo "<legend>Erreur :</legend><br/>";
    echo $e->getMessage();
    echo "</fieldset>";
   }
   ?>
 </body>
</html>
